/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.builder;

import com.aspectran.core.adapter.ApplicationAdapter;
import com.aspectran.core.component.Component;
import com.aspectran.core.component.bean.BeanRuleRegistry;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.builder.AbstractActivityContextBuilder;
import com.aspectran.core.context.builder.ActivityContextBuilderException;
import com.aspectran.core.context.env.EnvironmentProfiles;
import com.aspectran.core.context.rule.assistant.ActivityRuleAssistant;
import com.aspectran.core.context.rule.params.AspectranParameters;
import com.aspectran.core.context.rule.parser.HybridActivityContextParser;
import com.aspectran.core.service.AbstractCoreService;
import com.aspectran.core.util.Assert;
import com.aspectran.core.util.ShutdownHook;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import java.util.concurrent.atomic.AtomicBoolean;

public class HybridActivityContextBuilder
extends AbstractActivityContextBuilder {
    private static final Logger logger = LoggerFactory.getLogger(HybridActivityContextBuilder.class);
    private final AbstractCoreService coreService;
    private volatile ActivityContext activityContext;
    private final AtomicBoolean active = new AtomicBoolean();
    private final Object buildDestroyMonitor = new Object();
    private ShutdownHook.Task shutdownTask;

    public HybridActivityContextBuilder() {
        this.coreService = null;
    }

    public HybridActivityContextBuilder(AbstractCoreService coreService) {
        this.coreService = coreService;
        this.setServiceController(coreService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityContext build(AspectranParameters aspectranParameters) throws ActivityContextBuilderException {
        Object object = this.buildDestroyMonitor;
        synchronized (object) {
            this.setAspectranParameters(aspectranParameters);
            return this.doBuild();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityContext build(String rootFile) throws ActivityContextBuilderException {
        Object object = this.buildDestroyMonitor;
        synchronized (object) {
            this.setRootFile(rootFile);
            return this.doBuild();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityContext build() throws ActivityContextBuilderException {
        Object object = this.buildDestroyMonitor;
        synchronized (object) {
            return this.doBuild();
        }
    }

    private ActivityContext doBuild() throws ActivityContextBuilderException {
        try {
            Assert.state(!this.active.get(), "ActivityContext is already configured");
            String rootFile = this.getRootFile();
            AspectranParameters aspectranParameters = this.getAspectranParameters();
            if (rootFile != null) {
                logger.info("Building ActivityContext with " + rootFile);
            } else if (aspectranParameters != null) {
                logger.info("Building ActivityContext with specified AspectranParameters");
            } else {
                logger.info("No rootFile or aspectranParameters specified");
            }
            if (this.getActiveProfiles() != null) {
                logger.info("Activating profiles [" + StringUtils.joinCommaDelimitedList(this.getActiveProfiles()) + "]");
            }
            if (this.getDefaultProfiles() != null) {
                logger.info("Default profiles [" + StringUtils.joinCommaDelimitedList(this.getDefaultProfiles()) + "]");
            }
            long startTime = System.currentTimeMillis();
            ApplicationAdapter applicationAdapter = this.createApplicationAdapter();
            EnvironmentProfiles environmentProfiles = this.createEnvironmentProfiles();
            ActivityRuleAssistant assistant = new ActivityRuleAssistant(applicationAdapter, environmentProfiles);
            assistant.ready();
            if (this.getBasePackages() != null) {
                BeanRuleRegistry beanRuleRegistry = assistant.getBeanRuleRegistry();
                beanRuleRegistry.scanConfigurableBeans(this.getBasePackages());
            }
            if (rootFile != null || aspectranParameters != null) {
                HybridActivityContextParser parser = new HybridActivityContextParser(assistant);
                parser.setEncoding(this.getEncoding());
                parser.setUseXmlToApon(this.isUseAponToLoadXml());
                parser.setDebugMode(this.isDebugMode());
                if (rootFile != null) {
                    parser.parse(rootFile);
                } else {
                    parser.parse(aspectranParameters);
                }
                assistant = parser.getContextRuleAssistant();
                assistant.clearCurrentRuleAppender();
            }
            this.activityContext = this.createActivityContext(assistant);
            assistant.release();
            if (this.coreService != null) {
                this.coreService.setActivityContext(this.activityContext);
                this.activityContext.setRootService(this.coreService);
            }
            ((Component)((Object)this.activityContext)).initialize();
            long elapsedTime = System.currentTimeMillis() - startTime;
            logger.info("ActivityContext build completed in " + elapsedTime + " ms");
            if (this.coreService == null) {
                this.registerDestroyTask();
            } else {
                this.startContextReloader();
            }
            this.active.set(true);
            return this.activityContext;
        }
        catch (Exception e) {
            throw new ActivityContextBuilderException("Failed to build ActivityContext", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.buildDestroyMonitor;
        synchronized (object) {
            this.doDestroy();
            this.removeDestroyTask();
        }
    }

    private void doDestroy() {
        if (this.active.get()) {
            this.stopContextReloader();
            if (this.activityContext != null) {
                ((Component)((Object)this.activityContext)).destroy();
                this.activityContext = null;
            }
            if (this.coreService != null) {
                this.coreService.setActivityContext(null);
            }
            this.active.set(false);
        }
    }

    private void registerDestroyTask() {
        if (this.shutdownTask == null) {
            this.shutdownTask = ShutdownHook.addTask(() -> {
                Object object = this.buildDestroyMonitor;
                synchronized (object) {
                    this.doDestroy();
                    this.removeDestroyTask();
                }
            });
        }
    }

    private void removeDestroyTask() {
        if (this.shutdownTask != null) {
            ShutdownHook.removeTask(this.shutdownTask);
            this.shutdownTask = null;
        }
    }

    @Override
    public boolean isActive() {
        return this.active.get();
    }
}

