/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.expr.ognl;

import com.aspectran.core.context.expr.ExpressionParserException;
import com.aspectran.core.context.expr.ognl.OgnlClassResolver;
import com.aspectran.core.context.expr.ognl.OgnlMemberAccess;
import com.aspectran.core.util.ConcurrentReferenceHashMap;
import com.aspectran.core.util.StringUtils;
import java.util.Map;
import ognl.ClassResolver;
import ognl.MemberAccess;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;

public class OgnlSupport {
    private static final OgnlClassResolver CLASS_RESOLVER = new OgnlClassResolver();
    private static final OgnlMemberAccess MEMBER_ACCESS = new OgnlMemberAccess();
    private static final Map<String, Object> cache = new ConcurrentReferenceHashMap<String, Object>();

    private OgnlSupport() {
    }

    public static Object parseExpression(String expression) throws ExpressionParserException {
        if (!StringUtils.hasLength(expression)) {
            return null;
        }
        try {
            Object existing;
            Object node = cache.get(expression);
            if (node == null && (existing = cache.putIfAbsent(expression, node = Ognl.parseExpression((String)expression))) != null) {
                node = existing;
            }
            return node;
        }
        catch (OgnlException e) {
            throw new ExpressionParserException(expression, e);
        }
    }

    public static OgnlContext createDefaultContext() {
        return new OgnlContext((ClassResolver)CLASS_RESOLVER, null, (MemberAccess)MEMBER_ACCESS);
    }
}

