/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.expr.token;

import com.aspectran.core.context.expr.token.InvalidTokenException;
import com.aspectran.core.context.rule.ability.BeanReferenceable;
import com.aspectran.core.context.rule.ability.Replicable;
import com.aspectran.core.context.rule.type.BeanRefererType;
import com.aspectran.core.context.rule.type.TokenDirectiveType;
import com.aspectran.core.context.rule.type.TokenType;
import com.aspectran.core.util.ToStringBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class Token
implements BeanReferenceable,
Replicable<Token> {
    private static final BeanRefererType BEAN_REFERER_TYPE = BeanRefererType.TOKEN;
    public static final char BEAN_SYMBOL = '#';
    public static final char PARAMETER_SYMBOL = '$';
    public static final char ATTRIBUTE_SYMBOL = '@';
    public static final char PROPERTY_SYMBOL = '%';
    public static final char TEMPLATE_SYMBOL = '~';
    public static final char BRACKET_OPEN = '{';
    public static final char BRACKET_CLOSE = '}';
    public static final char VALUE_SEPARATOR = ':';
    public static final char GETTER_SEPARATOR = '^';
    private final TokenType type;
    private TokenDirectiveType directiveType;
    private final String name;
    private String value;
    private Object alternativeValue;
    private String getterName;
    private String defaultValue;

    public Token(String defaultValue) {
        this.type = TokenType.TEXT;
        this.name = null;
        this.defaultValue = defaultValue;
    }

    public Token(TokenType type, String name) {
        if (type == TokenType.TEXT) {
            throw new UnsupportedOperationException();
        }
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        this.type = type;
        this.name = name;
    }

    public Token(TokenType type, TokenDirectiveType directiveType, String value) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        if (directiveType == null) {
            throw new IllegalArgumentException("directiveType must not be null");
        }
        this.type = type;
        this.directiveType = directiveType;
        this.name = directiveType.toString();
        this.value = value;
    }

    public TokenType getType() {
        return this.type;
    }

    public TokenDirectiveType getDirectiveType() {
        return this.directiveType;
    }

    private void setDirectiveType(TokenDirectiveType directiveType) {
        this.directiveType = directiveType;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getGetterName() {
        return this.getterName;
    }

    public Object getAlternativeValue() {
        return this.alternativeValue;
    }

    public void setAlternativeValue(Object value) {
        this.alternativeValue = value;
    }

    public void setGetterName(String getterName) {
        this.getterName = getterName;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public BeanRefererType getBeanRefererType() {
        return BEAN_REFERER_TYPE;
    }

    public String stringify() {
        if (this.type == TokenType.TEXT) {
            return this.defaultValue;
        }
        StringBuilder sb = new StringBuilder();
        if (this.type == TokenType.BEAN) {
            sb.append('#');
            sb.append('{');
            if (this.name != null) {
                sb.append(this.name);
            }
            if (this.value != null) {
                sb.append(':');
                sb.append(this.value);
            }
            if (this.getterName != null) {
                sb.append('^');
                sb.append(this.getterName);
            }
        } else if (this.type == TokenType.TEMPLATE) {
            sb.append('~');
            sb.append('{');
            if (this.name != null) {
                sb.append(this.name);
            }
        } else if (this.type == TokenType.PARAMETER) {
            sb.append('$');
            sb.append('{');
            if (this.name != null) {
                sb.append(this.name);
            }
        } else if (this.type == TokenType.ATTRIBUTE) {
            sb.append('@');
            sb.append('{');
            if (this.name != null) {
                sb.append(this.name);
            }
            if (this.getterName != null) {
                sb.append('^');
                sb.append(this.getterName);
            }
        } else if (this.type == TokenType.PROPERTY) {
            sb.append('%');
            sb.append('{');
            if (this.name != null) {
                sb.append(this.name);
            }
            if (this.value != null) {
                sb.append(':');
                sb.append(this.value);
            }
            if (this.getterName != null) {
                sb.append('^');
                sb.append(this.getterName);
            }
        } else {
            throw new InvalidTokenException("Unknown token type: " + (Object)((Object)this.type), this);
        }
        if (this.defaultValue != null) {
            sb.append(':');
            sb.append(this.defaultValue);
        }
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object token) {
        return this == token || token instanceof Token && this.deepEquals((Token)token);
    }

    private boolean deepEquals(Token token) {
        if (this.type != token.getType()) {
            return false;
        }
        if (this.name != null ? !this.name.equals(token.getName()) : token.getName() != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(token.getValue()) : token.getValue() != null) {
            return false;
        }
        if (this.getterName != null ? !this.getterName.equals(token.getGetterName()) : token.getGetterName() != null) {
            return false;
        }
        return !(this.defaultValue != null ? !this.defaultValue.equals(token.getDefaultValue()) : token.getDefaultValue() != null);
    }

    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.getterName != null ? this.getterName.hashCode() : 0);
        result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
        return result;
    }

    @Override
    public Token replicate() {
        Token token;
        if (this.directiveType != null) {
            token = new Token(this.type, this.directiveType, this.value);
            token.setAlternativeValue(this.alternativeValue);
            token.setGetterName(this.getterName);
            token.setDefaultValue(this.defaultValue);
        } else if (this.type == TokenType.TEXT) {
            token = new Token(this.defaultValue);
        } else {
            token = new Token(this.type, this.name);
            token.setGetterName(this.getterName);
            token.setDefaultValue(this.defaultValue);
        }
        return token;
    }

    public Token[] replicate(Token[] tokens) {
        if (tokens == null) {
            return null;
        }
        Token[] newTokens = new Token[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            newTokens[i] = tokens[i].replicate();
        }
        return newTokens;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("type", (Object)this.type);
        tsb.append("name", this.name);
        tsb.append("value", this.value);
        tsb.append("getterName", this.getterName);
        tsb.append("defaultValue", this.defaultValue);
        return tsb.toString();
    }

    public static boolean isTokenSymbol(char c) {
        return c == '#' || c == '~' || c == '$' || c == '@' || c == '%';
    }

    public static boolean hasToken(String expression) {
        char[] ca = expression.toCharArray();
        boolean open = false;
        for (int i = 1; i < ca.length; ++i) {
            if (Token.isTokenSymbol(ca[i - 1]) && ca[i] == '{') {
                ++i;
                open = true;
                continue;
            }
            if (!open || ca[i] != '}') continue;
            return true;
        }
        return false;
    }

    public static TokenType resolveTypeAsSymbol(char symbol) {
        TokenType type;
        if (symbol == '#') {
            type = TokenType.BEAN;
        } else if (symbol == '~') {
            type = TokenType.TEMPLATE;
        } else if (symbol == '$') {
            type = TokenType.PARAMETER;
        } else if (symbol == '@') {
            type = TokenType.ATTRIBUTE;
        } else if (symbol == '%') {
            type = TokenType.PROPERTY;
        } else {
            throw new IllegalArgumentException("Unknown token symbol: " + symbol);
        }
        return type;
    }

    public static void resolveAlternativeValue(Token token, ClassLoader classLoader) {
        if (token != null && token.getType() == TokenType.BEAN) {
            if (token.getDirectiveType() == TokenDirectiveType.FIELD) {
                if (token.getGetterName() == null) {
                    throw new InvalidTokenException("Target field name is unspecified token", token);
                }
                try {
                    Class<?> cls = classLoader.loadClass(token.getValue());
                    Field field = cls.getField(token.getGetterName());
                    token.setAlternativeValue(field);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Unable to load class: " + token.getValue(), e);
                }
                catch (NoSuchFieldException e) {
                    throw new IllegalArgumentException("Could not access field: " + token.getGetterName(), e);
                }
            }
            if (token.getDirectiveType() == TokenDirectiveType.METHOD) {
                if (token.getGetterName() == null) {
                    throw new InvalidTokenException("Target method name is unspecified token", token);
                }
                try {
                    Class<?> cls = classLoader.loadClass(token.getValue());
                    Method method = cls.getMethod(token.getGetterName(), new Class[0]);
                    token.setAlternativeValue(method);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Unable to load class: " + token.getValue(), e);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException("Could not access method: " + token.getGetterName(), e);
                }
            }
            if (token.getDirectiveType() == TokenDirectiveType.CLASS) {
                try {
                    Class<?> cls = classLoader.loadClass(token.getValue());
                    token.setAlternativeValue(cls);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Unable to load class: " + token.getValue(), e);
                }
            }
        }
    }

    public static String format(TokenType type, String expression) {
        if (type == null) {
            throw new IllegalArgumentException("Token type must not be null");
        }
        if (type == TokenType.TEXT) {
            return expression;
        }
        StringBuilder sb = new StringBuilder();
        switch (type) {
            case BEAN: {
                sb.append('#');
                break;
            }
            case PARAMETER: {
                sb.append('$');
                break;
            }
            case ATTRIBUTE: {
                sb.append('@');
                break;
            }
            case PROPERTY: {
                sb.append('%');
                break;
            }
            case TEMPLATE: {
                sb.append('~');
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown token type: " + (Object)((Object)type));
            }
        }
        sb.append('{');
        if (expression != null) {
            sb.append(expression);
        }
        return sb.append('}').toString();
    }
}

