/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.resource;

import com.aspectran.core.context.resource.AspectranClassLoader;
import com.aspectran.core.context.resource.InvalidResourceException;
import com.aspectran.core.context.resource.ResourceManager;
import com.aspectran.core.util.ToStringBuilder;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class LocalResourceManager
extends ResourceManager {
    private static final Logger logger = LoggerFactory.getLogger(LocalResourceManager.class);
    private final String resourceLocation;
    private final int resourceNameStart;
    private final AspectranClassLoader owner;

    public LocalResourceManager(AspectranClassLoader owner) {
        this.owner = owner;
        this.resourceLocation = null;
        this.resourceNameStart = 0;
    }

    public LocalResourceManager(String resourceLocation, AspectranClassLoader owner) throws InvalidResourceException {
        this.owner = owner;
        if (resourceLocation != null && !resourceLocation.isEmpty()) {
            File file = new File(resourceLocation);
            if (!file.exists() || !file.canRead()) {
                logger.warn("Resource [" + resourceLocation + "] does not exist or you do not have access");
                this.resourceLocation = null;
                this.resourceNameStart = 0;
                return;
            }
            if (!file.isDirectory() && !resourceLocation.toLowerCase().endsWith(".jar")) {
                throw new InvalidResourceException("Invalid resource directory or jar file: " + file.getAbsolutePath());
            }
            this.resourceLocation = file.getAbsolutePath();
            this.resourceNameStart = this.resourceLocation.length() + 1;
            this.findResource(file);
        } else {
            this.resourceLocation = null;
            this.resourceNameStart = 0;
        }
    }

    @Override
    public void reset() throws InvalidResourceException {
        super.reset();
        if (this.resourceLocation != null) {
            this.findResource(new File(this.resourceLocation));
        }
    }

    private void findResource(File file) throws InvalidResourceException {
        try {
            if (file.isDirectory()) {
                ArrayList<File> jarFileList = new ArrayList<File>();
                this.findResourceInDir(file, jarFileList);
                if (!jarFileList.isEmpty()) {
                    for (File jarFile : jarFileList) {
                        this.owner.joinBrother(jarFile.getAbsolutePath());
                    }
                }
            } else {
                this.findResourceFromJAR(file);
            }
        }
        catch (Exception e) {
            throw new InvalidResourceException("Failed to find resource from [" + this.resourceLocation + "]", e);
        }
    }

    private void findResourceInDir(File dir, List<File> jarFileList) {
        dir.listFiles(file -> {
            String filePath = file.getAbsolutePath();
            String resourceName = filePath.substring(this.resourceNameStart);
            try {
                this.putResource(resourceName, file);
            }
            catch (InvalidResourceException e) {
                throw new RuntimeException(e);
            }
            if (file.isDirectory()) {
                this.findResourceInDir(file, jarFileList);
            } else if (file.isFile() && filePath.toLowerCase().endsWith(".jar")) {
                jarFileList.add(file);
            }
            return false;
        });
    }

    private void findResourceFromJAR(File target) throws InvalidResourceException, IOException {
        try (JarFile jarFile = new JarFile(target);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                this.putResource(target, entry);
            }
        }
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.appendForce("resourceLocation", this.resourceLocation);
        tsb.append("resourceEntries", this.getResourceEntries());
        tsb.append("owner", this.owner);
        return tsb.toString();
    }
}

