/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.resource;

import com.aspectran.core.context.resource.InvalidResourceException;
import com.aspectran.core.util.StringUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.jar.JarEntry;

public class ResourceEntries
extends LinkedHashMap<String, URL> {
    private static final long serialVersionUID = -6936820061673430782L;

    public void putResource(String resourceName, File file) throws InvalidResourceException {
        URL url;
        try {
            url = file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new InvalidResourceException("Invalid resource: " + file, e);
        }
        this.put(resourceName, url);
    }

    public void putResource(File file, JarEntry entry) throws InvalidResourceException {
        URL url;
        String resourceName = entry.getName();
        try {
            url = new URL("jar:" + file.toURI() + "!/" + resourceName);
        }
        catch (MalformedURLException e) {
            throw new InvalidResourceException("Invalid resource: " + file, e);
        }
        this.put(resourceName, url);
    }

    @Override
    public URL put(String resourceName, URL url) {
        if (StringUtils.endsWith(resourceName = resourceName.replace(File.separatorChar, '/'), '/')) {
            resourceName = resourceName.substring(0, resourceName.length() - 1);
        }
        return super.put(resourceName, url);
    }
}

