/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.component.bean.ablility.DisposableBean;
import com.aspectran.core.component.bean.ablility.FactoryBean;
import com.aspectran.core.component.bean.ablility.InitializableBean;
import com.aspectran.core.context.rule.AutowireRule;
import com.aspectran.core.context.rule.DescriptionRule;
import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.ParameterBindingRule;
import com.aspectran.core.context.rule.ability.BeanReferenceable;
import com.aspectran.core.context.rule.ability.Replicable;
import com.aspectran.core.context.rule.params.FilterParameters;
import com.aspectran.core.context.rule.type.BeanRefererType;
import com.aspectran.core.context.rule.type.ScopeType;
import com.aspectran.core.util.BooleanUtils;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.ToStringBuilder;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class BeanRule
implements Replicable<BeanRule>,
BeanReferenceable {
    public static final String CLASS_DIRECTIVE_PREFIX = "class:";
    private static final BeanRefererType BEAN_REFERER_TYPE = BeanRefererType.BEAN_RULE;
    private String id;
    private String className;
    private Class<?> beanClass;
    private String scanPattern;
    private String maskPattern;
    private FilterParameters filterParameters;
    private ScopeType scopeType;
    private Boolean singleton;
    private String factoryBeanId;
    private Class<?> factoryBeanClass;
    private String factoryMethodName;
    private Method factoryMethod;
    private ParameterBindingRule[] factoryMethodParameterBindingRules;
    private boolean factoryOffered;
    private Class<?> targetBeanClass;
    private String initMethodName;
    private Method initMethod;
    private ParameterBindingRule[] initMethodParameterBindingRules;
    private String destroyMethodName;
    private Method destroyMethod;
    private ItemRuleMap constructorArgumentItemRuleMap;
    private ItemRuleMap propertyItemRuleMap;
    private Boolean lazyInit;
    private Boolean lazyDestroy;
    private Boolean important;
    private boolean factoryBean;
    private boolean disposableBean;
    private boolean initializableBean;
    private boolean innerBean;
    private boolean replicated;
    private Boolean proxied;
    private List<AutowireRule> autowireRuleList;
    private AutowireRule constructorAutowireRule;
    private boolean constructorAutowireParsed;
    private boolean fieldAutowireParsed;
    private boolean methodAutowireParsed;
    private DescriptionRule descriptionRule;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public void setBeanClass(Class<?> beanClass) {
        this.beanClass = beanClass;
        this.className = beanClass.getName();
        this.factoryBean = FactoryBean.class.isAssignableFrom(beanClass);
        this.disposableBean = DisposableBean.class.isAssignableFrom(beanClass);
        this.initializableBean = InitializableBean.class.isAssignableFrom(beanClass);
    }

    public String getScanPattern() {
        return this.scanPattern;
    }

    public void setScanPattern(String scanPattern) {
        this.scanPattern = scanPattern;
    }

    public String getMaskPattern() {
        return this.maskPattern;
    }

    public FilterParameters getFilterParameters() {
        return this.filterParameters;
    }

    public void setFilterParameters(FilterParameters filterParameters) {
        this.filterParameters = filterParameters;
    }

    public void setMaskPattern(String maskPattern) {
        this.maskPattern = maskPattern;
    }

    public ScopeType getScopeType() {
        return this.scopeType;
    }

    public void setScopeType(ScopeType scopeType) {
        this.scopeType = scopeType;
    }

    public Boolean getSingleton() {
        return this.singleton;
    }

    public void setSingleton(Boolean singleton) {
        this.singleton = singleton;
    }

    public boolean isSingleton() {
        return this.scopeType == ScopeType.SINGLETON;
    }

    public String getFactoryBeanId() {
        return this.factoryBeanId;
    }

    public void setFactoryBeanId(String factoryBeanId) {
        this.factoryBeanId = factoryBeanId;
    }

    public Class<?> getFactoryBeanClass() {
        return this.factoryBeanClass;
    }

    public void setFactoryBeanClass(Class<?> factoryBeanClass) {
        this.factoryBeanClass = factoryBeanClass;
    }

    public String getFactoryMethodName() {
        return this.factoryMethodName;
    }

    public void setFactoryMethodName(String factoryMethodName) {
        this.factoryMethodName = factoryMethodName;
    }

    public Method getFactoryMethod() {
        return this.factoryMethod;
    }

    public void setFactoryMethod(Method factoryMethod) {
        this.factoryMethod = factoryMethod;
    }

    public ParameterBindingRule[] getFactoryMethodParameterBindingRules() {
        return this.factoryMethodParameterBindingRules;
    }

    public void setFactoryMethodParameterBindingRules(ParameterBindingRule[] parameterBindingRules) {
        this.factoryMethodParameterBindingRules = parameterBindingRules;
    }

    public boolean isFactoryOffered() {
        return this.factoryOffered;
    }

    public void setFactoryOffered(boolean factoryOffered) {
        this.factoryOffered = factoryOffered;
    }

    public boolean isFactoryProductionRequired() {
        return !this.isFactoryOffered() && (this.isFactoryBean() || this.getFactoryMethod() != null);
    }

    public Class<?> getTargetBeanClass() {
        return this.targetBeanClass != null ? this.targetBeanClass : this.beanClass;
    }

    public void setTargetBeanClass(Class<?> targetBeanClass) {
        this.targetBeanClass = targetBeanClass;
    }

    public String getTargetBeanClassName() {
        return this.targetBeanClass != null ? this.targetBeanClass.getName() : this.className;
    }

    public String getInitMethodName() {
        return this.initMethodName;
    }

    public void setInitMethodName(String initMethodName) {
        this.initMethodName = initMethodName;
    }

    public Method getInitMethod() {
        return this.initMethod;
    }

    public void setInitMethod(Method initMethod) {
        this.initMethod = initMethod;
    }

    public ParameterBindingRule[] getInitMethodParameterBindingRules() {
        return this.initMethodParameterBindingRules;
    }

    public void setInitMethodParameterBindingRules(ParameterBindingRule[] parameterBindingRules) {
        this.initMethodParameterBindingRules = parameterBindingRules;
    }

    public String getDestroyMethodName() {
        return this.destroyMethodName;
    }

    public void setDestroyMethodName(String destroyMethodName) {
        this.destroyMethodName = destroyMethodName;
    }

    public Method getDestroyMethod() {
        return this.destroyMethod;
    }

    public void setDestroyMethod(Method destroyMethod) {
        this.destroyMethod = destroyMethod;
    }

    public Boolean getLazyInit() {
        return this.lazyInit;
    }

    public void setLazyInit(Boolean lazyInit) {
        this.lazyInit = lazyInit;
    }

    public boolean isLazyInit() {
        return BooleanUtils.toBoolean(this.lazyInit);
    }

    public Boolean getLazyDestroy() {
        return this.lazyDestroy;
    }

    public void setLazyDestroy(Boolean lazyDestroy) {
        this.lazyDestroy = lazyDestroy;
    }

    public boolean isLazyDestroy() {
        return BooleanUtils.toBoolean(this.lazyDestroy);
    }

    public Boolean getImportant() {
        return this.important;
    }

    public void setImportant(Boolean important) {
        this.important = important;
    }

    public boolean isImportant() {
        return BooleanUtils.toBoolean(this.important);
    }

    public ItemRuleMap getConstructorArgumentItemRuleMap() {
        return this.constructorArgumentItemRuleMap;
    }

    public void setConstructorArgumentItemRuleMap(ItemRuleMap constructorArgumentItemRuleMap) {
        this.constructorArgumentItemRuleMap = constructorArgumentItemRuleMap;
    }

    public ItemRule newConstructorArgumentItemRule() {
        ItemRule itemRule = new ItemRule();
        itemRule.setAutoNamed(true);
        this.addConstructorArgumentItemRule(itemRule);
        return itemRule;
    }

    public void addConstructorArgumentItemRule(ItemRule constructorArgumentItemRule) {
        if (this.constructorArgumentItemRuleMap == null) {
            this.constructorArgumentItemRuleMap = new ItemRuleMap();
        }
        this.constructorArgumentItemRuleMap.putItemRule(constructorArgumentItemRule);
    }

    public ItemRuleMap getPropertyItemRuleMap() {
        return this.propertyItemRuleMap;
    }

    public void setPropertyItemRuleMap(ItemRuleMap propertyItemRuleMap) {
        this.propertyItemRuleMap = propertyItemRuleMap;
    }

    public ItemRule newPropertyItemRule(String propertyName) {
        ItemRule itemRule = new ItemRule();
        itemRule.setName(propertyName);
        this.addPropertyItemRule(itemRule);
        return itemRule;
    }

    public void addPropertyItemRule(ItemRule propertyItemRule) {
        if (this.propertyItemRuleMap == null) {
            this.propertyItemRuleMap = new ItemRuleMap();
        }
        this.propertyItemRuleMap.putItemRule(propertyItemRule);
    }

    public boolean isFactoryBean() {
        return this.factoryBean;
    }

    public boolean isDisposableBean() {
        return this.disposableBean;
    }

    public boolean isInitializableBean() {
        return this.initializableBean;
    }

    public boolean isInnerBean() {
        return this.innerBean;
    }

    public void setInnerBean(boolean innerBean) {
        this.innerBean = innerBean;
    }

    public boolean isReplicated() {
        return this.replicated;
    }

    public void setReplicated(boolean replicated) {
        this.replicated = replicated;
    }

    public boolean isProxied() {
        return BooleanUtils.toBoolean(this.proxied);
    }

    public Boolean getProxied() {
        return this.proxied;
    }

    public void setProxied(boolean proxied) {
        this.proxied = proxied;
    }

    public boolean isFactoryable() {
        return this.factoryOffered || this.factoryBean || this.factoryMethod != null;
    }

    public List<AutowireRule> getAutowireRuleList() {
        return this.autowireRuleList;
    }

    public void addAutowireRule(AutowireRule autowireRule) {
        if (this.autowireRuleList == null) {
            this.autowireRuleList = new ArrayList<AutowireRule>();
        }
        this.autowireRuleList.add(autowireRule);
    }

    public AutowireRule getConstructorAutowireRule() {
        return this.constructorAutowireRule;
    }

    public void setConstructorAutowireRule(AutowireRule constructorAutowireRule) {
        this.constructorAutowireRule = constructorAutowireRule;
    }

    public boolean isConstructorAutowireParsed() {
        return this.constructorAutowireParsed;
    }

    public void setConstructorAutowireParsed(boolean constructorAutowireParsed) {
        this.constructorAutowireParsed = constructorAutowireParsed;
    }

    public boolean isFieldAutowireParsed() {
        return this.fieldAutowireParsed;
    }

    public void setFieldAutowireParsed(boolean fieldAutowireParsed) {
        this.fieldAutowireParsed = fieldAutowireParsed;
    }

    public boolean isMethodAutowireParsed() {
        return this.methodAutowireParsed;
    }

    public void setMethodAutowireParsed(boolean methodAutowireParsed) {
        this.methodAutowireParsed = methodAutowireParsed;
    }

    public DescriptionRule getDescriptionRule() {
        return this.descriptionRule;
    }

    public void setDescriptionRule(DescriptionRule descriptionRule) {
        this.descriptionRule = descriptionRule;
    }

    @Override
    public BeanRule replicate() {
        return BeanRule.replicate(this);
    }

    @Override
    public BeanRefererType getBeanRefererType() {
        return BEAN_REFERER_TYPE;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("id", this.id);
        if (!this.factoryOffered) {
            tsb.append("class", this.className);
            tsb.append("scope", (Object)this.scopeType);
            tsb.append("initMethod", this.initMethodName);
            tsb.append("destroyMethod", this.destroyMethodName);
            tsb.append("factoryMethod", this.factoryMethodName);
            tsb.append("initializableBean", this.initializableBean);
            tsb.append("disposableBean", this.disposableBean);
            tsb.append("factoryBean", this.factoryBean);
            tsb.append("lazyInit", this.lazyInit);
            tsb.append("lazyDestroy", this.lazyDestroy);
            tsb.append("important", this.important);
            tsb.append("proxied", this.proxied);
            if (this.constructorArgumentItemRuleMap != null) {
                tsb.append("constructorArguments", this.constructorArgumentItemRuleMap.keySet());
            }
            if (this.propertyItemRuleMap != null) {
                tsb.append("properties", this.propertyItemRuleMap.keySet());
            }
        } else {
            tsb.append("scope", (Object)this.scopeType);
            tsb.append("factoryBean", this.factoryBeanId);
            tsb.append("factoryMethod", this.factoryMethodName);
            tsb.append("initMethod", this.initMethodName);
            tsb.append("destroyMethod", this.destroyMethodName);
            tsb.append("lazyInit", this.lazyInit);
            tsb.append("lazyDestroy", this.lazyDestroy);
            tsb.append("important", this.important);
            tsb.append("proxied", this.proxied);
        }
        tsb.append("factoryOffered", this.factoryOffered);
        return tsb.toString();
    }

    public static BeanRule newInstance(String id, String className, String scanPattern, String maskPattern, String initMethodName, String destroyMethodName, String factoryMethodName, String scope, Boolean singleton, Boolean lazyInit, Boolean lazyDestroy, Boolean important) throws IllegalRuleException {
        if (className == null && scanPattern == null) {
            throw new IllegalRuleException("The 'bean' element requires a 'class' attribute");
        }
        ScopeType scopeType = ScopeType.resolve(scope);
        if (scope != null && scopeType == null) {
            throw new IllegalRuleException("No scope type for '" + scope + "'");
        }
        if (scopeType == null) {
            scopeType = singleton == null || singleton == Boolean.TRUE ? ScopeType.SINGLETON : ScopeType.PROTOTYPE;
        }
        BeanRule beanRule = new BeanRule();
        beanRule.setId(id);
        if (scanPattern == null) {
            beanRule.setClassName(className);
        } else {
            beanRule.setScanPattern(scanPattern);
            beanRule.setMaskPattern(maskPattern);
        }
        beanRule.setScopeType(scopeType);
        beanRule.setSingleton(singleton);
        beanRule.setInitMethodName(initMethodName);
        beanRule.setDestroyMethodName(destroyMethodName);
        beanRule.setFactoryMethodName(factoryMethodName);
        beanRule.setLazyInit(lazyInit);
        beanRule.setLazyDestroy(lazyDestroy);
        beanRule.setImportant(important);
        return beanRule;
    }

    public static BeanRule newOfferedFactoryBeanInstance(String id, String factoryBeanId, String factoryMethodName, String initMethodName, String destroyMethodName, String scope, Boolean singleton, Boolean lazyInit, Boolean lazyDestroy, Boolean important) throws IllegalRuleException {
        if (factoryBeanId == null || factoryMethodName == null) {
            throw new IllegalRuleException("The 'bean' element requires both 'factoryBean' attribute and 'factoryMethod' attribute");
        }
        ScopeType scopeType = ScopeType.resolve(scope);
        if (scope != null && scopeType == null) {
            throw new IllegalRuleException("No scope type for '" + scope + "'");
        }
        if (scopeType == null) {
            scopeType = singleton == null || singleton == Boolean.TRUE ? ScopeType.SINGLETON : ScopeType.PROTOTYPE;
        }
        BeanRule beanRule = new BeanRule();
        beanRule.setId(id);
        beanRule.setScopeType(scopeType);
        beanRule.setSingleton(singleton);
        beanRule.setFactoryBeanId(factoryBeanId);
        beanRule.setFactoryMethodName(factoryMethodName);
        beanRule.setFactoryOffered(true);
        beanRule.setInitMethodName(initMethodName);
        beanRule.setDestroyMethodName(destroyMethodName);
        beanRule.setLazyInit(lazyInit);
        beanRule.setLazyDestroy(lazyDestroy);
        beanRule.setImportant(important);
        return beanRule;
    }

    public static BeanRule newInnerBeanRule(String className, String initMethodName, String destroyMethodName, String factoryMethodName) throws IllegalRuleException {
        if (StringUtils.hasText(destroyMethodName)) {
            throw new IllegalRuleException("Inner beans does not support destroy methods");
        }
        BeanRule beanRule = BeanRule.newInstance(null, className, null, null, initMethodName, destroyMethodName, factoryMethodName, null, false, null, null, null);
        beanRule.setInnerBean(true);
        return beanRule;
    }

    public static BeanRule newInnerOfferedFactoryBeanRule(String factoryBeanId, String factoryMethodName, String initMethodName, String destroyMethodName) throws IllegalRuleException {
        if (StringUtils.hasText(destroyMethodName)) {
            throw new IllegalRuleException("Inner beans does not support destroy methods");
        }
        BeanRule beanRule = BeanRule.newOfferedFactoryBeanInstance(null, factoryBeanId, factoryMethodName, initMethodName, destroyMethodName, null, false, null, null, null);
        beanRule.setInnerBean(true);
        return beanRule;
    }

    public static BeanRule replicate(BeanRule beanRule) {
        BeanRule newBeanRule = new BeanRule();
        newBeanRule.setId(beanRule.getId());
        if (beanRule.getScanPattern() == null) {
            newBeanRule.setBeanClass(beanRule.getBeanClass());
        }
        newBeanRule.setScopeType(beanRule.getScopeType());
        newBeanRule.setSingleton(beanRule.getSingleton());
        newBeanRule.setFactoryBeanId(beanRule.getFactoryBeanId());
        newBeanRule.setFactoryMethodName(beanRule.getFactoryMethodName());
        newBeanRule.setInitMethodName(beanRule.getInitMethodName());
        newBeanRule.setDestroyMethodName(beanRule.getDestroyMethodName());
        newBeanRule.setConstructorArgumentItemRuleMap(beanRule.getConstructorArgumentItemRuleMap());
        newBeanRule.setPropertyItemRuleMap(beanRule.getPropertyItemRuleMap());
        newBeanRule.setLazyInit(beanRule.getLazyInit());
        newBeanRule.setLazyDestroy(beanRule.getLazyDestroy());
        newBeanRule.setImportant(beanRule.getImportant());
        newBeanRule.setDescriptionRule(beanRule.getDescriptionRule());
        newBeanRule.setInnerBean(beanRule.isInnerBean());
        newBeanRule.setReplicated(true);
        return newBeanRule;
    }
}

