/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.context.expr.TokenEvaluation;
import com.aspectran.core.context.expr.token.Token;
import com.aspectran.core.context.expr.token.TokenParser;
import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.ability.Replicable;
import com.aspectran.core.context.rule.type.TextStyleType;
import com.aspectran.core.util.ToStringBuilder;
import java.util.ArrayList;
import java.util.List;

public class DescriptionRule
implements Replicable<DescriptionRule> {
    private String profile;
    private TextStyleType contentStyle;
    private String content;
    private String formattedContent;
    private List<DescriptionRule> candidates;

    public DescriptionRule() {
    }

    public DescriptionRule(DescriptionRule dr) {
        if (dr != null) {
            this.setProfile(dr.getProfile());
            this.setContentStyle(dr.getContentStyle());
            this.setContent(dr.getContent());
            this.setFormattedContent(dr.getFormattedContent());
            this.setCandidates(dr.getCandidates());
        }
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public TextStyleType getContentStyle() {
        return this.contentStyle;
    }

    public void setContentStyle(TextStyleType contentStyle) {
        this.contentStyle = contentStyle;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getFormattedContent() {
        return this.formattedContent != null ? this.formattedContent : this.content;
    }

    public void setFormattedContent(String formattedContent) {
        this.formattedContent = formattedContent;
    }

    public List<DescriptionRule> getCandidates() {
        return this.candidates;
    }

    public void setCandidates(List<DescriptionRule> candidates) {
        this.candidates = candidates;
    }

    public List<DescriptionRule> addCandidate(DescriptionRule descriptionRule) {
        if (this.candidates == null) {
            this.candidates = new ArrayList<DescriptionRule>();
        }
        this.candidates.add(descriptionRule);
        return this.candidates;
    }

    @Override
    public DescriptionRule replicate() {
        DescriptionRule dr = new DescriptionRule();
        dr.setProfile(this.profile);
        dr.setContentStyle(this.contentStyle);
        dr.setContent(this.content);
        return dr;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("profile", this.profile);
        tsb.append("style", (Object)this.contentStyle);
        tsb.append("content", this.content);
        return tsb.toString();
    }

    public static String render(DescriptionRule descriptionRule, Activity activity) {
        Token[] contentTokens;
        String content = descriptionRule.getFormattedContent();
        if (content == null || activity == null) {
            return content;
        }
        for (Token token : contentTokens = TokenParser.makeTokens(content, true)) {
            Token.resolveAlternativeValue(token, activity.getApplicationAdapter().getClassLoader());
        }
        TokenEvaluation evaluator = new TokenEvaluation(activity);
        return evaluator.evaluateAsString(contentTokens);
    }

    public static DescriptionRule newInstance(String profile, String style) throws IllegalRuleException {
        TextStyleType contentStyle = TextStyleType.resolve(style);
        if (style != null && contentStyle == null) {
            throw new IllegalRuleException("No text style type for '" + style + "'");
        }
        DescriptionRule descriptionRule = new DescriptionRule();
        descriptionRule.setContentStyle(contentStyle);
        if (profile != null && !profile.isEmpty()) {
            descriptionRule.setProfile(profile);
        }
        return descriptionRule;
    }
}

