/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.response.dispatch.ViewDispatcher;
import com.aspectran.core.context.expr.TokenEvaluation;
import com.aspectran.core.context.expr.token.Token;
import com.aspectran.core.context.expr.token.Tokenizer;
import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.ability.Replicable;
import com.aspectran.core.context.rule.type.ResponseType;
import com.aspectran.core.context.rule.type.TokenType;
import com.aspectran.core.util.BooleanUtils;
import com.aspectran.core.util.ToStringBuilder;
import java.util.List;

public class DispatchRule
implements Replicable<DispatchRule> {
    public static final ResponseType RESPONSE_TYPE = ResponseType.DISPATCH;
    private String name;
    private Token[] nameTokens;
    private String dispatcherName;
    private String contentType;
    private String encoding;
    private ViewDispatcher viewDispatcher;
    private Boolean defaultResponse;

    public String getName() {
        return this.name;
    }

    public String getName(Activity activity) {
        if (this.nameTokens != null && this.nameTokens.length > 0) {
            TokenEvaluation evaluator = new TokenEvaluation(activity);
            return evaluator.evaluateAsString(this.nameTokens);
        }
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            this.setName(null, null);
            return;
        }
        this.name = name;
        List<Token> tokens = Tokenizer.tokenize(name, true);
        int tokenCount = 0;
        for (Token t : tokens) {
            if (t.getType() == TokenType.TEXT) continue;
            ++tokenCount;
        }
        this.nameTokens = tokenCount > 0 ? tokens.toArray(new Token[0]) : null;
    }

    public void setName(String name, Token[] nameTokens) {
        this.name = name;
        this.nameTokens = nameTokens;
    }

    public Token[] getNameTokens() {
        return this.nameTokens;
    }

    public String getDispatcherName() {
        return this.dispatcherName;
    }

    public void setDispatcherName(String dispatcherName) {
        this.dispatcherName = dispatcherName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public ViewDispatcher getViewDispatcher() {
        return this.viewDispatcher;
    }

    public void setViewDispatcher(ViewDispatcher viewDispatcher) {
        this.viewDispatcher = viewDispatcher;
    }

    public Boolean getDefaultResponse() {
        return this.defaultResponse;
    }

    public boolean isDefaultResponse() {
        return BooleanUtils.toBoolean(this.defaultResponse);
    }

    public void setDefaultResponse(Boolean defaultResponse) {
        this.defaultResponse = defaultResponse;
    }

    @Override
    public DispatchRule replicate() {
        return DispatchRule.replicate(this);
    }

    public String toString() {
        return this.toString(this.viewDispatcher, null);
    }

    public String toString(ViewDispatcher viewDispatcher, String targetName) {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.appendForce("type", (Object)RESPONSE_TYPE);
        tsb.appendForce("name", this.name);
        tsb.append("contentType", this.contentType);
        tsb.append("encoding", this.encoding);
        tsb.append("default", this.getDefaultResponse());
        tsb.append("viewDispatcher", viewDispatcher);
        tsb.append("targetName", targetName);
        return tsb.toString();
    }

    public static DispatchRule newInstance(String name, String dispatcherName, String contentType, String encoding, Boolean defaultResponse) throws IllegalRuleException {
        if (name == null) {
            throw new IllegalRuleException("name must not be null");
        }
        DispatchRule dr = new DispatchRule();
        dr.setName(name);
        dr.setDispatcherName(dispatcherName);
        dr.setContentType(contentType);
        dr.setEncoding(encoding);
        dr.setDefaultResponse(defaultResponse);
        return dr;
    }

    public static DispatchRule newInstance(String name, String dispatcher, String contentType, String encoding) throws IllegalRuleException {
        return DispatchRule.newInstance(name, dispatcher, contentType, encoding, null);
    }

    public static DispatchRule newInstance(String name) throws IllegalRuleException {
        if (name == null) {
            throw new IllegalRuleException("name must not be null");
        }
        DispatchRule dr = new DispatchRule();
        dr.setName(name);
        return dr;
    }

    public static DispatchRule replicate(DispatchRule dispatchRule) {
        DispatchRule dr = new DispatchRule();
        dr.setName(dispatchRule.getName(), dispatchRule.getNameTokens());
        dr.setContentType(dispatchRule.getContentType());
        dr.setEncoding(dispatchRule.getEncoding());
        dr.setDefaultResponse(dispatchRule.getDefaultResponse());
        return dr;
    }
}

