/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.ability.BeanReferenceable;
import com.aspectran.core.context.rule.type.BeanRefererType;
import com.aspectran.core.util.BooleanUtils;
import com.aspectran.core.util.ToStringBuilder;
import java.lang.reflect.Method;

public class InvokeActionRule
implements BeanReferenceable {
    private static final BeanRefererType BEAN_REFERER_TYPE = BeanRefererType.BEAN_METHOD_ACTION_RULE;
    private String actionId;
    private String beanId;
    private Class<?> beanClass;
    private String methodName;
    private Method method;
    private boolean requiresTranslet;
    private ItemRuleMap argumentItemRuleMap;
    private ItemRuleMap propertyItemRuleMap;
    private Boolean hidden;

    public String getActionId() {
        return this.actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public String getBeanId() {
        return this.beanId;
    }

    public void setBeanId(String beanId) {
        this.beanId = beanId;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public void setBeanClass(Class<?> beanClass) {
        this.beanClass = beanClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public boolean isRequiresTranslet() {
        return this.requiresTranslet;
    }

    public void setRequiresTranslet(boolean requiresTranslet) {
        this.requiresTranslet = requiresTranslet;
    }

    public Boolean getHidden() {
        return this.hidden;
    }

    public boolean isHidden() {
        return BooleanUtils.toBoolean(this.hidden);
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public ItemRuleMap getArgumentItemRuleMap() {
        return this.argumentItemRuleMap;
    }

    public void setArgumentItemRuleMap(ItemRuleMap argumentItemRuleMap) {
        this.argumentItemRuleMap = argumentItemRuleMap;
    }

    public ItemRule newArgumentItemRule(String argumentName) {
        ItemRule itemRule = new ItemRule();
        itemRule.setName(argumentName);
        this.addArgumentItemRule(itemRule);
        return itemRule;
    }

    public void addArgumentItemRule(ItemRule argumentItemRule) {
        if (this.argumentItemRuleMap == null) {
            this.argumentItemRuleMap = new ItemRuleMap();
        }
        this.argumentItemRuleMap.putItemRule(argumentItemRule);
    }

    public ItemRuleMap getPropertyItemRuleMap() {
        return this.propertyItemRuleMap;
    }

    public void setPropertyItemRuleMap(ItemRuleMap propertyItemRuleMap) {
        this.propertyItemRuleMap = propertyItemRuleMap;
    }

    public ItemRule newPropertyItemRule(String propertyName) {
        ItemRule itemRule = new ItemRule();
        itemRule.setName(propertyName);
        this.addPropertyItemRule(itemRule);
        return itemRule;
    }

    public void addPropertyItemRule(ItemRule propertyItemRule) {
        if (this.propertyItemRuleMap == null) {
            this.propertyItemRuleMap = new ItemRuleMap();
        }
        this.propertyItemRuleMap.putItemRule(propertyItemRule);
    }

    @Override
    public BeanRefererType getBeanRefererType() {
        return BEAN_REFERER_TYPE;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("id", this.actionId);
        tsb.append("bean", this.beanId);
        if (this.method != null) {
            tsb.append("method", this.method);
        } else {
            tsb.append("method", this.methodName);
        }
        if (this.argumentItemRuleMap != null) {
            tsb.append("arguments", this.argumentItemRuleMap.keySet());
        }
        if (this.propertyItemRuleMap != null) {
            tsb.append("properties", this.propertyItemRuleMap.keySet());
        }
        tsb.append("hidden", this.hidden);
        return tsb.toString();
    }

    public static InvokeActionRule newInstance(String id, String beanId, String methodName, Boolean hidden) throws IllegalRuleException {
        if (beanId == null) {
            throw new IllegalRuleException("The 'action' element requires a 'bean' attribute");
        }
        if (methodName == null) {
            throw new IllegalRuleException("The 'action' element requires a 'method' attribute");
        }
        InvokeActionRule invokeActionRule = new InvokeActionRule();
        invokeActionRule.setActionId(id);
        invokeActionRule.setBeanId(beanId);
        invokeActionRule.setMethodName(methodName);
        invokeActionRule.setHidden(hidden);
        return invokeActionRule;
    }

    public static InvokeActionRule newInstance(String methodName, Boolean hidden) throws IllegalRuleException {
        if (methodName == null) {
            throw new IllegalRuleException("The 'action' element requires a 'method' attribute");
        }
        InvokeActionRule invokeActionRule = new InvokeActionRule();
        invokeActionRule.setMethodName(methodName);
        invokeActionRule.setHidden(hidden);
        return invokeActionRule;
    }
}

