/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.context.expr.token.Token;
import com.aspectran.core.context.expr.token.TokenParser;
import com.aspectran.core.context.rule.BeanRule;
import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.type.ItemType;
import com.aspectran.core.context.rule.type.ItemValueType;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.ToStringBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ItemRule {
    private static final String ARRAY_SUFFIX = "[]";
    private static final String MAP_SUFFIX = "{}";
    private ItemType type;
    private String name;
    private ItemValueType valueType;
    private Boolean tokenize;
    private Token[] tokens;
    private List<Token[]> tokensList;
    private Map<String, Token[]> tokensMap;
    private Boolean mandatory;
    private Boolean secret;
    private boolean autoNamed;
    private BeanRule beanRule;
    private List<BeanRule> beanRuleList;
    private Map<String, BeanRule> beanRuleMap;

    public ItemType getType() {
        return this.type;
    }

    public void setType(ItemType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name.endsWith(ARRAY_SUFFIX)) {
            this.name = name.substring(0, name.length() - 2);
            this.type = ItemType.ARRAY;
        } else if (name.endsWith(MAP_SUFFIX)) {
            this.name = name.substring(0, name.length() - 2);
            this.type = ItemType.MAP;
        } else {
            this.name = name;
            if (this.type == null) {
                this.type = ItemType.SINGLE;
            }
        }
    }

    public String getValue() {
        return this.toValue(this.tokens);
    }

    private String toValue(Token[] tokens) {
        return tokens != null ? TokenParser.toString(tokens) : null;
    }

    public Token[] getTokens() {
        return this.tokens;
    }

    public List<Token[]> getTokensList() {
        return this.tokensList;
    }

    public List<String> getValueList() {
        if (this.tokensList == null) {
            return null;
        }
        if (this.tokensList.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>(this.tokensList.size());
        for (Token[] tokens : this.tokensList) {
            list.add(this.toValue(tokens));
        }
        return list;
    }

    public Map<String, Token[]> getTokensMap() {
        return this.tokensMap;
    }

    public Map<String, String> getValueMap() {
        if (this.tokensMap == null) {
            return null;
        }
        if (this.tokensMap.isEmpty()) {
            return new LinkedHashMap<String, String>();
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Token[]> entry : this.tokensMap.entrySet()) {
            map.put(entry.getKey(), this.toValue(entry.getValue()));
        }
        return map;
    }

    public void setValue(String text) {
        Token[] tokens = TokenParser.makeTokens(text, this.isTokenize());
        this.setValue(tokens);
    }

    public void setValue(Token[] tokens) {
        if (this.type == null) {
            this.type = ItemType.SINGLE;
        }
        this.checkSingleType();
        this.tokens = tokens;
    }

    public void putValue(String name, String text) {
        Token[] tokens = TokenParser.makeTokens(text, this.isTokenize());
        this.putValue(name, tokens);
    }

    public void putValue(String name, Token[] tokens) {
        if (this.type == null) {
            this.type = ItemType.MAP;
        }
        this.checkMappableType();
        if (this.tokensMap == null) {
            this.tokensMap = new LinkedHashMap<String, Token[]>();
        }
        this.tokensMap.put(name, tokens);
    }

    public void setValue(Map<String, Token[]> tokensMap) {
        if (this.type == null) {
            this.type = ItemType.MAP;
        }
        this.checkMappableType();
        this.tokensMap = tokensMap;
    }

    public void setValue(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties must not be null");
        }
        if (this.type == null) {
            this.type = ItemType.PROPERTIES;
        }
        this.checkMappableType();
        this.tokensMap = new LinkedHashMap<String, Token[]>();
        for (String key : properties.stringPropertyNames()) {
            Token[] tokens;
            Object o = properties.get(key);
            if (o instanceof Token[]) {
                this.tokensMap.put(key, (Token[])o);
                continue;
            }
            if (o instanceof Token) {
                tokens = new Token[]{(Token)o};
                this.tokensMap.put(key, tokens);
                continue;
            }
            tokens = TokenParser.makeTokens(o.toString(), this.isTokenize());
            this.putValue(this.name, tokens);
        }
    }

    public void addValue(String text) {
        Token[] tokens = TokenParser.makeTokens(text, this.isTokenize());
        this.addValue(tokens);
    }

    public void addValue(Token[] tokens) {
        if (this.type == null) {
            this.type = ItemType.LIST;
        }
        this.checkListType();
        if (this.tokensList == null) {
            this.tokensList = new ArrayList<Token[]>();
        }
        this.tokensList.add(tokens);
    }

    public void setValue(List<Token[]> tokensList) {
        if (this.type == null) {
            this.type = ItemType.LIST;
        }
        this.checkListType();
        this.tokensList = tokensList;
    }

    public void setValue(Set<Token[]> tokensSet) {
        if (tokensSet == null) {
            throw new IllegalArgumentException("tokensSet must not be null");
        }
        if (this.type == null) {
            this.type = ItemType.SET;
        }
        this.checkListType();
        this.tokensList = new ArrayList<Token[]>(tokensSet);
    }

    public ItemValueType getValueType() {
        return this.valueType;
    }

    public void setValueType(ItemValueType valueType) {
        this.valueType = valueType;
    }

    public Boolean getTokenize() {
        return this.tokenize;
    }

    public boolean isTokenize() {
        return this.tokenize != Boolean.FALSE;
    }

    public void setTokenize(Boolean tokenize) {
        this.tokenize = tokenize;
    }

    public boolean isAutoNamed() {
        return this.autoNamed;
    }

    public void setAutoNamed(boolean autoNamed) {
        this.autoNamed = autoNamed;
    }

    public boolean isListableType() {
        return this.type == ItemType.ARRAY || this.type == ItemType.LIST || this.type == ItemType.SET;
    }

    public boolean isMappableType() {
        return this.type == ItemType.MAP || this.type == ItemType.PROPERTIES;
    }

    public Boolean getMandatory() {
        return this.mandatory;
    }

    public boolean isMandatory() {
        return this.mandatory == Boolean.TRUE;
    }

    public void setMandatory(Boolean mandatory) {
        this.mandatory = mandatory;
    }

    public Boolean getSecret() {
        return this.secret;
    }

    public boolean isSecret() {
        return this.secret == Boolean.TRUE;
    }

    public void setSecret(Boolean secret) {
        this.secret = secret;
    }

    public Token[] getAllTokens() {
        if (this.type == ItemType.SINGLE) {
            return this.tokens;
        }
        if (this.isListableType()) {
            if (this.tokensList == null || this.tokensList.isEmpty()) {
                return null;
            }
            if (this.tokensList.size() == 1) {
                return this.tokensList.get(0);
            }
            ArrayList list = new ArrayList();
            for (Token[] tokens : this.tokensList) {
                Collections.addAll(list, tokens);
            }
            return list.toArray(new Token[0]);
        }
        if (this.isMappableType()) {
            if (this.tokensMap == null || this.tokensMap.isEmpty()) {
                return null;
            }
            if (this.tokensMap.size() == 1) {
                Iterator<Token[]> it = this.tokensMap.values().iterator();
                if (it.hasNext()) {
                    return it.next();
                }
                return new Token[0];
            }
            ArrayList list = new ArrayList();
            for (Token[] tokens : this.tokensMap.values()) {
                Collections.addAll(list, tokens);
            }
            return list.toArray(new Token[0]);
        }
        return null;
    }

    public boolean containsToken(Token token) {
        Token[] allTokens = this.getAllTokens();
        if (allTokens != null) {
            for (Token t : allTokens) {
                if (t == null || !t.equals(token)) continue;
                return true;
            }
        }
        return false;
    }

    public BeanRule getBeanRule() {
        this.checkSingleType();
        return this.beanRule;
    }

    public void setBeanRule(BeanRule beanRule) {
        if (this.type == null) {
            this.type = ItemType.SINGLE;
        }
        this.checkSingleType();
        if (this.valueType == null) {
            this.valueType = ItemValueType.BEAN;
        }
        this.beanRule = beanRule;
    }

    public List<BeanRule> getBeanRuleList() {
        this.checkListType();
        return this.beanRuleList;
    }

    public void addBeanRule(BeanRule beanRule) {
        this.checkListType();
        if (this.valueType == null) {
            this.valueType = ItemValueType.BEAN;
        }
        if (this.beanRuleList == null) {
            this.beanRuleList = new ArrayList<BeanRule>();
        }
        this.beanRuleList.add(beanRule);
    }

    public Map<String, BeanRule> getBeanRuleMap() {
        this.checkMappableType();
        return this.beanRuleMap;
    }

    public void putBeanRule(String name, BeanRule beanRule) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        this.checkMappableType();
        if (this.valueType == null) {
            this.valueType = ItemValueType.BEAN;
        }
        if (this.beanRuleMap == null) {
            this.beanRuleMap = new LinkedHashMap<String, BeanRule>();
        }
        this.beanRuleMap.put(name, beanRule);
    }

    public boolean isEvaluable() {
        return this.tokens != null || this.tokensList != null || this.tokensMap != null || this.beanRule != null || this.beanRuleList != null || this.beanRuleMap != null;
    }

    private void checkSingleType() {
        if (this.type != ItemType.SINGLE) {
            throw new IllegalStateException("The type of this item must be 'single'");
        }
    }

    private void checkListType() {
        if (!this.isListableType()) {
            throw new IllegalArgumentException("The type of this item must be 'array', 'list' or 'set'");
        }
    }

    private void checkMappableType() {
        if (!this.isMappableType()) {
            throw new IllegalStateException("The type of this item must be 'map' or 'properties'");
        }
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("type", (Object)this.type);
        tsb.append("name", this.name);
        tsb.append("valueType", (Object)this.valueType);
        if (this.type == ItemType.SINGLE) {
            if (this.valueType == ItemValueType.BEAN) {
                tsb.append("value", this.beanRule);
            } else {
                tsb.append("value", this.tokens);
            }
        } else if (this.isListableType()) {
            if (this.valueType == ItemValueType.BEAN) {
                tsb.append("value", this.beanRuleList);
            } else {
                tsb.append("value", this.tokensList);
            }
        } else if (this.isMappableType()) {
            if (this.valueType == ItemValueType.BEAN) {
                tsb.append("value", this.beanRuleMap);
            } else {
                tsb.append("value", this.tokensMap);
            }
        }
        tsb.append("tokenize", this.tokenize);
        tsb.append("mandatory", this.mandatory);
        tsb.append("secret", this.secret);
        return tsb.toString();
    }

    public static ItemRule newInstance(String type, String name, String valueType, Boolean tokenize, Boolean mandatory, Boolean secret) throws IllegalRuleException {
        ItemRule itemRule = new ItemRule();
        ItemType itemType = ItemType.resolve(type);
        if (type != null && itemType == null) {
            throw new IllegalRuleException("No item type for '" + type + "'");
        }
        if (itemType != null) {
            itemRule.setType(itemType);
        } else {
            itemRule.setType(ItemType.SINGLE);
        }
        if (!StringUtils.isEmpty(name)) {
            itemRule.setName(name);
        } else {
            itemRule.setAutoNamed(true);
        }
        if (tokenize != null) {
            itemRule.setTokenize(tokenize);
        }
        if (valueType != null) {
            ItemValueType itemValueType = ItemValueType.resolve(valueType);
            if (itemValueType == null) {
                throw new IllegalRuleException("No item value type for '" + valueType + "'");
            }
            itemRule.setValueType(itemValueType);
        }
        if (mandatory != null) {
            itemRule.setMandatory(mandatory);
        }
        if (secret != null) {
            itemRule.setSecret(secret);
        }
        return itemRule;
    }
}

