/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.component.aspect.pointcut.PointcutPattern;
import com.aspectran.core.context.rule.type.PointcutType;
import com.aspectran.core.util.ToStringBuilder;
import java.util.List;

public class PointcutPatternRule {
    private PointcutType pointcutType;
    private String patternString;
    private PointcutPattern pointcutPattern;
    private int matchedBeanIdCount;
    private int matchedClassNameCount;
    private int matchedMethodNameCount;
    private List<PointcutPatternRule> excludePointcutPatternRuleList;

    public PointcutType getPointcutType() {
        return this.pointcutType;
    }

    protected void setPointcutType(PointcutType pointcutType) {
        this.pointcutType = pointcutType;
    }

    public String getPatternString() {
        return this.patternString;
    }

    public void setPatternString(String patternString) {
        this.patternString = patternString;
    }

    public PointcutPattern getPointcutPattern() {
        return this.pointcutPattern;
    }

    public void setPointcutPattern(PointcutPattern pointcutPattern) {
        this.pointcutPattern = pointcutPattern;
    }

    public List<PointcutPatternRule> getExcludePointcutPatternRuleList() {
        return this.excludePointcutPatternRuleList;
    }

    public void setExcludePointcutPatternRuleList(List<PointcutPatternRule> excludePointcutPatternRuleList) {
        this.excludePointcutPatternRuleList = excludePointcutPatternRuleList;
    }

    public int getMatchedBeanIdCount() {
        return this.matchedBeanIdCount;
    }

    public void increaseMatchedBeanIdCount() {
        ++this.matchedBeanIdCount;
    }

    public int getMatchedClassNameCount() {
        return this.matchedClassNameCount;
    }

    public void increaseMatchedClassNameCount() {
        ++this.matchedClassNameCount;
    }

    public int getMatchedMethodNameCount() {
        return this.matchedMethodNameCount;
    }

    public void increaseMatchedMethodNameCount() {
        ++this.matchedMethodNameCount;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("pointcutType", (Object)this.pointcutType);
        tsb.append("pointcutPattern", this.pointcutPattern);
        tsb.append("excludes", this.excludePointcutPatternRuleList);
        return tsb.toString();
    }

    public static PointcutPatternRule newInstance(String patternString) {
        PointcutPatternRule ppr = new PointcutPatternRule();
        ppr.setPatternString(patternString);
        ppr.setPointcutPattern(PointcutPattern.parsePattern(patternString));
        return ppr;
    }

    public static PointcutPatternRule newInstance(String translet, String bean, String method) {
        String transletNamePattern = null;
        String beanIdPattern = null;
        String classNamePattern = null;
        String methodNamePattern = null;
        if (translet != null) {
            transletNamePattern = translet;
        }
        if (bean != null) {
            if (bean.startsWith("class:")) {
                classNamePattern = bean.substring("class:".length());
            } else {
                beanIdPattern = bean;
            }
        }
        if (method != null) {
            methodNamePattern = method;
        }
        PointcutPatternRule ppr = new PointcutPatternRule();
        PointcutPattern pointcutPattern = new PointcutPattern(transletNamePattern, beanIdPattern, classNamePattern, methodNamePattern);
        ppr.setPointcutPattern(pointcutPattern);
        return ppr;
    }
}

