/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.context.expr.TokenEvaluation;
import com.aspectran.core.context.expr.token.Token;
import com.aspectran.core.context.expr.token.Tokenizer;
import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.ability.Replicable;
import com.aspectran.core.context.rule.type.ResponseType;
import com.aspectran.core.context.rule.type.TokenType;
import com.aspectran.core.util.BooleanUtils;
import com.aspectran.core.util.ToStringBuilder;
import java.util.List;
import java.util.Map;

public class RedirectRule
implements Replicable<RedirectRule> {
    public static final ResponseType RESPONSE_TYPE = ResponseType.REDIRECT;
    private String contentType;
    private String path;
    private Token[] pathTokens;
    private String encoding;
    private Boolean excludeNullParameters;
    private Boolean excludeEmptyParameters;
    private ItemRuleMap parameterItemRuleMap;
    private Boolean defaultResponse;

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getPath() {
        return this.path;
    }

    public String getPath(Activity activity) {
        if (this.pathTokens != null && this.pathTokens.length > 0) {
            TokenEvaluation evaluator = new TokenEvaluation(activity);
            return evaluator.evaluateAsString(this.pathTokens);
        }
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
        List<Token> tokens = Tokenizer.tokenize(path, true);
        int tokenCount = 0;
        for (Token t : tokens) {
            if (t.getType() == TokenType.TEXT) continue;
            ++tokenCount;
        }
        this.pathTokens = tokenCount > 0 ? tokens.toArray(new Token[0]) : null;
    }

    public void setPath(String path, Token[] pathTokens) {
        this.path = path;
        this.pathTokens = pathTokens;
    }

    public Token[] getPathTokens() {
        return this.pathTokens;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Boolean getExcludeNullParameters() {
        return this.excludeNullParameters;
    }

    public boolean isExcludeNullParameters() {
        return BooleanUtils.toBoolean(this.excludeNullParameters);
    }

    public void setExcludeNullParameters(Boolean excludeNullParameters) {
        this.excludeNullParameters = excludeNullParameters;
    }

    public Boolean getExcludeEmptyParameters() {
        return this.excludeNullParameters;
    }

    public boolean isExcludeEmptyParameters() {
        return BooleanUtils.toBoolean(this.excludeEmptyParameters);
    }

    public void setExcludeEmptyParameters(Boolean excludeEmptyParameters) {
        this.excludeEmptyParameters = excludeEmptyParameters;
    }

    public ItemRuleMap getParameterItemRuleMap() {
        return this.parameterItemRuleMap;
    }

    public void setParameterItemRuleMap(ItemRuleMap parameterItemRuleMap) {
        this.parameterItemRuleMap = parameterItemRuleMap;
    }

    public ItemRule newParameterItemRule(String parameterName) {
        ItemRule itemRule = new ItemRule();
        itemRule.setName(parameterName);
        this.addParameterItemRule(itemRule);
        return itemRule;
    }

    public void addParameterItemRule(ItemRule parameterItemRule) {
        if (this.parameterItemRuleMap == null) {
            this.parameterItemRuleMap = new ItemRuleMap();
        }
        this.parameterItemRuleMap.putItemRule(parameterItemRule);
    }

    public void setParameters(Map<String, String> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            this.parameterItemRuleMap = null;
        } else {
            ItemRuleMap itemRuleMap = new ItemRuleMap();
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                ItemRule ir = new ItemRule();
                ir.setTokenize(false);
                ir.setName(entry.getKey());
                ir.setValue(entry.getValue());
                itemRuleMap.putItemRule(ir);
            }
            this.parameterItemRuleMap = itemRuleMap;
        }
    }

    public Boolean getDefaultResponse() {
        return this.defaultResponse;
    }

    public boolean isDefaultResponse() {
        return BooleanUtils.toBoolean(this.defaultResponse);
    }

    public void setDefaultResponse(Boolean defaultResponse) {
        this.defaultResponse = defaultResponse;
    }

    @Override
    public RedirectRule replicate() {
        return RedirectRule.replicate(this);
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.appendForce("type", (Object)RESPONSE_TYPE);
        tsb.append("contentType", this.contentType);
        tsb.append("path", this.path);
        tsb.append("parameters", this.parameterItemRuleMap);
        tsb.append("encoding", this.encoding);
        tsb.append("excludeNullParameters", this.excludeNullParameters);
        tsb.append("excludeEmptyParameters", this.excludeEmptyParameters);
        tsb.append("default", this.getDefaultResponse());
        return tsb.toString();
    }

    public static RedirectRule newInstance(String contentType, String path, String encoding, Boolean excludeNullParameters, Boolean excludeEmptyParameters, Boolean defaultResponse) {
        RedirectRule rr = new RedirectRule();
        rr.setContentType(contentType);
        if (path != null && path.length() > 0) {
            rr.setPath(path);
        }
        rr.setEncoding(encoding);
        rr.setExcludeNullParameters(excludeNullParameters);
        rr.setExcludeEmptyParameters(excludeEmptyParameters);
        rr.setDefaultResponse(defaultResponse);
        return rr;
    }

    public static RedirectRule newInstance(String path) throws IllegalRuleException {
        if (path == null) {
            throw new IllegalRuleException("path must not be null");
        }
        RedirectRule rr = new RedirectRule();
        rr.setPath(path);
        return rr;
    }

    public static RedirectRule replicate(RedirectRule redirectRule) {
        RedirectRule rr = new RedirectRule();
        rr.setContentType(redirectRule.getContentType());
        rr.setPath(redirectRule.getPath(), redirectRule.getPathTokens());
        rr.setEncoding(redirectRule.getEncoding());
        rr.setExcludeNullParameters(redirectRule.getExcludeNullParameters());
        rr.setExcludeEmptyParameters(redirectRule.getExcludeEmptyParameters());
        rr.setParameterItemRuleMap(redirectRule.getParameterItemRuleMap());
        rr.setDefaultResponse(redirectRule.getDefaultResponse());
        return rr;
    }
}

