/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.appender;

import com.aspectran.core.context.rule.AppendRule;
import com.aspectran.core.context.rule.appender.RuleAppender;
import com.aspectran.core.context.rule.type.AppendableFileFormatType;
import com.aspectran.core.context.rule.type.AppenderType;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.nodelet.NodeTracker;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;

abstract class AbstractRuleAppender
implements RuleAppender {
    private final AppenderType appenderType;
    private AppendRule appendRule;
    private AppendableFileFormatType appendableFileFormatType;
    private String[] profiles;
    private long lastModified;
    private NodeTracker nodeTracker;

    AbstractRuleAppender(AppenderType appenderType) {
        this.appenderType = appenderType;
    }

    @Override
    public AppenderType getAppenderType() {
        return this.appenderType;
    }

    @Override
    public AppendRule getAppendRule() {
        return this.appendRule;
    }

    @Override
    public void setAppendRule(AppendRule appendRule) {
        String profile;
        this.appendRule = appendRule;
        AppendableFileFormatType appendableFileFormatType = appendRule.getFormat();
        if (appendableFileFormatType != null) {
            this.appendableFileFormatType = appendableFileFormatType;
        }
        if ((profile = appendRule.getProfile()) != null && !profile.isEmpty()) {
            String[] arr = StringUtils.splitCommaDelimitedString(profile);
            this.profiles = arr.length > 0 ? arr : null;
        }
    }

    @Override
    public AppendableFileFormatType getAppendableFileFormatType() {
        return this.appendableFileFormatType;
    }

    @Override
    public void setAppendableFileFormatType(AppendableFileFormatType appendableFileFormatType) {
        this.appendableFileFormatType = appendableFileFormatType;
    }

    protected void determineAppendedFileFormatType(String resourceName) {
        if (resourceName.toLowerCase().endsWith(".apon")) {
            this.setAppendableFileFormatType(AppendableFileFormatType.APON);
        } else {
            this.setAppendableFileFormatType(AppendableFileFormatType.XML);
        }
    }

    @Override
    public String[] getProfiles() {
        return this.profiles;
    }

    @Override
    public void setProfiles(String[] profiles) {
        this.profiles = profiles;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    @Override
    public Reader getReader() throws IOException {
        return this.getReader(null);
    }

    @Override
    public Reader getReader(String encoding) throws IOException {
        if (encoding != null) {
            return new InputStreamReader(this.getInputStream(), encoding);
        }
        return new InputStreamReader(this.getInputStream());
    }

    @Override
    public NodeTracker getNodeTracker() {
        return this.nodeTracker;
    }

    @Override
    public void setNodeTracker(NodeTracker nodeTracker) {
        this.nodeTracker = nodeTracker;
    }
}

