/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.appender;

import com.aspectran.core.context.rule.appender.AbstractRuleAppender;
import com.aspectran.core.context.rule.type.AppenderType;
import com.aspectran.core.util.ToStringBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileRuleAppender
extends AbstractRuleAppender {
    private final String basePath;
    private final String filePath;

    public FileRuleAppender(String filePath) {
        this(null, filePath);
    }

    public FileRuleAppender(String basePath, String filePath) {
        super(AppenderType.FILE);
        this.basePath = basePath;
        this.filePath = filePath;
        this.determineAppendedFileFormatType(filePath);
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public File getFile() {
        if (this.basePath == null) {
            return new File(this.filePath);
        }
        return new File(this.basePath, this.filePath);
    }

    @Override
    public String getQualifiedName() {
        try {
            return this.getFile().getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public long getLastModified() {
        File file = this.getFile();
        return file.lastModified();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            File file = this.getFile();
            if (!file.isFile()) {
                throw new IllegalArgumentException("Not a file: " + file);
            }
            this.setLastModified(file.lastModified());
            return new FileInputStream(file);
        }
        catch (Exception e) {
            throw new IOException("Failed to create input stream from rule file: " + this.getFile().getAbsolutePath(), e);
        }
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("file", this.filePath);
        tsb.append("format", (Object)this.getAppendableFileFormatType());
        tsb.append("profile", this.getProfiles());
        return tsb.toString();
    }
}

