/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.parser.xml;

import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AspectranDtdResolver
implements EntityResolver {
    private static final String ASPECTRAN_DTD = "/com/aspectran/core/context/rule/parser/xml/dtd/aspectran-6.dtd";
    private static final Map<String, String> doctypeMap = new HashMap<String, String>();
    private final boolean validating;

    public AspectranDtdResolver() {
        this(true);
    }

    public AspectranDtdResolver(boolean validating) {
        this.validating = validating;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (this.validating) {
            try {
                String path;
                InputSource source = null;
                if (publicId != null) {
                    path = doctypeMap.get(publicId.toUpperCase());
                    source = this.getInputSource(path);
                }
                if (source == null && systemId != null) {
                    path = doctypeMap.get(systemId.toUpperCase());
                    source = this.getInputSource(path);
                }
                return source;
            }
            catch (Exception e) {
                throw new SAXException(e.toString());
            }
        }
        return new InputSource(new StringReader(""));
    }

    private InputSource getInputSource(String path) {
        InputSource source = null;
        if (path != null) {
            InputStream in = this.getClass().getResourceAsStream(path);
            source = new InputSource(in);
        }
        return source;
    }

    static {
        doctypeMap.put("-//ASPECTRAN//DTD Aspectran Configuration 6.0//EN".toUpperCase(), ASPECTRAN_DTD);
        doctypeMap.put("aspectran-6.dtd".toUpperCase(), ASPECTRAN_DTD);
    }
}

