/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.parser.xml;

import com.aspectran.core.context.rule.BeanRule;
import com.aspectran.core.context.rule.DescriptionRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.assistant.ActivityRuleAssistant;
import com.aspectran.core.context.rule.params.FilterParameters;
import com.aspectran.core.context.rule.parser.xml.AspectranNodeParser;
import com.aspectran.core.util.BooleanUtils;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.nodelet.NodeletAdder;
import com.aspectran.core.util.nodelet.NodeletParser;

class BeanNodeletAdder
implements NodeletAdder {
    BeanNodeletAdder() {
    }

    @Override
    public void add(String xpath, NodeletParser parser) {
        AspectranNodeParser nodeParser = (AspectranNodeParser)parser.getNodeParser();
        ActivityRuleAssistant assistant = nodeParser.getAssistant();
        parser.setXpath(xpath + "/bean");
        parser.addNodelet(attrs -> {
            String id = StringUtils.emptyToNull((String)attrs.get("id"));
            String className = StringUtils.emptyToNull(assistant.resolveAliasType((String)attrs.get("class")));
            String factoryBean = StringUtils.emptyToNull((String)attrs.get("factoryBean"));
            String factoryMethod = StringUtils.emptyToNull((String)attrs.get("factoryMethod"));
            String scan = (String)attrs.get("scan");
            String mask = (String)attrs.get("mask");
            String initMethod = StringUtils.emptyToNull((String)attrs.get("initMethod"));
            String destroyMethod = StringUtils.emptyToNull((String)attrs.get("destroyMethod"));
            String scope = (String)attrs.get("scope");
            Boolean singleton = BooleanUtils.toNullableBooleanObject((String)attrs.get("singleton"));
            Boolean lazyInit = BooleanUtils.toNullableBooleanObject((String)attrs.get("lazyInit"));
            Boolean lazyDestroy = BooleanUtils.toNullableBooleanObject((String)attrs.get("lazyDestroy"));
            Boolean important = BooleanUtils.toNullableBooleanObject((String)attrs.get("important"));
            BeanRule beanRule = className == null && scan == null && factoryBean != null ? BeanRule.newOfferedFactoryBeanInstance(id, factoryBean, factoryMethod, initMethod, destroyMethod, scope, singleton, lazyInit, lazyDestroy, important) : BeanRule.newInstance(id, className, scan, mask, initMethod, destroyMethod, factoryMethod, scope, singleton, lazyInit, lazyDestroy, important);
            parser.pushObject(beanRule);
        });
        parser.addNodeEndlet(text -> {
            BeanRule beanRule = (BeanRule)parser.popObject();
            assistant.resolveBeanClass(beanRule);
            assistant.resolveFactoryBeanClass(beanRule);
            assistant.addBeanRule(beanRule);
        });
        parser.setXpath(xpath + "/bean/description");
        parser.addNodelet(attrs -> {
            String profile = (String)attrs.get("profile");
            String style = (String)attrs.get("style");
            DescriptionRule descriptionRule = DescriptionRule.newInstance(profile, style);
            parser.pushObject(descriptionRule);
        });
        parser.addNodeEndlet(text -> {
            DescriptionRule descriptionRule = (DescriptionRule)parser.popObject();
            BeanRule beanRule = (BeanRule)parser.peekObject();
            descriptionRule.setContent(text);
            descriptionRule = assistant.profiling(descriptionRule, beanRule.getDescriptionRule());
            beanRule.setDescriptionRule(descriptionRule);
        });
        parser.setXpath(xpath + "/bean/filter");
        parser.addNodelet(attrs -> {
            String classScanFilterClassName = (String)attrs.get("class");
            FilterParameters filterParameters = new FilterParameters();
            if (StringUtils.hasText(classScanFilterClassName)) {
                filterParameters.putValue(FilterParameters.filterClass, (Object)classScanFilterClassName);
            }
            parser.pushObject(filterParameters);
        });
        parser.addNodeEndlet(text -> {
            FilterParameters filterParameters = (FilterParameters)parser.popObject();
            if (StringUtils.hasText(text)) {
                filterParameters = new FilterParameters();
                filterParameters.readFrom(text);
            }
            if (filterParameters.hasValue(FilterParameters.filterClass) || filterParameters.hasValue(FilterParameters.exclude)) {
                BeanRule beanRule = (BeanRule)parser.peekObject();
                beanRule.setFilterParameters(filterParameters);
            }
        });
        parser.setXpath(xpath + "/bean/arguments");
        parser.addNodelet(attrs -> {
            ItemRuleMap irm = new ItemRuleMap();
            irm.setProfile(StringUtils.emptyToNull((String)attrs.get("profile")));
            parser.pushObject(irm);
        });
        nodeParser.addItemNodelets();
        parser.addNodeEndlet(text -> {
            ItemRuleMap irm = (ItemRuleMap)parser.popObject();
            BeanRule beanRule = (BeanRule)parser.peekObject();
            irm = assistant.profiling(irm, beanRule.getConstructorArgumentItemRuleMap());
            beanRule.setConstructorArgumentItemRuleMap(irm);
        });
        parser.setXpath(xpath + "/bean/properties");
        parser.addNodelet(attrs -> {
            ItemRuleMap irm = new ItemRuleMap();
            irm.setProfile(StringUtils.emptyToNull((String)attrs.get("profile")));
            parser.pushObject(irm);
        });
        nodeParser.addItemNodelets();
        parser.addNodeEndlet(text -> {
            ItemRuleMap irm = (ItemRuleMap)parser.popObject();
            BeanRule beanRule = (BeanRule)parser.peekObject();
            irm = assistant.profiling(irm, beanRule.getPropertyItemRuleMap());
            beanRule.setPropertyItemRuleMap(irm);
        });
    }
}

