/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.parser.xml;

import com.aspectran.core.context.expr.token.Token;
import com.aspectran.core.context.expr.token.TokenParser;
import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.assistant.ActivityRuleAssistant;
import com.aspectran.core.context.rule.parser.xml.AspectranNodeParser;
import com.aspectran.core.context.rule.type.ItemType;
import com.aspectran.core.context.rule.type.ItemValueType;
import com.aspectran.core.util.BooleanUtils;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.nodelet.NodeletAdder;
import com.aspectran.core.util.nodelet.NodeletParser;

class ItemNodeletAdder
implements NodeletAdder {
    private final int depth;

    ItemNodeletAdder(int depth) {
        this.depth = depth;
    }

    @Override
    public void add(String xpath, NodeletParser parser) {
        AspectranNodeParser nodeParser = (AspectranNodeParser)parser.getNodeParser();
        ActivityRuleAssistant assistant = nodeParser.getAssistant();
        parser.setXpath(xpath + "/item");
        parser.addNodelet(attrs -> {
            String type = (String)attrs.get("type");
            String name = (String)attrs.get("name");
            String value = (String)attrs.get("value");
            String valueType = (String)attrs.get("valueType");
            Boolean tokenize = BooleanUtils.toNullableBooleanObject((String)attrs.get("tokenize"));
            Boolean mandatory = BooleanUtils.toNullableBooleanObject((String)attrs.get("mandatory"));
            Boolean secret = BooleanUtils.toNullableBooleanObject((String)attrs.get("secret"));
            ItemRule itemRule = ItemRule.newInstance(type, name, valueType, tokenize, mandatory, secret);
            if (value != null && itemRule.getType() == ItemType.SINGLE) {
                itemRule.setValue(value);
            }
            parser.pushObject(itemRule);
        });
        if (this.depth < nodeParser.getMaxInnerBeans()) {
            nodeParser.addInnerBeanNodelets(this.depth);
        } else {
            parser.setXpath(xpath + "/item/bean");
            parser.addNodelet(attrs -> {
                throw new IllegalRuleException("Inner beans can only be nested up to " + nodeParser.getMaxInnerBeans() + " times");
            });
            parser.setXpath(xpath + "/item");
        }
        parser.addNodeEndlet(text -> {
            ItemRule itemRule = (ItemRule)parser.popObject();
            ItemRuleMap itemRuleMap = (ItemRuleMap)parser.peekObject();
            if (itemRule.getType() == ItemType.SINGLE && StringUtils.hasText(text)) {
                itemRule.setValue(text);
            }
            assistant.resolveBeanClass(itemRule);
            itemRuleMap.putItemRule(itemRule);
        });
        parser.setXpath(xpath + "/item/value");
        if (this.depth < nodeParser.getMaxInnerBeans()) {
            nodeParser.addInnerBeanNodelets(this.depth);
        } else {
            parser.setXpath(xpath + "/item/value/bean");
            parser.addNodelet(attrs -> {
                throw new IllegalRuleException("Inner beans can only be nested up to " + nodeParser.getMaxInnerBeans() + " times");
            });
            parser.setXpath(xpath + "/item/value");
        }
        parser.addNodeEndlet(text -> {
            ItemRule itemRule;
            if (StringUtils.hasText(text) && (itemRule = (ItemRule)parser.peekObject()).getValueType() != ItemValueType.BEAN) {
                if (itemRule.isListableType()) {
                    itemRule.addValue(TokenParser.makeTokens(text, itemRule.isTokenize()));
                } else if (itemRule.getType() == ItemType.SINGLE) {
                    itemRule.setValue(TokenParser.makeTokens(text, itemRule.isTokenize()));
                }
            }
        });
        parser.setXpath(xpath + "/item/entry");
        parser.addNodelet(attrs -> {
            String name = (String)attrs.get("name");
            String value = (String)attrs.get("value");
            String tokenize = (String)attrs.get("tokenize");
            parser.pushObject(tokenize);
            parser.pushObject(value);
            parser.pushObject(name);
        });
        if (this.depth < nodeParser.getMaxInnerBeans()) {
            nodeParser.addInnerBeanNodelets(this.depth);
        } else {
            parser.setXpath(xpath + "/item/entry/bean");
            parser.addNodelet(attrs -> {
                throw new IllegalRuleException("Inner beans can only be nested up to " + nodeParser.getMaxInnerBeans() + " times");
            });
            parser.setXpath(xpath + "/item/entry");
        }
        parser.addNodeEndlet(text -> {
            String name = (String)parser.popObject();
            String value = (String)parser.popObject();
            String tokenize = (String)parser.popObject();
            ItemRule itemRule = (ItemRule)parser.peekObject();
            if (itemRule.isMappableType() && itemRule.getValueType() != ItemValueType.BEAN) {
                boolean isTokenize = BooleanUtils.toBoolean(BooleanUtils.toNullableBooleanObject(tokenize), itemRule.isTokenize());
                Token[] tokens = null;
                if (value != null) {
                    tokens = TokenParser.makeTokens(value, isTokenize);
                } else if (StringUtils.hasText(text)) {
                    tokens = TokenParser.makeTokens(text, isTokenize);
                }
                itemRule.putValue(name, tokens);
            }
        });
    }
}

