/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.support.i18n.message;

import com.aspectran.core.support.i18n.message.HierarchicalMessageSource;
import com.aspectran.core.support.i18n.message.MessageSource;
import com.aspectran.core.support.i18n.message.MessageSourceSupport;
import com.aspectran.core.support.i18n.message.NoSuchMessageException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Properties;

public abstract class AbstractMessageSource
extends MessageSourceSupport
implements HierarchicalMessageSource {
    private MessageSource parentMessageSource;
    private Properties commonMessages;
    private boolean useCodeAsDefaultMessage = false;

    @Override
    public void setParentMessageSource(MessageSource parent) {
        this.parentMessageSource = parent;
    }

    @Override
    public MessageSource getParentMessageSource() {
        return this.parentMessageSource;
    }

    public void setCommonMessages(Properties commonMessages) {
        this.commonMessages = commonMessages;
    }

    protected Properties getCommonMessages() {
        return this.commonMessages;
    }

    public void setUseCodeAsDefaultMessage(boolean useCodeAsDefaultMessage) {
        this.useCodeAsDefaultMessage = useCodeAsDefaultMessage;
    }

    protected boolean isUseCodeAsDefaultMessage() {
        return this.useCodeAsDefaultMessage;
    }

    @Override
    public final String getMessage(String code, Locale locale) throws NoSuchMessageException {
        return this.getMessage(code, (Object[])null, locale);
    }

    @Override
    public final String getMessage(String code, String defaultMessage, Locale locale) throws NoSuchMessageException {
        return this.getMessage(code, null, defaultMessage, locale);
    }

    @Override
    public final String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        String msg = this.getMessageInternal(code, args, locale);
        if (msg != null) {
            return msg;
        }
        String fallback = this.getDefaultMessage(code);
        if (fallback != null) {
            return fallback;
        }
        throw new NoSuchMessageException(code, locale);
    }

    @Override
    public final String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        String fallback;
        String msg = this.getMessageInternal(code, args, locale);
        if (msg != null) {
            return msg;
        }
        if (defaultMessage == null && (fallback = this.getDefaultMessage(code)) != null) {
            return fallback;
        }
        return this.renderDefaultMessage(defaultMessage, args, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getMessageInternal(String code, Object[] args, Locale locale) {
        String commonMessage;
        Properties commonMessages;
        if (code == null) {
            return null;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (!(this.isAlwaysUseMessageFormat() || args != null && args.length != 0)) {
            String message = this.resolveCodeWithoutArguments(code, locale);
            if (message != null) {
                return message;
            }
        } else {
            MessageFormat messageFormat;
            if (args == null) {
                args = new Object[]{};
            }
            if ((messageFormat = this.resolveCode(code, locale)) != null) {
                MessageFormat messageFormat2 = messageFormat;
                synchronized (messageFormat2) {
                    return messageFormat.format(args);
                }
            }
        }
        if ((commonMessages = this.getCommonMessages()) != null && (commonMessage = commonMessages.getProperty(code)) != null) {
            return this.formatMessage(commonMessage, args, locale);
        }
        return this.getMessageFromParent(code, args, locale);
    }

    protected String getMessageFromParent(String code, Object[] args, Locale locale) {
        MessageSource parent = this.getParentMessageSource();
        if (parent != null) {
            if (parent instanceof AbstractMessageSource) {
                return ((AbstractMessageSource)parent).getMessageInternal(code, args, locale);
            }
            return parent.getMessage(code, args, null, locale);
        }
        return null;
    }

    protected String getDefaultMessage(String code) {
        if (this.isUseCodeAsDefaultMessage()) {
            return code;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String resolveCodeWithoutArguments(String code, Locale locale) {
        MessageFormat messageFormat = this.resolveCode(code, locale);
        if (messageFormat != null) {
            MessageFormat messageFormat2 = messageFormat;
            synchronized (messageFormat2) {
                return messageFormat.format(new Object[0]);
            }
        }
        return null;
    }

    protected abstract MessageFormat resolveCode(String var1, Locale var2);
}

