/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.support.i18n.message;

import com.aspectran.core.lang.NonNull;
import com.aspectran.core.support.i18n.message.MessageSource;
import com.aspectran.core.support.i18n.message.NoSuchMessageException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;

public class MessageSourceResourceBundle
extends ResourceBundle {
    private final MessageSource messageSource;
    private final Locale locale;

    public MessageSourceResourceBundle(MessageSource source, Locale locale) {
        if (source == null) {
            throw new IllegalArgumentException("MessageSource must not be null");
        }
        this.messageSource = source;
        this.locale = locale;
    }

    public MessageSourceResourceBundle(MessageSource source, Locale locale, ResourceBundle parent) {
        this(source, locale);
        this.setParent(parent);
    }

    @Override
    protected Object handleGetObject(@NonNull String key) {
        try {
            return this.messageSource.getMessage(key, this.locale);
        }
        catch (NoSuchMessageException ex) {
            return null;
        }
    }

    @Override
    public boolean containsKey(@NonNull String key) {
        try {
            this.messageSource.getMessage(key, this.locale);
            return true;
        }
        catch (NoSuchMessageException ex) {
            return false;
        }
    }

    @Override
    @NonNull
    public Enumeration<String> getKeys() {
        throw new UnsupportedOperationException("MessageSourceResourceBundle does not support enumerating its keys");
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }
}

