/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.support.i18n.message;

import com.aspectran.core.component.bean.aware.ClassLoaderAware;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.support.i18n.message.AbstractMessageSource;
import com.aspectran.core.util.ClassUtils;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.ToStringBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

public class ResourceBundleMessageSource
extends AbstractMessageSource
implements ClassLoaderAware {
    private String defaultEncoding = ActivityContext.DEFAULT_ENCODING;
    private boolean fallbackToSystemLocale = true;
    private long cacheMillis = -1L;
    private ClassLoader classLoader;
    private String[] basenames = new String[0];
    private final Map<String, Map<Locale, ResourceBundle>> cachedResourceBundles = new ConcurrentHashMap<String, Map<Locale, ResourceBundle>>();
    private final Map<ResourceBundle, Map<String, Map<Locale, MessageFormat>>> cachedBundleMessageFormats = new ConcurrentHashMap<ResourceBundle, Map<String, Map<Locale, MessageFormat>>>();

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public void setFallbackToSystemLocale(boolean fallbackToSystemLocale) {
        this.fallbackToSystemLocale = fallbackToSystemLocale;
    }

    public void setCacheSeconds(int cacheSeconds) {
        this.cacheMillis = cacheSeconds * 1000;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            return ClassUtils.getDefaultClassLoader();
        }
        return this.classLoader;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setBasename(String basename) {
        this.setBasenames(basename);
    }

    public void setBasenames(String ... basenames) {
        if (basenames != null) {
            this.basenames = new String[basenames.length];
            for (int i = 0; i < basenames.length; ++i) {
                String basename = basenames[i];
                if (!StringUtils.hasText(basename)) {
                    throw new IllegalArgumentException("Basename must not be empty");
                }
                this.basenames[i] = basename.trim();
            }
        } else {
            this.basenames = new String[0];
        }
    }

    @Override
    protected String resolveCodeWithoutArguments(String code, Locale locale) {
        String result = null;
        for (int i = 0; result == null && i < this.basenames.length; ++i) {
            ResourceBundle bundle = this.getResourceBundle(this.basenames[i], locale);
            if (bundle == null) continue;
            result = this.getStringOrNull(bundle, code);
        }
        return result;
    }

    @Override
    protected MessageFormat resolveCode(String code, Locale locale) {
        MessageFormat messageFormat = null;
        for (int i = 0; messageFormat == null && i < this.basenames.length; ++i) {
            ResourceBundle bundle = this.getResourceBundle(this.basenames[i], locale);
            if (bundle == null) continue;
            messageFormat = this.getMessageFormat(bundle, code, locale);
        }
        return messageFormat;
    }

    protected ResourceBundle getResourceBundle(String basename, Locale locale) {
        ResourceBundle bundle;
        if (this.cacheMillis >= 0L) {
            return this.doGetBundle(basename, locale);
        }
        Map<Locale, ResourceBundle> localeMap = this.cachedResourceBundles.get(basename);
        if (localeMap != null && (bundle = localeMap.get(locale)) != null) {
            return bundle;
        }
        try {
            Map<Locale, ResourceBundle> existing;
            bundle = this.doGetBundle(basename, locale);
            if (localeMap == null && (existing = this.cachedResourceBundles.putIfAbsent(basename, localeMap = new ConcurrentHashMap<Locale, ResourceBundle>())) != null) {
                localeMap = existing;
            }
            localeMap.put(locale, bundle);
            return bundle;
        }
        catch (MissingResourceException ex) {
            this.logger.warn("ResourceBundle [" + basename + "] not found for MessageSource: " + ex.getMessage());
            return null;
        }
    }

    protected ResourceBundle doGetBundle(String basename, Locale locale) throws MissingResourceException {
        return ResourceBundle.getBundle(basename, locale, this.getClassLoader(), new MessageSourceControl());
    }

    protected ResourceBundle loadBundle(Reader reader) throws IOException {
        return new PropertyResourceBundle(reader);
    }

    protected ResourceBundle loadBundle(InputStream inputStream) throws IOException {
        return new PropertyResourceBundle(inputStream);
    }

    protected MessageFormat getMessageFormat(ResourceBundle bundle, String code, Locale locale) throws MissingResourceException {
        MessageFormat result;
        Map<String, Map<Locale, MessageFormat>> codeMap = this.cachedBundleMessageFormats.get(bundle);
        Map<Object, Object> localeMap = null;
        if (codeMap != null && (localeMap = codeMap.get(code)) != null && (result = localeMap.get(locale)) != null) {
            return result;
        }
        String msg = this.getStringOrNull(bundle, code);
        if (msg != null) {
            Map<Object, Object> existing;
            if (codeMap == null && (existing = this.cachedBundleMessageFormats.putIfAbsent(bundle, codeMap = new ConcurrentHashMap<String, Map<Locale, MessageFormat>>())) != null) {
                codeMap = existing;
            }
            if (localeMap == null && (existing = codeMap.putIfAbsent(code, localeMap = new ConcurrentHashMap<Locale, MessageFormat>())) != null) {
                localeMap = existing;
            }
            MessageFormat result2 = this.createMessageFormat(msg, locale);
            localeMap.put(locale, result2);
            return result2;
        }
        return null;
    }

    protected String getStringOrNull(ResourceBundle bundle, String key) {
        if (bundle.containsKey(key)) {
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder(this.getClass().getName());
        tsb.append("basenames", this.basenames);
        return tsb.toString();
    }

    private class MessageSourceControl
    extends ResourceBundle.Control {
        private MessageSourceControl() {
        }

        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            if (format.equals("java.properties")) {
                InputStream inputStream;
                String bundleName = this.toBundleName(baseName, locale);
                String resourceName = this.toResourceName(bundleName, "properties");
                ClassLoader classLoader = loader;
                boolean reloadFlag = reload;
                try {
                    inputStream = AccessController.doPrivileged(() -> {
                        InputStream is = null;
                        if (reloadFlag) {
                            URLConnection connection;
                            URL url = classLoader.getResource(resourceName);
                            if (url != null && (connection = url.openConnection()) != null) {
                                connection.setUseCaches(false);
                                is = connection.getInputStream();
                            }
                        } else {
                            is = classLoader.getResourceAsStream(resourceName);
                        }
                        return is;
                    });
                }
                catch (PrivilegedActionException ex) {
                    throw (IOException)ex.getException();
                }
                if (inputStream != null) {
                    if (ResourceBundleMessageSource.this.defaultEncoding != null) {
                        try (InputStreamReader bundleReader = new InputStreamReader(inputStream, ResourceBundleMessageSource.this.defaultEncoding);){
                            ResourceBundle resourceBundle = ResourceBundleMessageSource.this.loadBundle(bundleReader);
                            return resourceBundle;
                        }
                    }
                    try (InputStream bundleStream = inputStream;){
                        ResourceBundle resourceBundle = ResourceBundleMessageSource.this.loadBundle(bundleStream);
                        return resourceBundle;
                    }
                }
                return null;
            }
            return super.newBundle(baseName, locale, format, loader, reload);
        }

        @Override
        public Locale getFallbackLocale(String baseName, Locale locale) {
            return ResourceBundleMessageSource.this.fallbackToSystemLocale ? super.getFallbackLocale(baseName, locale) : null;
        }

        @Override
        public long getTimeToLive(String baseName, Locale locale) {
            return ResourceBundleMessageSource.this.cacheMillis >= 0L ? ResourceBundleMessageSource.this.cacheMillis : super.getTimeToLive(baseName, locale);
        }

        @Override
        public boolean needsReload(String baseName, Locale locale, String format, ClassLoader loader, ResourceBundle bundle, long loadTime) {
            if (super.needsReload(baseName, locale, format, loader, bundle, loadTime)) {
                ResourceBundleMessageSource.this.cachedBundleMessageFormats.remove(bundle);
                return true;
            }
            return false;
        }
    }
}

