/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util;

import com.aspectran.core.component.bean.annotation.NonSerializable;
import com.aspectran.core.util.ConcurrentReferenceHashMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class BeanDescriptor {
    private static final Map<Class<?>, BeanDescriptor> cache = new ConcurrentReferenceHashMap(256);
    private final String className;
    private final String[] readablePropertyNames;
    private final String[] serializableReadablePropertyNames;
    private final String[] writablePropertyNames;
    private final String[] distinctMethodNames;
    private final Map<String, Method> getterMethods = new HashMap<String, Method>();
    private final Map<String, Class<?>> getterTypes = new HashMap();
    private final Map<String, Method> setterMethods = new HashMap<String, Method>();
    private final Map<String, Class<?>> setterTypes = new HashMap();

    private BeanDescriptor(Class<?> beanClass) {
        this.className = beanClass.getName();
        Method[] methods = this.getAllMethods(beanClass);
        Set<String> nonSerializableReadPropertyNames = this.addGetterMethods(methods);
        this.readablePropertyNames = this.getterMethods.keySet().toArray(new String[0]);
        if (!nonSerializableReadPropertyNames.isEmpty()) {
            String[] serializableReadablePropertyNames = new String[this.readablePropertyNames.length - nonSerializableReadPropertyNames.size()];
            int index = 0;
            String[] stringArray = this.readablePropertyNames;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String name = stringArray[i];
                if (nonSerializableReadPropertyNames.contains(name)) continue;
                serializableReadablePropertyNames[index++] = name;
            }
            this.serializableReadablePropertyNames = index > 0 ? serializableReadablePropertyNames : null;
        } else {
            this.serializableReadablePropertyNames = this.readablePropertyNames;
        }
        this.addSetterMethods(methods);
        this.writablePropertyNames = this.setterMethods.keySet().toArray(new String[0]);
        HashSet<String> nameSet = new HashSet<String>();
        for (Method method : methods) {
            nameSet.add(method.getName());
        }
        this.distinctMethodNames = nameSet.toArray(new String[0]);
    }

    private Set<String> addGetterMethods(Method[] methods) {
        HashSet<String> nonSerializableReadPropertyNames = new HashSet<String>();
        for (Method method : methods) {
            String name;
            if (!Modifier.isPublic(method.getModifiers()) || method.getParameterCount() != 0 || (!(name = method.getName()).startsWith("get") || name.length() <= 3) && (!name.startsWith("is") || name.length() <= 2)) continue;
            name = BeanDescriptor.dropCase(name);
            this.addGetterMethod(name, method);
            if (!method.isAnnotationPresent(NonSerializable.class)) continue;
            nonSerializableReadPropertyNames.add(name);
        }
        return nonSerializableReadPropertyNames;
    }

    private void addGetterMethod(String name, Method method) {
        this.getterMethods.put(name, method);
        this.getterTypes.put(name, method.getReturnType());
    }

    private void addSetterMethods(Method[] methods) {
        HashMap<String, List<Method>> conflictingSetters = new HashMap<String, List<Method>>();
        for (Method method : methods) {
            String name;
            if (!Modifier.isPublic(method.getModifiers()) || method.getParameterCount() != 1 || !(name = method.getName()).startsWith("set") || name.length() <= 3) continue;
            name = BeanDescriptor.dropCase(name);
            this.addConflictingSetter(conflictingSetters, name, method);
        }
        this.resolveSetterConflicts(conflictingSetters);
    }

    private void addConflictingSetter(Map<String, List<Method>> conflictingSetters, String name, Method method) {
        List list = conflictingSetters.computeIfAbsent(name, k -> new ArrayList());
        list.add(method);
    }

    private void resolveSetterConflicts(Map<String, List<Method>> conflictingSetters) {
        for (String propName : conflictingSetters.keySet()) {
            List<Method> setters = conflictingSetters.get(propName);
            Method firstMethod = setters.get(0);
            if (setters.size() == 1) {
                this.addSetterMethod(propName, firstMethod);
                continue;
            }
            Class<?> expectedType = this.getterTypes.get(propName);
            if (expectedType == null) {
                throw new RuntimeException("Illegal overloaded setter method with ambiguous type for property " + propName + " in class " + firstMethod.getDeclaringClass() + ".  This breaks the JavaBeans specification and can cause unpredictable results.");
            }
            Iterator<Method> methods = setters.iterator();
            Method setter = null;
            while (methods.hasNext()) {
                Method method = methods.next();
                if (method.getParameterCount() != 1 || !expectedType.equals(method.getParameterTypes()[0])) continue;
                setter = method;
                break;
            }
            if (setter == null) {
                throw new RuntimeException("Illegal overloaded setter method with ambiguous type for property " + propName + " in class " + firstMethod.getDeclaringClass() + ".  This breaks the JavaBeans specification and can cause unpredictable results.");
            }
            this.addSetterMethod(propName, setter);
        }
    }

    private void addSetterMethod(String name, Method method) {
        this.setterMethods.put(name, method);
        this.setterTypes.put(name, method.getParameterTypes()[0]);
    }

    private Method[] getAllMethods(Class<?> beanClass) {
        HashMap<String, Method> uniqueMethods = new HashMap<String, Method>();
        for (Class<?> currentClass = beanClass; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            Class<?>[] interfaces;
            this.addUniqueMethods(uniqueMethods, currentClass.getDeclaredMethods());
            for (Class<?> anInterface : interfaces = currentClass.getInterfaces()) {
                this.addUniqueMethods(uniqueMethods, anInterface.getMethods());
            }
        }
        Collection methods = uniqueMethods.values();
        return methods.toArray(new Method[0]);
    }

    private void addUniqueMethods(Map<String, Method> uniqueMethods, Method[] methods) {
        for (Method currentMethod : methods) {
            String signature;
            if (currentMethod.isBridge() || uniqueMethods.containsKey(signature = this.getSignature(currentMethod))) continue;
            uniqueMethods.put(signature, currentMethod);
        }
    }

    private String getSignature(Method method) {
        StringBuilder sb = new StringBuilder();
        sb.append(method.getName());
        if (method.getParameterCount() > 0) {
            Class<?>[] parameters = method.getParameterTypes();
            for (int i = 0; i < parameters.length; ++i) {
                if (i == 0) {
                    sb.append(':');
                } else {
                    sb.append(',');
                }
                sb.append(parameters[i].getName());
            }
        }
        return sb.toString();
    }

    private static String dropCase(String name) {
        if (name.startsWith("is")) {
            name = name.substring(2);
        } else if (name.startsWith("get") || name.startsWith("set")) {
            name = name.substring(3);
        } else {
            throw new IllegalArgumentException("Error parsing property name '" + name + "'; Didn't start with 'is', 'get' or 'set'");
        }
        if (name.length() == 1 || name.length() > 1 && !Character.isUpperCase(name.charAt(1))) {
            name = name.substring(0, 1).toLowerCase(Locale.US) + name.substring(1);
        }
        return name;
    }

    public Method getGetter(String name) throws NoSuchMethodException {
        Method method = this.getterMethods.get(name);
        if (method == null) {
            throw new NoSuchMethodException("No such READABLE property named '" + name + "' in class '" + this.className + "'");
        }
        return method;
    }

    public Method getSetter(String name) throws NoSuchMethodException {
        Method method = this.setterMethods.get(name);
        if (method == null) {
            throw new NoSuchMethodException("No such WRITABLE property named '" + name + "' in class '" + this.className + "'");
        }
        return method;
    }

    public Class<?> getGetterType(String name) throws NoSuchMethodException {
        Class<?> type = this.getterTypes.get(name);
        if (type == null) {
            throw new NoSuchMethodException("No such READABLE property named '" + name + "' in class '" + this.className + "'");
        }
        return type;
    }

    public Class<?> getSetterType(String name) throws NoSuchMethodException {
        Class<?> type = this.setterTypes.get(name);
        if (type == null) {
            throw new NoSuchMethodException("No such WRITABLE property named '" + name + "' in class '" + this.className + "'");
        }
        return type;
    }

    public <T extends Annotation> T getSetterAnnotation(String name, Class<T> annotationType) throws NoSuchMethodException {
        Method method = this.getSetter(name);
        return this.getSetterAnnotation(method, annotationType);
    }

    public <T extends Annotation> T getSetterAnnotation(Method method, Class<T> annotationType) {
        T annotation = method.getAnnotation(annotationType);
        if (annotation != null) {
            return annotation;
        }
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        if (parameterAnnotations.length > 0) {
            for (Annotation anno : parameterAnnotations[0]) {
                if (!annotationType.isInstance(anno)) continue;
                return (T)anno;
            }
        }
        return null;
    }

    public String[] getReadablePropertyNames() {
        return this.readablePropertyNames;
    }

    public String[] getReadablePropertyNamesWithoutNonSerializable() {
        return this.serializableReadablePropertyNames;
    }

    public String[] getWritablePropertyNames() {
        return this.writablePropertyNames;
    }

    public boolean hasWritableProperty(String propertyName) {
        return this.setterMethods.containsKey(propertyName);
    }

    public boolean hasReadableProperty(String propertyName) {
        return this.getterMethods.containsKey(propertyName);
    }

    public String[] getDistinctMethodNames() {
        return this.distinctMethodNames;
    }

    public static BeanDescriptor getInstance(Class<?> type) {
        BeanDescriptor existing;
        BeanDescriptor bd = cache.get(type);
        if (bd == null && (existing = cache.putIfAbsent(type, bd = new BeanDescriptor(type))) != null) {
            bd = existing;
        }
        return bd;
    }

    public static synchronized int clearCache() {
        int size = cache.size();
        cache.clear();
        return size;
    }
}

