/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class ExceptionUtils {
    public static Throwable getRootCause(Throwable t) {
        if (t == null) {
            return null;
        }
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }

    public static String getStacktrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString().trim();
    }

    public static Throwable throwIfError(Throwable t) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        return t;
    }

    public static Throwable throwIfRTE(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        return t;
    }

    public static Throwable throwIfIOE(Throwable t) throws IOException {
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        return t;
    }

    public static Throwable throwRootCauseIfIOE(Throwable t) throws IOException {
        return ExceptionUtils.throwIfIOE(ExceptionUtils.getRootCause(t));
    }

    public static IllegalArgumentException throwAsIAE(Throwable t) {
        return ExceptionUtils.throwAsIAE(t, t.getMessage());
    }

    public static IllegalArgumentException throwAsIAE(Throwable t, String msg) {
        ExceptionUtils.throwIfRTE(t);
        ExceptionUtils.throwIfError(t);
        throw new IllegalArgumentException(msg, t);
    }

    public static IllegalArgumentException unwrapAndThrowAsIAE(Throwable t) {
        return ExceptionUtils.throwAsIAE(ExceptionUtils.getRootCause(t));
    }

    public static IllegalArgumentException unwrapAndThrowAsIAE(Throwable t, String msg) {
        throw ExceptionUtils.throwAsIAE(ExceptionUtils.getRootCause(t), msg);
    }
}

