/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util;

import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;

public class FileLocker {
    private static final Logger logger = LoggerFactory.getLogger(FileLocker.class);
    private File lockFile;
    private FileChannel fileChannel;
    private FileLock fileLock;

    public FileLocker(File lockFile) {
        if (lockFile == null) {
            throw new IllegalArgumentException("lockFile must not be null");
        }
        this.lockFile = lockFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lock() throws Exception {
        FileLocker fileLocker = this;
        synchronized (fileLocker) {
            if (this.fileLock != null) {
                throw new Exception("The lock is already held");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Acquiring lock on " + this.lockFile.getAbsolutePath());
            }
            try {
                this.fileChannel = new RandomAccessFile(this.lockFile, "rw").getChannel();
                this.fileLock = this.fileChannel.tryLock();
            }
            catch (IOException | OverlappingFileLockException e) {
                throw new Exception("Exception occurred while trying to get a lock on file: " + this.lockFile.getAbsolutePath(), e);
            }
            if (this.fileLock == null) {
                if (this.fileChannel != null) {
                    try {
                        this.fileChannel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.fileChannel = null;
                }
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws Exception {
        FileLocker fileLocker = this;
        synchronized (fileLocker) {
            if (logger.isDebugEnabled()) {
                logger.debug("Releasing lock on " + this.lockFile.getAbsolutePath());
            }
            if (this.fileLock != null) {
                try {
                    this.fileLock.release();
                    this.fileLock = null;
                }
                catch (Exception e) {
                    throw new Exception("Unable to release locked file: " + this.lockFile.getAbsolutePath(), e);
                }
                if (this.fileChannel != null) {
                    try {
                        this.fileChannel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.fileChannel = null;
                }
                if (this.lockFile != null) {
                    if (this.lockFile.exists()) {
                        this.lockFile.delete();
                    }
                    this.lockFile = null;
                }
            }
        }
    }
}

