/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util;

import com.aspectran.core.util.Assert;
import com.aspectran.core.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import java.util.StringTokenizer;

public class FilenameUtils {
    private static final String NAME_SEPARATOR = "_";
    private static final String EXTENSION_SEPARATOR = ".";
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static final String EXTENSIONS_SEPARATORS = " ,;\t\n\r\f";

    public static String getName(String filename) {
        Assert.notNull((Object)filename, "'filename' must not be null");
        int index = FilenameUtils.indexOfLastSeparator(filename);
        return filename.substring(index + 1);
    }

    public static String getBaseName(String filename) {
        return FilenameUtils.removeExtension(FilenameUtils.getName(filename));
    }

    public static String getExtension(String filename) {
        Assert.notNull((Object)filename, "'filename' must not be null");
        int index = FilenameUtils.indexOfExtension(filename);
        if (index == -1) {
            return "";
        }
        return filename.substring(index + 1);
    }

    public static String removeExtension(String filename) {
        Assert.notNull((Object)filename, "'filename' must not be null");
        int index = FilenameUtils.indexOfExtension(filename);
        if (index == -1) {
            return filename;
        }
        return filename.substring(0, index);
    }

    public static int indexOfLastSeparator(String filename) {
        if (filename == null) {
            return -1;
        }
        int lastUnixPos = filename.lastIndexOf(47);
        int lastWindowsPos = filename.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    public static int indexOfExtension(String filename) {
        if (filename == null) {
            return -1;
        }
        int extensionPos = filename.lastIndexOf(EXTENSION_SEPARATOR);
        int lastSeparator = FilenameUtils.indexOfLastSeparator(filename);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    public static String getFullPath(String filename) {
        if (filename == null) {
            return null;
        }
        int index = FilenameUtils.indexOfLastSeparator(filename);
        if (index < 0) {
            return "";
        }
        return filename.substring(0, index);
    }

    public static String getFullPathWithEndSeparator(String filename) {
        if (filename == null) {
            return null;
        }
        int index = FilenameUtils.indexOfLastSeparator(filename);
        if (index < 0) {
            return "";
        }
        return filename.substring(0, index + 1);
    }

    public static boolean isValidFileExtension(String filename, String allowedFileExtensions, String deniedFileExtensions) {
        if (filename == null) {
            return false;
        }
        String ext = FilenameUtils.getExtension(filename).toLowerCase();
        if (allowedFileExtensions != null && !allowedFileExtensions.isEmpty()) {
            if (ext.length() == 0) {
                return false;
            }
            StringTokenizer st = new StringTokenizer(allowedFileExtensions.toLowerCase(), EXTENSIONS_SEPARATORS);
            while (st.hasMoreTokens()) {
                String ext2 = st.nextToken();
                if (!ext.equals(ext2)) continue;
                return true;
            }
            return false;
        }
        if (deniedFileExtensions != null && !deniedFileExtensions.isEmpty()) {
            if (ext.length() == 0) {
                return true;
            }
            StringTokenizer st = new StringTokenizer(deniedFileExtensions.toLowerCase(), EXTENSIONS_SEPARATORS);
            while (st.hasMoreTokens()) {
                String ext2 = st.nextToken();
                if (!ext.equals(ext2)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static File generateUniqueFile(File srcFile) throws IOException {
        return FilenameUtils.generateUniqueFile(srcFile, EXTENSION_SEPARATOR);
    }

    public static File generateUniqueFile(File srcFile, String extSeparator) throws IOException {
        Assert.notNull((Object)srcFile, "'srcFile' must not be null");
        String path = FilenameUtils.getFullPath(srcFile.getCanonicalPath());
        String name = FilenameUtils.removeExtension(srcFile.getName());
        String ext = FilenameUtils.getExtension(srcFile.getName());
        String newName = StringUtils.hasLength(ext) ? name + extSeparator + ext : name;
        int count = 0;
        File destFile = new File(path, newName);
        while (destFile.exists()) {
            newName = ext != null && !ext.isEmpty() ? name + "-" + count + extSeparator + ext : name + "-" + ++count;
            destFile = new File(path, newName);
        }
        return count == 0 ? srcFile : destFile;
    }

    public static File generateSafetyUniqueFile(File file) throws IOException {
        String path = file.getCanonicalPath();
        String ext = FilenameUtils.getExtension(path);
        String prefix = Long.toString(System.currentTimeMillis());
        Random rnd = new Random();
        String suffix = Integer.toString(rnd.nextInt(9999));
        String fullName = ext != null && !ext.isEmpty() ? prefix + NAME_SEPARATOR + suffix + NAME_SEPARATOR + ext : prefix + NAME_SEPARATOR + suffix;
        File file2 = new File(FilenameUtils.getFullPath(path), fullName);
        return FilenameUtils.generateUniqueFile(file2, NAME_SEPARATOR);
    }

    public static String recoverExtension(String uniqueFilename) {
        return StringUtils.replaceLast(uniqueFilename, NAME_SEPARATOR, EXTENSION_SEPARATOR);
    }
}

