/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util;

import com.aspectran.core.lang.NonNull;
import java.io.Writer;

public class OutputStringWriter
extends Writer {
    private StringBuilder buffer;
    private int initialSize;

    public OutputStringWriter() {
    }

    public OutputStringWriter(int initialSize) {
        this.initialSize = initialSize;
    }

    @Override
    public void write(int c) {
        this.touchBuffer().append((char)c);
    }

    @Override
    public void write(@NonNull char[] cbuf, int off, int len) {
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.touchBuffer().append(cbuf, off, len);
    }

    @Override
    public void write(@NonNull String str) {
        this.touchBuffer().append(str);
    }

    @Override
    public void write(@NonNull String str, int off, int len) {
        this.touchBuffer().append(str, off, off + len);
    }

    @Override
    public OutputStringWriter append(CharSequence csq) {
        if (csq == null) {
            this.write("null");
        } else {
            this.write(csq.toString());
        }
        return this;
    }

    @Override
    public OutputStringWriter append(CharSequence csq, int start, int end) {
        CharSequence cs = csq == null ? "null" : csq;
        this.write(cs.subSequence(start, end).toString());
        return this;
    }

    @Override
    public OutputStringWriter append(char c) {
        this.write(c);
        return this;
    }

    public String toString() {
        return this.buffer != null ? this.touchBuffer().toString() : "";
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public boolean isDirty() {
        return this.buffer != null;
    }

    private StringBuilder touchBuffer() {
        if (this.buffer == null) {
            this.buffer = this.initialSize > 0 ? new StringBuilder(this.initialSize) : new StringBuilder();
        }
        return this.buffer;
    }
}

