/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util;

import com.aspectran.core.util.Win32ConsoleCtrlCloseHook;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class ShutdownHook {
    private static final Logger logger = LoggerFactory.getLogger(ShutdownHook.class);
    private static final List<Task> tasks = new ArrayList<Task>();
    private static Thread hook;
    private static Win32ConsoleCtrlCloseHook win32ConsoleCtrlCloseHook;

    public static synchronized <T extends Task> T addTask(T task) {
        if (task == null) {
            throw new IllegalArgumentException("task must not be null");
        }
        if (hook == null) {
            hook = new Thread("goodbye"){

                @Override
                public void run() {
                    ShutdownHook.runTasks();
                }
            };
            ShutdownHook.registerHook(hook);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Adding shutdown-hook task: " + task);
        }
        tasks.add(task);
        return task;
    }

    public static synchronized void removeTask(Task task) {
        if (task == null) {
            throw new IllegalArgumentException("task must not be null");
        }
        if (hook == null) {
            return;
        }
        tasks.remove(task);
        if (tasks.isEmpty()) {
            ShutdownHook.releaseHook(hook);
            hook = null;
        }
    }

    private static void registerHook(Thread thread) {
        if (logger.isDebugEnabled()) {
            logger.debug("Registering shutdown-hook: " + thread);
        }
        Runtime.getRuntime().addShutdownHook(thread);
        try {
            win32ConsoleCtrlCloseHook = Win32ConsoleCtrlCloseHook.register(hook);
        }
        catch (NoClassDefFoundError e) {
            win32ConsoleCtrlCloseHook = null;
            logger.warn(e);
        }
    }

    private static void releaseHook(Thread thread) {
        if (logger.isDebugEnabled()) {
            logger.debug("Removing shutdown-hook: " + thread);
        }
        try {
            Runtime.getRuntime().removeShutdownHook(thread);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (win32ConsoleCtrlCloseHook != null) {
            win32ConsoleCtrlCloseHook.release();
            win32ConsoleCtrlCloseHook = null;
        }
    }

    private static synchronized void runTasks() {
        if (logger.isDebugEnabled()) {
            logger.debug("Running all shutdown-hook tasks");
        }
        ArrayList<Task> list = new ArrayList<Task>(tasks);
        ListIterator iter = list.listIterator(list.size());
        while (iter.hasPrevious()) {
            Task task = (Task)iter.previous();
            if (logger.isDebugEnabled()) {
                logger.debug("Running task: " + task);
            }
            try {
                task.run();
            }
            catch (Throwable e) {
                logger.warn("Task failed", e);
            }
        }
        tasks.clear();
    }

    public static interface Task {
        public void run() throws Exception;
    }
}

