/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util.cache;

import com.aspectran.core.util.Assert;
import com.aspectran.core.util.cache.Cache;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;

public class ConcurrentLruCache<K, V>
implements Cache<K, V> {
    private final ConcurrentLinkedDeque<K> queue = new ConcurrentLinkedDeque();
    private final ConcurrentHashMap<K, V> cache = new ConcurrentHashMap();
    private final int capacity;
    private final Function<K, V> generator;
    private final ReadWriteLock lock;
    private volatile int size = 0;

    public ConcurrentLruCache(int capacity, Function<K, V> generator) {
        Assert.isTrue(capacity > 0, "capacity must be positive");
        Assert.notNull(generator, "Generator function must not be null");
        this.capacity = capacity;
        this.generator = generator;
        this.lock = new ReentrantReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        V cached = this.cache.get(key);
        if (cached != null) {
            if (this.size < this.capacity) {
                return cached;
            }
            this.lock.readLock().lock();
            try {
                if (this.queue.removeLastOccurrence(key)) {
                    this.queue.offer(key);
                }
                V v = cached;
                return v;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        this.lock.writeLock().lock();
        try {
            K leastUsed;
            cached = this.cache.get(key);
            if (cached != null) {
                if (this.queue.removeLastOccurrence(key)) {
                    this.queue.offer(key);
                }
                V v = cached;
                return v;
            }
            V value = this.generator.apply(key);
            int cacheSize = this.size;
            if (cacheSize == this.capacity && (leastUsed = this.queue.poll()) != null) {
                this.cache.remove(leastUsed);
                --cacheSize;
            }
            this.queue.offer(key);
            this.cache.put(key, value);
            this.size = cacheSize + 1;
            V v = value;
            return v;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void remove(K key) {
        if (!this.isEmpty()) {
            this.lock.writeLock().lock();
            try {
                this.queue.remove(key);
                this.cache.remove(key);
                this.size = this.cache.size();
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    @Override
    public void clear() {
        if (!this.isEmpty()) {
            this.lock.writeLock().lock();
            try {
                this.queue.clear();
                this.cache.clear();
                this.size = 0;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    @Override
    public Set<K> keySet() {
        return this.cache.keySet();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }
}

