/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.util.nodelet;

import com.aspectran.core.util.ArrayStack;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import com.aspectran.core.util.nodelet.NodeEndlet;
import com.aspectran.core.util.nodelet.NodeTracker;
import com.aspectran.core.util.nodelet.Nodelet;
import com.aspectran.core.util.nodelet.NodeletAdder;
import com.aspectran.core.util.nodelet.NodeletException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class NodeletParser {
    private static final Logger logger = LoggerFactory.getLogger(NodeletParser.class);
    private static final Map<String, String> EMPTY_ATTRIBUTES = Collections.emptyMap();
    private final Map<String, Nodelet> nodeletMap = new HashMap<String, Nodelet>();
    private final Map<String, NodeEndlet> endletMap = new HashMap<String, NodeEndlet>();
    private final ArrayStack<Object> objectStack = new ArrayStack();
    private final Object nodeParser;
    private boolean validating;
    private EntityResolver entityResolver;
    private NodeTracker nodeTracker;
    private String xpath;

    public NodeletParser(Object nodeParser) {
        this.nodeParser = nodeParser;
    }

    public <N> N getNodeParser() {
        return (N)this.nodeParser;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public NodeTracker trackingLocation() {
        this.nodeTracker = new NodeTracker();
        return this.nodeTracker;
    }

    public NodeTracker getNodeTracker() {
        return this.nodeTracker;
    }

    public String getXpath() {
        return this.xpath;
    }

    public void setXpath(String xpath) {
        this.xpath = xpath;
    }

    public void addNodelet(Nodelet nodelet) {
        this.nodeletMap.put(this.xpath, nodelet);
    }

    public void addNodeEndlet(NodeEndlet endlet) {
        this.endletMap.put(this.xpath, endlet);
    }

    public void addNodelet(NodeletAdder nodeletAdder) {
        this.addNodelet(this.xpath, nodeletAdder);
    }

    public void addNodelet(String xpath, NodeletAdder nodeletAdder) {
        nodeletAdder.add(xpath, this);
        this.setXpath(xpath);
    }

    public void pushObject(Object object) {
        this.objectStack.push(object);
    }

    public <T> T popObject() {
        return (T)this.objectStack.pop();
    }

    public <T> T peekObject() {
        return (T)this.objectStack.peek();
    }

    public <T> T peekObject(int n) {
        return (T)this.objectStack.peek(n);
    }

    public <T> T peekObject(Class<?> target) {
        return (T)this.objectStack.peek(target);
    }

    public void clearObjectStack() {
        this.objectStack.clear();
    }

    public void parse(Reader reader) throws NodeletException {
        this.parse(new InputSource(reader));
    }

    public void parse(InputStream inputStream) throws NodeletException {
        this.parse(new InputSource(inputStream));
    }

    public void parse(InputSource inputSource) throws NodeletException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(this.validating);
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setEntityResolver(this.entityResolver);
            reader.setContentHandler(new DefaultHandler(){
                private Locator locator;
                private Path path;
                private StringBuilder textBuffer;
                {
                    this.path = new Path(NodeletParser.this.getNodeTracker());
                    this.textBuffer = new StringBuilder();
                }

                @Override
                public void setDocumentLocator(Locator locator) {
                    this.locator = locator;
                }

                @Override
                public void startDocument() throws SAXException {
                    Nodelet nodelet = (Nodelet)NodeletParser.this.nodeletMap.get("/");
                    if (nodelet != null) {
                        try {
                            nodelet.process(EMPTY_ATTRIBUTES);
                        }
                        catch (Exception e) {
                            throw new SAXException("Error processing nodelet at the beginning of document", e);
                        }
                    }
                }

                @Override
                public void endDocument() throws SAXException {
                    NodeEndlet endlet = (NodeEndlet)NodeletParser.this.endletMap.get("/");
                    if (endlet != null) {
                        try {
                            endlet.process(null);
                        }
                        catch (Exception e) {
                            throw new SAXException("Error processing nodelet at the end of document", e);
                        }
                    }
                }

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (NodeletParser.this.nodeTracker != null) {
                        NodeletParser.this.nodeTracker.setName(qName);
                        NodeletParser.this.nodeTracker.setLocation(this.locator.getLineNumber(), this.locator.getColumnNumber());
                    }
                    this.path.add(qName);
                    String pathString = this.path.toString();
                    Map<String, String> attrs = this.parseAttributes(attributes);
                    Nodelet nodelet = (Nodelet)NodeletParser.this.nodeletMap.get(pathString);
                    if (nodelet != null) {
                        try {
                            nodelet.process(attrs);
                        }
                        catch (Exception e) {
                            if (NodeletParser.this.nodeTracker != null) {
                                throw new SAXException("Error processing nodelet at start element " + NodeletParser.this.nodeTracker, e);
                            }
                            throw new SAXException("Error processing nodelet at start element <" + qName + ">", e);
                        }
                    }
                    if (this.textBuffer.length() > 0) {
                        this.textBuffer.delete(0, this.textBuffer.length());
                    }
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    NodeEndlet endlet;
                    if (NodeletParser.this.nodeTracker != null) {
                        NodeletParser.this.nodeTracker.setClonedNodeTracker(this.path.getNodeTracker());
                        NodeletParser.this.nodeTracker.setLocation(this.locator.getLineNumber(), this.locator.getColumnNumber());
                    }
                    String pathString = this.path.toString();
                    this.path.remove();
                    String text = null;
                    if (this.textBuffer.length() > 0) {
                        text = this.textBuffer.toString();
                        this.textBuffer.delete(0, this.textBuffer.length());
                    }
                    if ((endlet = (NodeEndlet)NodeletParser.this.endletMap.get(pathString)) != null) {
                        try {
                            endlet.process(text);
                        }
                        catch (Exception e) {
                            if (NodeletParser.this.nodeTracker != null) {
                                throw new SAXException("Error processing nodelet at end element " + NodeletParser.this.nodeTracker, e);
                            }
                            throw new SAXException("Error processing nodelet at end element <" + qName + ">", e);
                        }
                    }
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    this.textBuffer.append(ch, start, length);
                }

                private Map<String, String> parseAttributes(Attributes attributes) {
                    if (attributes == null) {
                        return EMPTY_ATTRIBUTES;
                    }
                    HashMap<String, String> attr = new HashMap<String, String>();
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        attr.put(attributes.getQName(i), attributes.getValue(i));
                    }
                    return attr;
                }
            });
            reader.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException e) throws SAXException {
                    logger.error(e.toString());
                    throw e;
                }

                @Override
                public void fatalError(SAXParseException e) throws SAXException {
                    logger.error(e.toString());
                    throw e;
                }

                @Override
                public void warning(SAXParseException e) throws SAXException {
                    logger.warn(e.toString());
                }
            });
            reader.parse(inputSource);
        }
        catch (SAXParseException e) {
            throw new NodeletException("Error parsing XML; " + e);
        }
        catch (Exception e) {
            throw new NodeletException("Error parsing XML", e);
        }
    }

    private static class Path {
        private final List<String> nodeList = new ArrayList<String>();
        private final List<NodeTracker> trackerList = new ArrayList<NodeTracker>();
        private final NodeTracker nodeTracker;
        private String path;

        private Path(NodeTracker NodeTracker2) {
            this.nodeTracker = NodeTracker2;
        }

        public void add(String node) {
            this.nodeList.add(node);
            this.path = null;
            if (this.nodeTracker != null) {
                this.trackerList.add(this.nodeTracker.clone());
            }
        }

        public void remove() {
            int index = this.nodeList.size() - 1;
            this.nodeList.remove(index);
            this.path = null;
            if (this.nodeTracker != null) {
                this.trackerList.remove(index);
            }
        }

        public NodeTracker getNodeTracker() {
            return this.trackerList.get(this.trackerList.size() - 1);
        }

        public String toString() {
            if (this.path != null) {
                return this.path;
            }
            StringBuilder sb = new StringBuilder(128);
            for (String name : this.nodeList) {
                sb.append("/").append(name);
            }
            this.path = sb.toString();
            return this.path;
        }
    }
}

