/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.process.result.ActionResult;
import com.aspectran.core.activity.process.result.ContentResult;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ActivityDataMap
extends HashMap<String, Object> {
    private static final long serialVersionUID = -4557424414862800204L;
    private static final Object PREEMPTED = new Object();
    private final Activity activity;

    public ActivityDataMap(Activity activity) {
        this.activity = activity;
        this.refresh();
    }

    @Override
    public Object get(Object key) {
        Object value = super.get(key);
        if (value != null && !value.equals(PREEMPTED)) {
            return value;
        }
        if (key == null) {
            return null;
        }
        String name = key.toString();
        Object data = this.getActionResultWithoutCache(name);
        if (data != null) {
            this.preempt(name, value);
            return data;
        }
        data = this.getAttributeWithoutCache(name);
        if (data != null) {
            this.preempt(name, value);
            return data;
        }
        data = this.getParameterWithoutCache(name);
        if (data != null) {
            this.preempt(name, value);
            return data;
        }
        data = this.getSessionAttributeWithoutCache(name);
        if (data != null) {
            this.preempt(name, value);
            return data;
        }
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        if (this == value) {
            throw new IllegalArgumentException("Same instance as this map can not be stored");
        }
        return super.put(key, value);
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> list = new ArrayList<Object>(this.size());
        for (String name : this.keySet()) {
            list.add(this.get(name));
        }
        return list;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> set = new HashSet<Map.Entry<String, Object>>();
        for (Map.Entry entry : super.entrySet()) {
            if (entry.getValue() == PREEMPTED) {
                String key = (String)entry.getKey();
                Object value = this.get(key);
                set.add(new AbstractMap.SimpleEntry<String, Object>(key, value));
                continue;
            }
            set.add(entry);
        }
        return set;
    }

    public Object getParameterWithoutCache(String name) {
        String[] values;
        if (this.activity.getRequestAdapter() != null && (values = this.activity.getRequestAdapter().getParameterValues(name)) != null) {
            if (values.length == 1) {
                return values[0];
            }
            return values;
        }
        return null;
    }

    public Object getAttributeWithoutCache(String name) {
        if (this.activity.getRequestAdapter() != null) {
            return this.activity.getRequestAdapter().getAttribute(name);
        }
        return null;
    }

    public Object getActionResultWithoutCache(String name) {
        if (this.activity.getProcessResult() != null) {
            return this.activity.getProcessResult().getResultValue(name);
        }
        return null;
    }

    public Object getSessionAttributeWithoutCache(String name) {
        if (this.activity.getSessionAdapter() != null) {
            return this.activity.getSessionAdapter().getAttribute(name);
        }
        return null;
    }

    public void refresh() {
        Enumeration<String> e;
        Object value;
        if (this.activity.getRequestAdapter() != null) {
            for (String name : this.activity.getRequestAdapter().getParameterNames()) {
                this.preempt(name);
            }
            for (String name : this.activity.getRequestAdapter().getAttributeNames()) {
                value = this.activity.getRequestAdapter().getAttribute(name);
                if (this == value) continue;
                this.preempt(name);
            }
        }
        if (this.activity.getSessionAdapter() != null && (e = this.activity.getSessionAdapter().getAttributeNames()) != null) {
            while (e.hasMoreElements()) {
                String name;
                name = e.nextElement();
                value = this.activity.getSessionAdapter().getAttribute(name);
                if (this == value) continue;
                this.preempt(name);
            }
        }
        if (this.activity.getProcessResult() != null) {
            for (ContentResult cr : this.activity.getProcessResult()) {
                for (ActionResult ar : cr) {
                    if (ar.getActionId() == null || this == ar.getResultValue()) continue;
                    this.preempt(ar.getActionId());
                }
            }
        }
    }

    private void preempt(String name) {
        this.preempt(name, super.get(name));
    }

    private void preempt(String name, Object value) {
        if (value == null) {
            this.put(name, PREEMPTED);
        }
    }

    protected Activity getActivity() {
        return this.activity;
    }
}

