/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.process.action;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.process.action.Executable;
import com.aspectran.core.activity.process.result.ProcessResult;
import com.aspectran.core.context.expr.ItemExpression;
import com.aspectran.core.context.rule.IncludeActionRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.type.ActionType;
import com.aspectran.core.util.ToStringBuilder;
import java.util.Map;

public class IncludeAction
implements Executable {
    private final IncludeActionRule includeActionRule;

    public IncludeAction(IncludeActionRule includeActionRule) {
        this.includeActionRule = includeActionRule;
    }

    @Override
    public Object execute(Activity activity) throws Exception {
        try (Activity innerActivity = null;){
            innerActivity = (Activity)activity.newActivity();
            innerActivity.prepare(this.includeActionRule.getTransletName(), this.includeActionRule.getMethodType());
            ItemRuleMap parameterItemRuleMap = this.includeActionRule.getParameterItemRuleMap();
            ItemRuleMap attributeItemRuleMap = this.includeActionRule.getAttributeItemRuleMap();
            if (parameterItemRuleMap != null && !parameterItemRuleMap.isEmpty() || attributeItemRuleMap != null && !attributeItemRuleMap.isEmpty()) {
                Map<String, Object> valueMap;
                ItemExpression evaluator = new ItemExpression(activity);
                if (parameterItemRuleMap != null) {
                    valueMap = evaluator.evaluate(parameterItemRuleMap);
                    for (Map.Entry<String, Object> entry : valueMap.entrySet()) {
                        innerActivity.getRequestAdapter().setParameter(entry.getKey(), entry.getValue().toString());
                    }
                }
                if (attributeItemRuleMap != null) {
                    valueMap = evaluator.evaluate(attributeItemRuleMap);
                    innerActivity.getRequestAdapter().putAllAttributes(valueMap);
                }
            }
            innerActivity.perform();
            ProcessResult processResult = innerActivity.getProcessResult();
            return processResult;
        }
    }

    public IncludeActionRule getIncludeActionRule() {
        return this.includeActionRule;
    }

    @Override
    public String getActionId() {
        return this.includeActionRule.getActionId();
    }

    @Override
    public boolean isHidden() {
        return this.includeActionRule.isHidden();
    }

    @Override
    public ActionType getActionType() {
        return ActionType.INCLUDE;
    }

    @Override
    public <T> T getActionRule() {
        return (T)this.getIncludeActionRule();
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("include", this.includeActionRule);
        return tsb.toString();
    }
}

