/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.response.transform;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.FormattingContext;
import com.aspectran.core.activity.process.result.ProcessResult;
import com.aspectran.core.activity.response.Response;
import com.aspectran.core.activity.response.transform.TransformResponse;
import com.aspectran.core.activity.response.transform.TransformResponseException;
import com.aspectran.core.activity.response.transform.xml.ContentsInputSource;
import com.aspectran.core.activity.response.transform.xml.ContentsXMLReader;
import com.aspectran.core.adapter.ResponseAdapter;
import com.aspectran.core.context.rule.TransformRule;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;

public class XmlTransformResponse
extends TransformResponse {
    private static final String OUTPUT_METHOD_XML = "xml";
    private static final String INDENT_NUMBER_KEY = "indent-number";
    private static final Integer DEFAULT_INDENT_SIZE = 2;
    private static final String YES = "yes";
    private static final Log log = LogFactory.getLog(XmlTransformResponse.class);
    private final String contentType;
    private final String encoding;
    private final Boolean pretty;

    public XmlTransformResponse(TransformRule transformRule) {
        super(transformRule);
        this.contentType = transformRule.getContentType();
        this.encoding = transformRule.getEncoding();
        this.pretty = transformRule.getPretty();
    }

    @Override
    public void commit(Activity activity) {
        ResponseAdapter responseAdapter = activity.getResponseAdapter();
        if (responseAdapter == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Response " + this.getTransformRule());
        }
        try {
            String encoding;
            if (this.encoding != null) {
                encoding = this.encoding;
            } else {
                encoding = responseAdapter.getEncoding();
                if (encoding == null) {
                    encoding = activity.getTranslet().getIntendedResponseEncoding();
                }
            }
            if (encoding != null) {
                responseAdapter.setEncoding(encoding);
            }
            if (this.contentType != null) {
                responseAdapter.setContentType(this.contentType);
            }
            ProcessResult processResult = activity.getProcessResult();
            Writer writer = responseAdapter.getWriter();
            FormattingContext formattingContext = FormattingContext.parse(activity);
            if (this.pretty != null) {
                formattingContext.setPretty(this.pretty);
            }
            XmlTransformResponse.transform(processResult, writer, encoding, formattingContext);
        }
        catch (Exception e) {
            throw new TransformResponseException(this.getTransformRule(), (Throwable)e);
        }
    }

    @Override
    public Response replicate() {
        return new XmlTransformResponse(this.getTransformRule().replicate());
    }

    public static void transform(Object object, Writer writer, String encoding, FormattingContext formattingContext) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        if (formattingContext != null) {
            if (formattingContext.isPretty()) {
                if (formattingContext.getIndentSize() > 0) {
                    transformerFactory.setAttribute(INDENT_NUMBER_KEY, formattingContext.getIndentSize());
                } else {
                    transformerFactory.setAttribute(INDENT_NUMBER_KEY, DEFAULT_INDENT_SIZE);
                }
            }
        } else {
            transformerFactory.setAttribute(INDENT_NUMBER_KEY, DEFAULT_INDENT_SIZE);
        }
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("method", OUTPUT_METHOD_XML);
        if (encoding != null) {
            transformer.setOutputProperty("encoding", encoding);
        }
        if (formattingContext == null || formattingContext.isPretty()) {
            transformer.setOutputProperty("indent", YES);
            transformer.setOutputProperty("doctype-public", YES);
        }
        ContentsXMLReader xmlReader = new ContentsXMLReader();
        if (formattingContext != null) {
            if (formattingContext.getDateFormat() != null) {
                xmlReader.setDateFormat(formattingContext.getDateFormat());
            }
            if (formattingContext.getDateTimeFormat() != null) {
                xmlReader.setDateTimeFormat(formattingContext.getDateTimeFormat());
            }
        }
        ContentsInputSource inputSource = new ContentsInputSource(object);
        SAXSource source = new SAXSource(xmlReader, inputSource);
        transformer.transform(source, new StreamResult(writer));
    }
}

