/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.bean;

import com.aspectran.core.component.bean.AbstractBeanRegistry;
import com.aspectran.core.component.bean.BeanRuleRegistry;
import com.aspectran.core.component.bean.NoSuchBeanException;
import com.aspectran.core.component.bean.NoUniqueBeanException;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.rule.BeanRule;
import com.aspectran.core.context.rule.type.BeanProxifierType;
import com.aspectran.core.lang.NonNull;
import com.aspectran.core.lang.Nullable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Collection;

public class ContextualBeanRegistry
extends AbstractBeanRegistry {
    public ContextualBeanRegistry(ActivityContext context, BeanRuleRegistry beanRuleRegistry, BeanProxifierType beanProxifierType) {
        super(context, beanRuleRegistry, beanProxifierType);
    }

    @Override
    public <T> T getBean(@NonNull String id) {
        BeanRule beanRule = this.getBeanRuleRegistry().getBeanRule(id);
        if (beanRule == null) {
            throw new NoSuchBeanException(id);
        }
        return this.getBean(beanRule);
    }

    @Override
    public <T> T getBean(@NonNull Class<T> type) {
        return this.getBean(type, null);
    }

    @Override
    public <T> T getBean(@NonNull Class<T> type, @Nullable String id) {
        BeanRule[] beanRules = this.getBeanRuleRegistry().getBeanRules(type);
        if (beanRules == null) {
            BeanRule beanRule = this.getBeanRuleRegistry().getBeanRuleForConfig(type);
            if (beanRule != null) {
                return this.getBean(beanRule);
            }
            throw new NoSuchBeanException(type, id);
        }
        if (beanRules.length == 1) {
            if (id != null) {
                if (id.equals(beanRules[0].getId())) {
                    return this.getBean(beanRules[0]);
                }
                throw new NoSuchBeanException(type, id);
            }
            return this.getBean(beanRules[0]);
        }
        if (id != null) {
            for (BeanRule beanRule : beanRules) {
                if (!id.equals(beanRule.getId())) continue;
                return this.getBean(beanRule);
            }
            throw new NoSuchBeanException(type, id);
        }
        throw new NoUniqueBeanException(type, beanRules);
    }

    @Override
    public <T> T[] getBeansOfType(@NonNull Class<T> type) {
        BeanRule[] beanRules = this.getBeanRuleRegistry().getBeanRules(type);
        if (beanRules != null) {
            Object arr = Array.newInstance(type, beanRules.length);
            for (int i = 0; i < beanRules.length; ++i) {
                Object bean = this.getBean(beanRules[i]);
                Array.set(arr, i, bean);
            }
            return (Object[])arr;
        }
        return null;
    }

    @Override
    public boolean containsBean(@NonNull String id) {
        return this.getBeanRuleRegistry().containsBeanRule(id);
    }

    @Override
    public boolean containsBean(@NonNull Class<?> type) {
        return this.getBeanRuleRegistry().containsBeanRule(type);
    }

    @Override
    public boolean containsBean(@NonNull Class<?> type, @Nullable String id) {
        BeanRule[] beanRules = this.getBeanRuleRegistry().getBeanRules(type);
        if (beanRules == null) {
            return false;
        }
        if (beanRules.length == 1) {
            if (id != null) {
                return id.equals(beanRules[0].getId());
            }
            return true;
        }
        if (id != null) {
            for (BeanRule beanRule : beanRules) {
                if (!id.equals(beanRule.getId())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public Collection<Class<?>> findConfigBeanClassesWithAnnotation(Class<? extends Annotation> annotationType) {
        return this.getBeanRuleRegistry().findConfigBeanClassesWithAnnotation(annotationType);
    }
}

