/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.bean.scan;

import com.aspectran.core.component.bean.scan.BeanClassScanFailedException;
import com.aspectran.core.component.bean.scan.BeanClassScanFilter;
import com.aspectran.core.util.ClassScanner;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.core.util.wildcard.WildcardPattern;
import java.lang.reflect.Modifier;

public class BeanClassScanner
extends ClassScanner {
    private static final Log log = LogFactory.getLog(BeanClassScanner.class);
    private BeanClassScanFilter beanClassScanFilter;
    private WildcardPattern beanIdMaskPattern;
    private WildcardPattern[] excludePatterns;

    public BeanClassScanner(ClassLoader classLoader) {
        super(classLoader);
    }

    public void setBeanClassScanFilter(BeanClassScanFilter beanClassScanFilter) {
        this.beanClassScanFilter = beanClassScanFilter;
    }

    public void setExcludePatterns(String[] excludePatterns) {
        if (excludePatterns != null && excludePatterns.length > 0) {
            this.excludePatterns = new WildcardPattern[excludePatterns.length];
            for (int i = 0; i < excludePatterns.length; ++i) {
                WildcardPattern pattern;
                this.excludePatterns[i] = pattern = new WildcardPattern(excludePatterns[i], '.');
            }
        } else {
            this.excludePatterns = null;
        }
    }

    public void setBeanIdMaskPattern(String beanIdMaskPattern) {
        if (beanIdMaskPattern == null) {
            throw new IllegalArgumentException("beanIdMaskPattern must not be null");
        }
        this.beanIdMaskPattern = new WildcardPattern(beanIdMaskPattern, '.');
    }

    @Override
    public void scan(String classNamePattern, ClassScanner.SaveHandler saveHandler) {
        try {
            super.scan(classNamePattern, new BeanSaveHandler(saveHandler));
        }
        catch (Exception e) {
            throw new BeanClassScanFailedException("Failed to scan bean classes with given pattern: " + classNamePattern, e);
        }
    }

    private class BeanSaveHandler
    implements ClassScanner.SaveHandler {
        private ClassScanner.SaveHandler saveHandler;

        public BeanSaveHandler(ClassScanner.SaveHandler saveHandler) {
            this.saveHandler = saveHandler;
        }

        @Override
        public void save(String resourceName, Class<?> targetClass) {
            String className;
            if (!Modifier.isPublic(targetClass.getModifiers()) || !Modifier.isInterface(targetClass.getModifiers()) && Modifier.isAbstract(targetClass.getModifiers())) {
                return;
            }
            String beanId = className = targetClass.getName();
            if (BeanClassScanner.this.beanIdMaskPattern != null) {
                String maskedBeanId = BeanClassScanner.this.beanIdMaskPattern.mask(beanId);
                if (maskedBeanId != null) {
                    beanId = maskedBeanId;
                } else {
                    log.warn("Bean name [" + beanId + "] can not be masked by mask pattern [" + BeanClassScanner.this.beanIdMaskPattern + "]");
                }
            }
            if (BeanClassScanner.this.beanClassScanFilter != null && (beanId = BeanClassScanner.this.beanClassScanFilter.filter(beanId, resourceName, targetClass)) == null) {
                return;
            }
            if (BeanClassScanner.this.excludePatterns != null) {
                for (WildcardPattern pattern : BeanClassScanner.this.excludePatterns) {
                    if (!pattern.matches(className)) continue;
                    return;
                }
            }
            this.saveHandler.save(beanId, targetClass);
            if (log.isTraceEnabled()) {
                log.trace(String.format("Scanned bean {id=%s, class=%s}", beanId, className));
            }
        }
    }
}

