/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.component.AbstractComponent;
import com.aspectran.core.component.session.BasicSession;
import com.aspectran.core.component.session.SessionCache;
import com.aspectran.core.component.session.SessionData;
import com.aspectran.core.component.session.SessionDataStore;
import com.aspectran.core.component.session.SessionHandler;
import com.aspectran.core.component.session.UnreadableSessionDataException;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.core.util.thread.Locker;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractSessionCache
extends AbstractComponent
implements SessionCache {
    private static final Log log = LogFactory.getLog(AbstractSessionCache.class);
    private final SessionHandler sessionHandler;
    private final SessionDataStore sessionDataStore;
    private int evictionIdleSecs = -1;
    private boolean saveOnCreate;
    private boolean saveOnInactiveEviction;
    private boolean removeUnloadableSessions;

    public AbstractSessionCache(SessionHandler sessionHandler, SessionDataStore sessionDataStore) {
        this.sessionHandler = sessionHandler;
        this.sessionDataStore = sessionDataStore;
    }

    protected SessionHandler getSessionHandler() {
        return this.sessionHandler;
    }

    protected SessionDataStore getSessionDataStore() {
        return this.sessionDataStore;
    }

    @Override
    public int getEvictionIdleSecs() {
        return this.evictionIdleSecs;
    }

    @Override
    public void setEvictionIdleSecs(int evictionTimeout) {
        this.evictionIdleSecs = evictionTimeout;
    }

    @Override
    public boolean isSaveOnCreate() {
        return this.saveOnCreate;
    }

    @Override
    public void setSaveOnCreate(boolean saveOnCreate) {
        this.saveOnCreate = saveOnCreate;
    }

    @Override
    public boolean isSaveOnInactiveEviction() {
        return this.saveOnInactiveEviction;
    }

    @Override
    public void setSaveOnInactiveEviction(boolean saveOnEvict) {
        this.saveOnInactiveEviction = saveOnEvict;
    }

    @Override
    public boolean isRemoveUnloadableSessions() {
        return this.removeUnloadableSessions;
    }

    @Override
    public void setRemoveUnloadableSessions(boolean removeUnloadableSessions) {
        this.removeUnloadableSessions = removeUnloadableSessions;
    }

    @Override
    public BasicSession get(String id) throws Exception {
        BasicSession session;
        Exception ex = null;
        while (true) {
            session = this.doGet(id);
            if (this.sessionDataStore == null) break;
            if (session == null) {
                Locker.Lock ignored;
                if (log.isTraceEnabled()) {
                    log.trace("Session " + id + " not found locally, attempting to load");
                }
                PlaceHolderSession phs = new PlaceHolderSession(id, this.sessionHandler);
                Locker.Lock phsLock = phs.lock();
                BasicSession bs = this.doPutIfAbsent(id, phs);
                if (bs == null) {
                    try {
                        session = this.loadSession(id);
                        if (session == null) {
                            this.doDelete(id);
                            phsLock.close();
                            break;
                        }
                        ignored = session.lock();
                        try {
                            boolean success = this.doReplace(id, phs, session);
                            if (success) {
                                session.setResident(true);
                            } else {
                                this.doDelete(id);
                                session = null;
                                log.warn("Replacement of placeholder for session " + id + " failed");
                            }
                            phsLock.close();
                        }
                        finally {
                            if (ignored != null) {
                                ignored.close();
                            }
                        }
                    }
                    catch (Exception e) {
                        ex = e;
                        this.doDelete(id);
                        phsLock.close();
                        session = null;
                    }
                    break;
                }
                phsLock.close();
                ignored = bs.lock();
                try {
                    if (!bs.isResident() || bs instanceof PlaceHolderSession) continue;
                    session = bs;
                    break;
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                    continue;
                }
            }
            Locker.Lock ignored = session.lock();
            try {
                if (session.isResident() && !(session instanceof PlaceHolderSession)) break;
                continue;
            }
            finally {
                if (ignored == null) continue;
                ignored.close();
                continue;
            }
            break;
        }
        if (ex != null) {
            throw ex;
        }
        return session;
    }

    private BasicSession loadSession(String id) throws Exception {
        if (this.sessionDataStore == null) {
            return null;
        }
        try {
            SessionData data = this.sessionDataStore.load(id);
            if (data == null) {
                return null;
            }
            return new BasicSession(data, this.sessionHandler, false);
        }
        catch (UnreadableSessionDataException e) {
            if (this.isRemoveUnloadableSessions()) {
                this.sessionDataStore.delete(id);
            }
            throw e;
        }
    }

    @Override
    public BasicSession add(String id, long time, long maxInactiveInterval) throws Exception {
        SessionData sessionData;
        BasicSession session;
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        if (log.isDebugEnabled()) {
            log.debug("Creating new session id=" + id);
        }
        if (this.doPutIfAbsent(id, session = new BasicSession(sessionData = new SessionData(id, time, time, time, maxInactiveInterval), this.sessionHandler, true)) == null) {
            session.setResident(true);
            if (this.isSaveOnCreate() && this.sessionDataStore != null) {
                this.sessionDataStore.store(id, sessionData);
            }
            return session;
        }
        throw new IllegalStateException("Session " + id + " already in cache");
    }

    @Override
    public void release(String id, BasicSession session) throws Exception {
        if (id == null || session == null) {
            throw new IllegalArgumentException("Put key=" + id + " session=" + (session == null ? "null" : session.getId()));
        }
        try (Locker.Lock ignored = session.lock();){
            if (!session.isValid()) {
                return;
            }
            if (this.sessionDataStore == null) {
                if (log.isTraceEnabled()) {
                    log.trace("Putting into SessionCache only id=" + id);
                }
                session.setResident(true);
                this.doPutIfAbsent(id, session);
                return;
            }
            if (session.getRequests() <= 0L) {
                this.sessionDataStore.store(id, session.getSessionData());
                if (this.getEvictionIdleSecs() == 0) {
                    if (log.isDebugEnabled()) {
                        log.debug("Eviction on request exit id=" + id);
                    }
                    this.doDelete(session.getId());
                    session.setResident(false);
                } else {
                    session.setResident(true);
                    this.doPutIfAbsent(id, session);
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Session " + id + " request=" + session.getRequests());
                }
                session.setResident(true);
                this.doPutIfAbsent(id, session);
            }
        }
    }

    @Override
    public boolean exists(String id) throws Exception {
        BasicSession bs = this.doGet(id);
        if (bs != null) {
            try (Locker.Lock ignored = bs.lock();){
                boolean bl = bs.isValid();
                return bl;
            }
        }
        return this.sessionDataStore != null && this.sessionDataStore.exists(id);
    }

    @Override
    public boolean contains(String id) throws Exception {
        return this.doGet(id) != null;
    }

    @Override
    public BasicSession delete(String id) throws Exception {
        BasicSession session = this.get(id);
        if (this.sessionDataStore != null) {
            boolean deleted = this.sessionDataStore.delete(id);
            if (log.isDebugEnabled()) {
                log.debug("Session " + id + " deleted in session data store: " + deleted);
            }
        }
        if (session != null) {
            session.setResident(false);
        }
        return this.doDelete(id);
    }

    public abstract BasicSession doGet(String var1);

    public abstract BasicSession doPutIfAbsent(String var1, BasicSession var2);

    public abstract boolean doReplace(String var1, BasicSession var2, BasicSession var3);

    public abstract BasicSession doDelete(String var1);

    @Override
    public BasicSession renewSessionId(String oldId, String newId) throws Exception {
        if (!StringUtils.hasText(oldId)) {
            throw new IllegalArgumentException("Old session id is null");
        }
        if (!StringUtils.hasText(oldId)) {
            throw new IllegalArgumentException("New session id is null");
        }
        BasicSession session = this.get(oldId);
        this.renewSessionId(session, newId);
        return session;
    }

    protected void renewSessionId(BasicSession session, String newId) throws Exception {
        if (session == null) {
            return;
        }
        try (Locker.Lock ignored = session.lock();){
            String oldId = session.getId();
            session.checkValidForWrite();
            session.getSessionData().setId(newId);
            session.getSessionData().setLastSaved(0L);
            session.getSessionData().setDirty(true);
            this.doPutIfAbsent(newId, session);
            this.doDelete(oldId);
            if (this.sessionDataStore != null) {
                this.sessionDataStore.delete(oldId);
                this.sessionDataStore.store(newId, session.getSessionData());
            }
            if (log.isDebugEnabled()) {
                log.debug("Session id " + oldId + " swapped for new id " + newId);
            }
        }
    }

    @Override
    public Set<String> checkExpiration(Set<String> candidates) {
        if (!this.isInitialized()) {
            return null;
        }
        if (this.sessionDataStore == null) {
            return candidates;
        }
        if (log.isTraceEnabled()) {
            log.trace("SessionDataStore checking expiration on " + candidates);
        }
        Set<String> allCandidates = this.sessionDataStore.getExpired(candidates);
        HashSet<String> sessionsInUse = new HashSet<String>();
        if (allCandidates != null) {
            for (String c : allCandidates) {
                BasicSession bs = this.doGet(c);
                if (bs == null || bs.getRequests() <= 0L) continue;
                sessionsInUse.add(c);
            }
            try {
                allCandidates.removeAll(sessionsInUse);
            }
            catch (UnsupportedOperationException e) {
                HashSet<String> tmp = new HashSet<String>(allCandidates);
                tmp.removeAll(sessionsInUse);
                allCandidates = tmp;
            }
        }
        return allCandidates;
    }

    @Override
    public void checkInactiveSession(BasicSession session) {
        if (session == null) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("Checking for idle " + session.getId());
        }
        try (Locker.Lock ignored = session.lock();){
            if (this.getEvictionIdleSecs() > 0 && session.isIdleLongerThan(this.getEvictionIdleSecs()) && session.isValid() && session.isResident() && session.getRequests() <= 0L) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Evicting idle session " + session.getId());
                    }
                    if (this.isSaveOnInactiveEviction() && this.sessionDataStore != null) {
                        this.sessionDataStore.store(session.getId(), session.getSessionData());
                    }
                    this.doDelete(session.getId());
                    session.setResident(false);
                }
                catch (Exception e) {
                    log.warn("Passivation of idle session" + session.getId() + " failed", e);
                }
            }
        }
    }

    static class PlaceHolderSession
    extends BasicSession {
        PlaceHolderSession(String id, SessionHandler sessionHandler) {
            super(new SessionData(id, 0L, 0L, 0L, 0L), sessionHandler, false);
        }
    }
}

