/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.component.AbstractComponent;
import com.aspectran.core.component.session.SessionData;
import com.aspectran.core.component.session.SessionDataStore;
import com.aspectran.core.util.ToStringBuilder;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public abstract class AbstractSessionDataStore
extends AbstractComponent
implements SessionDataStore {
    private static final Log log = LogFactory.getLog(AbstractSessionDataStore.class);
    private int gracePeriodSecs = 3600;
    private long lastExpiryCheckTime = 0L;
    private int savePeriodSecs = 0;
    private Set<String> nonPersistentAttributes;

    public int getGracePeriodSecs() {
        return this.gracePeriodSecs;
    }

    public void setGracePeriodSecs(int gracePeriodSecs) {
        this.gracePeriodSecs = gracePeriodSecs;
    }

    public int getSavePeriodSecs() {
        return this.savePeriodSecs;
    }

    public void setSavePeriodSecs(int savePeriodSecs) {
        this.savePeriodSecs = savePeriodSecs;
    }

    @Override
    public Set<String> getNonPersistentAttributes() {
        return this.nonPersistentAttributes;
    }

    public void setNonPersistentAttributes(String ... nonPersistentAttributes) {
        if (nonPersistentAttributes != null && nonPersistentAttributes.length > 0) {
            HashSet attrNames = new HashSet();
            Collections.addAll(attrNames, nonPersistentAttributes);
            this.nonPersistentAttributes = Collections.unmodifiableSet(attrNames);
        } else {
            this.nonPersistentAttributes = null;
        }
    }

    public boolean isNonPersistentAttributes(String attrName) {
        if (this.nonPersistentAttributes != null) {
            return this.nonPersistentAttributes.contains(attrName);
        }
        return false;
    }

    public abstract void doStore(String var1, SessionData var2, long var3) throws Exception;

    public abstract Set<String> doGetExpired(Set<String> var1);

    @Override
    public void store(String id, SessionData data) throws Exception {
        long savePeriodMs;
        if (data == null) {
            return;
        }
        long lastSave = data.getLastSaved();
        long l = savePeriodMs = this.savePeriodSecs <= 0 ? 0L : TimeUnit.SECONDS.toMillis(this.savePeriodSecs);
        if (log.isDebugEnabled()) {
            ToStringBuilder tsb = new ToStringBuilder("Store session");
            tsb.append("id", id);
            tsb.append("dirty", data.isDirty());
            tsb.append("lastSaved", data.getLastSaved());
            tsb.append("period", savePeriodMs);
            tsb.append("elapsed", System.currentTimeMillis() - lastSave);
            log.debug(tsb.toString());
        }
        if (data.isDirty() || lastSave <= 0L || System.currentTimeMillis() - lastSave > savePeriodMs) {
            data.setLastSaved(System.currentTimeMillis());
            try {
                this.doStore(id, data, lastSave);
                data.setDirty(false);
            }
            catch (Exception e) {
                data.setLastSaved(lastSave);
                throw e;
            }
        }
    }

    @Override
    public Set<String> getExpired(Set<String> candidates) {
        try {
            Set<String> set = this.doGetExpired(candidates);
            return set;
        }
        finally {
            this.lastExpiryCheckTime = System.currentTimeMillis();
        }
    }

    public long getLastExpiryCheckTime() {
        return this.lastExpiryCheckTime;
    }

    @Override
    public SessionData createSessionData(String id, long createdTime, long accessedTime, long lastAccessedTime, long maxInactiveInterval) {
        return new SessionData(id, createdTime, accessedTime, lastAccessedTime, maxInactiveInterval);
    }

    protected void checkAlreadyInitialized() throws IllegalStateException {
        if (this.isInitialized()) {
            throw new IllegalStateException("Already initialized");
        }
    }
}

