/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.component.session.AbstractSessionCache;
import com.aspectran.core.component.session.BasicSession;
import com.aspectran.core.component.session.Session;
import com.aspectran.core.component.session.SessionDataStore;
import com.aspectran.core.component.session.SessionHandler;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.core.util.statistic.CounterStatistic;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class DefaultSessionCache
extends AbstractSessionCache {
    private static final Log log = LogFactory.getLog(DefaultSessionCache.class);
    private final Map<String, BasicSession> sessions = new ConcurrentHashMap<String, BasicSession>();
    private final CounterStatistic statistics = new CounterStatistic();
    private final AtomicLong expiredSessionCount = new AtomicLong();
    private final AtomicLong rejectedSessionCount = new AtomicLong();
    private volatile int maxSessions;

    public DefaultSessionCache(SessionHandler sessionHandler, SessionDataStore sessionDataStore) {
        super(sessionHandler, sessionDataStore);
    }

    @Override
    public int getMaxSessions() {
        return this.maxSessions;
    }

    @Override
    public void setMaxSessions(int maxSessions) {
        this.maxSessions = maxSessions;
    }

    @Override
    public BasicSession doGet(String id) {
        if (id == null) {
            return null;
        }
        return this.sessions.get(id);
    }

    @Override
    public BasicSession doPutIfAbsent(String id, BasicSession session) {
        this.checkMaxSessions();
        BasicSession bs = this.sessions.putIfAbsent(id, session);
        if (bs == null && !(session instanceof AbstractSessionCache.PlaceHolderSession)) {
            this.statistics.increment();
        }
        return bs;
    }

    @Override
    public BasicSession doDelete(String id) {
        BasicSession bs = this.sessions.remove(id);
        if (bs != null && !(bs instanceof AbstractSessionCache.PlaceHolderSession)) {
            this.statistics.decrement();
            this.expiredSessionCount.incrementAndGet();
        }
        return bs;
    }

    @Override
    public boolean doReplace(String id, BasicSession oldValue, BasicSession newValue) {
        this.checkMaxSessions();
        boolean result = this.sessions.replace(id, oldValue, newValue);
        if (result && oldValue instanceof AbstractSessionCache.PlaceHolderSession) {
            this.statistics.increment();
        }
        return result;
    }

    @Override
    public Set<String> getAllSessions() {
        return this.sessions.keySet();
    }

    @Override
    public long getActiveSessionCount() {
        return this.statistics.getCurrent();
    }

    @Override
    public long getHighestSessionCount() {
        return this.statistics.getMax();
    }

    @Override
    public long getCreatedSessionCount() {
        return this.statistics.getTotal();
    }

    @Override
    public long getExpiredSessionCount() {
        return this.expiredSessionCount.get();
    }

    @Override
    public long getRejectedSessionCount() {
        return this.rejectedSessionCount.get();
    }

    @Override
    public void resetStatistics() {
        this.statistics.reset();
        this.expiredSessionCount.set(0L);
        this.rejectedSessionCount.set(0L);
    }

    private void checkMaxSessions() {
        if (this.maxSessions > 0 && this.statistics.getCurrent() > (long)this.maxSessions) {
            this.rejectedSessionCount.incrementAndGet();
            throw new IllegalStateException("Session was rejected as the maximum number of sessions " + this.maxSessions + " has been hit");
        }
    }

    @Override
    protected void doInitialize() throws Exception {
        if (this.getSessionDataStore() != null) {
            this.getSessionDataStore().initialize();
        }
    }

    @Override
    protected void doDestroy() throws Exception {
        int loop = 100;
        while (!this.sessions.isEmpty() && loop-- >= 0) {
            for (BasicSession session : this.sessions.values()) {
                if (this.getSessionDataStore() != null) {
                    if (this.getSessionDataStore().getNonPersistentAttributes() != null) {
                        for (String attrName : this.getSessionDataStore().getNonPersistentAttributes()) {
                            session.removeAttribute(attrName);
                        }
                    }
                    try {
                        this.getSessionDataStore().store(session.getId(), session.getSessionData());
                    }
                    catch (Exception e) {
                        log.warn("Failed to save session data", e);
                    }
                    this.doDelete(session.getId());
                    continue;
                }
                try {
                    session.invalidate();
                    session.setDestroyedReason(Session.DestroyedReason.UNDEPLOY);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Session invalidation failed, but ignored", e);
                }
            }
        }
        if (this.getSessionDataStore() != null) {
            this.getSessionDataStore().destroy();
        }
    }
}

