/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.adapter.ApplicationAdapter;
import com.aspectran.core.component.session.AbstractSessionHandler;
import com.aspectran.core.component.session.DefaultSessionCache;
import com.aspectran.core.component.session.FileSessionDataStore;
import com.aspectran.core.component.session.HouseKeeper;
import com.aspectran.core.component.session.SessionDataStoreFactory;
import com.aspectran.core.component.session.SessionHandler;
import com.aspectran.core.component.session.SessionIdGenerator;
import com.aspectran.core.component.session.SessionManager;
import com.aspectran.core.context.config.SessionManagerConfig;
import com.aspectran.core.context.rule.type.SessionStoreType;
import java.io.IOException;

public class DefaultSessionManager
extends AbstractSessionHandler
implements SessionManager {
    private ApplicationAdapter applicationAdapter;
    private SessionManagerConfig sessionManagerConfig;

    public ApplicationAdapter getApplicationAdapter() {
        return this.applicationAdapter;
    }

    public void setApplicationAdapter(ApplicationAdapter applicationAdapter) {
        this.applicationAdapter = applicationAdapter;
    }

    @Override
    public SessionManagerConfig getSessionManagerConfig() {
        return this.sessionManagerConfig;
    }

    public void setSessionManagerConfig(SessionManagerConfig sessionManagerConfig) {
        this.sessionManagerConfig = sessionManagerConfig;
    }

    public void setSessionManagerConfigWithApon(String apon) {
        SessionManagerConfig sessionManagerConfig = new SessionManagerConfig();
        try {
            sessionManagerConfig.readFrom(apon);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.setSessionManagerConfig(sessionManagerConfig);
    }

    @Override
    public SessionHandler getSessionHandler() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("DefaultSessionManager is not yet initialized");
        }
        return this;
    }

    @Override
    protected void doInitialize() throws Exception {
        if (this.sessionManagerConfig != null) {
            int secs;
            if (this.sessionManagerConfig.hasWorkerName()) {
                this.setWorkerName(this.sessionManagerConfig.getWorkerName());
            } else {
                this.setWorkerName("node0");
            }
            if (this.sessionManagerConfig.hasMaxIdleSeconds()) {
                secs = this.sessionManagerConfig.getMaxIdleSeconds();
                this.setDefaultMaxIdleSecs(secs);
            }
            if (this.sessionManagerConfig.hasScavengingIntervalSeconds()) {
                secs = this.sessionManagerConfig.getScavengingIntervalSeconds();
                if (secs > 0) {
                    HouseKeeper houseKeeper = new HouseKeeper(this);
                    houseKeeper.setScavengingInterval(secs);
                    this.setHouseKeeper(houseKeeper);
                }
            } else {
                this.setHouseKeeper(new HouseKeeper(this));
            }
        }
        if (this.getSessionIdGenerator() == null) {
            SessionIdGenerator sessionIdGenerator = new SessionIdGenerator(this.getWorkerName());
            this.setSessionIdGenerator(sessionIdGenerator);
        }
        if (this.getSessionCache() == null) {
            FileSessionDataStore sessionDataStore = null;
            if (this.sessionManagerConfig != null) {
                String storeType = this.sessionManagerConfig.getStoreType();
                SessionStoreType sessionStoreType = SessionStoreType.resolve(storeType);
                if (storeType != null && sessionStoreType == null) {
                    throw new IllegalArgumentException("Unknown session store type: " + storeType);
                }
                if (sessionStoreType == SessionStoreType.FILE) {
                    sessionDataStore = SessionDataStoreFactory.createFileSessionDataStore(this.sessionManagerConfig, this.getApplicationAdapter());
                }
            }
            DefaultSessionCache sessionCache = new DefaultSessionCache(this, sessionDataStore);
            if (this.sessionManagerConfig != null) {
                if (this.sessionManagerConfig.hasMaxSessions()) {
                    int maxSessions = this.sessionManagerConfig.getMaxSessions();
                    sessionCache.setMaxSessions(maxSessions);
                }
                if (this.sessionManagerConfig.hasEvictionIdleSeconds()) {
                    int secs = this.sessionManagerConfig.getEvictionIdleSeconds();
                    sessionCache.setEvictionIdleSecs(secs);
                }
                if (this.sessionManagerConfig.hasSaveOnCreate()) {
                    boolean saveOnCreate = this.sessionManagerConfig.getSaveOnCreate();
                    sessionCache.setSaveOnCreate(saveOnCreate);
                }
                if (this.sessionManagerConfig.hasSaveOnInactiveEviction()) {
                    boolean saveOnInactiveEviction = this.sessionManagerConfig.getSaveOnInactiveEviction();
                    sessionCache.setSaveOnInactiveEviction(saveOnInactiveEviction);
                }
                if (this.sessionManagerConfig.hasRemoveUnloadableSessions()) {
                    boolean removeUnloadableSessions = this.sessionManagerConfig.getRemoveUnloadableSessions();
                    sessionCache.setRemoveUnloadableSessions(removeUnloadableSessions);
                }
            }
            sessionCache.initialize();
            this.setSessionCache(sessionCache);
        }
        super.doInitialize();
    }
}

