/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.component.session.Session;
import com.aspectran.core.component.session.SessionHandler;
import java.util.Collections;
import java.util.Enumeration;

public class SessionAgent {
    private final SessionHandler sessionHandler;
    private volatile Session session;

    public SessionAgent(SessionHandler sessionHandler) {
        this.sessionHandler = sessionHandler;
    }

    public String getId() {
        return this.getSession(true).getId();
    }

    public long getCreationTime() {
        return this.getSession(true).getCreationTime();
    }

    public long getLastAccessedTime() {
        return this.getSession(true).getLastAccessedTime();
    }

    public int getMaxInactiveInterval() {
        return this.getSession(true).getMaxInactiveInterval();
    }

    public void setMaxInactiveInterval(int secs) {
        this.getSession(true).setMaxInactiveInterval(secs);
    }

    public Enumeration<String> getAttributeNames() {
        Session session = this.getSession(false);
        if (session == null) {
            return null;
        }
        return Collections.enumeration(session.getAttributeNames());
    }

    public <T> T getAttribute(String name) {
        Session session = this.getSession(false);
        if (session == null) {
            return null;
        }
        return session.getAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this.getSession(true).setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        Session session = this.getSession(false);
        if (session != null) {
            session.removeAttribute(name);
        }
    }

    public Session getSession(boolean create) {
        if (this.session != null) {
            if (this.session.isValid()) {
                return this.session;
            }
            this.session = null;
        }
        if (!create) {
            return null;
        }
        String id = this.sessionHandler.createSessionId(this.hashCode());
        this.session = this.sessionHandler.createSession(id);
        return this.session;
    }

    public void invalidate() {
        Session session = this.getSession(false);
        if (session != null) {
            session.invalidate();
        }
    }

    public boolean isNew() {
        Session session = this.getSession(false);
        if (session == null) {
            return true;
        }
        return session.isNew();
    }

    public void access() {
        Session session = this.getSession(false);
        if (session != null) {
            session.access();
        }
    }

    public void complete() {
        Session session = this.getSession(false);
        if (session != null) {
            session.complete();
        }
    }
}

