/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.adapter.ApplicationAdapter;
import com.aspectran.core.component.session.FileSessionDataStore;
import com.aspectran.core.context.config.SessionFileStoreConfig;
import com.aspectran.core.context.config.SessionManagerConfig;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.SystemUtils;
import java.io.File;

public class SessionDataStoreFactory {
    public static FileSessionDataStore createFileSessionDataStore(SessionManagerConfig sessionManagerConfig, ApplicationAdapter applicationAdapter) {
        SessionFileStoreConfig fileStoreConfig;
        FileSessionDataStore fileSessionDataStore = new FileSessionDataStore();
        if (sessionManagerConfig.hasNonPersistentAttributes()) {
            fileSessionDataStore.setNonPersistentAttributes(sessionManagerConfig.getNonPersistentAttributes());
        }
        if ((fileStoreConfig = sessionManagerConfig.getFileStoreConfig()) != null) {
            String storeDir = fileStoreConfig.getStoreDir();
            if (StringUtils.hasText(storeDir)) {
                if (applicationAdapter != null) {
                    String basePath = applicationAdapter.getBasePath();
                    fileSessionDataStore.setStoreDir(new File(basePath, storeDir));
                } else {
                    fileSessionDataStore.setStoreDir(new File(storeDir));
                }
            } else {
                fileSessionDataStore.setStoreDir(new File(SystemUtils.getJavaIoTmpDir()));
            }
            boolean deleteUnrestorableFiles = fileStoreConfig.isDeleteUnrestorableFiles();
            if (deleteUnrestorableFiles) {
                fileSessionDataStore.setDeleteUnrestorableFiles(true);
            }
        }
        return fileSessionDataStore;
    }
}

