/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.translet.scan;

import com.aspectran.core.component.translet.scan.TransletScanFailedException;
import com.aspectran.core.component.translet.scan.TransletScanFilter;
import com.aspectran.core.util.FileScanner;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.core.util.wildcard.WildcardMatcher;
import com.aspectran.core.util.wildcard.WildcardPattern;
import java.io.File;

public class TransletScanner
extends FileScanner {
    private static final Log log = LogFactory.getLog(TransletScanner.class);
    private TransletScanFilter transletScanFilter;
    private WildcardPattern transletNameMaskPattern;
    private WildcardPattern[] excludePatterns;

    public TransletScanner(String basePath) {
        super(basePath);
    }

    public void setTransletScanFilter(TransletScanFilter transletScanFilter) {
        this.transletScanFilter = transletScanFilter;
    }

    public void setExcludePatterns(String[] excludePatterns) {
        if (excludePatterns != null && excludePatterns.length > 0) {
            this.excludePatterns = new WildcardPattern[excludePatterns.length];
            for (int i = 0; i < excludePatterns.length; ++i) {
                WildcardPattern pattern;
                this.excludePatterns[i] = pattern = new WildcardPattern(excludePatterns[i], '/');
            }
        } else {
            this.excludePatterns = null;
        }
    }

    public void setTransletNameMaskPattern(String transletNameMaskPattern) {
        if (transletNameMaskPattern == null) {
            throw new IllegalArgumentException("transletNameMaskPattern must not be null");
        }
        this.transletNameMaskPattern = new WildcardPattern(transletNameMaskPattern, '/');
    }

    @Override
    protected void scan(String targetPath, WildcardMatcher matcher, FileScanner.SaveHandler saveHandler) {
        try {
            super.scan(targetPath, matcher, (FileScanner.SaveHandler)new TransletSaveHandler(saveHandler));
        }
        catch (Exception e) {
            throw new TransletScanFailedException("Failed to scan translets from given path: " + targetPath, e);
        }
    }

    private class TransletSaveHandler
    implements FileScanner.SaveHandler {
        private final FileScanner.SaveHandler saveHandler;

        private TransletSaveHandler(FileScanner.SaveHandler saveHandler) {
            this.saveHandler = saveHandler;
        }

        @Override
        public void save(String filePath, File scannedFile) {
            boolean passing;
            String transletName = filePath;
            if (TransletScanner.this.transletNameMaskPattern != null) {
                String maskedTransletName = TransletScanner.this.transletNameMaskPattern.mask(transletName);
                if (maskedTransletName != null) {
                    transletName = maskedTransletName;
                } else {
                    log.warn("Translet name [" + transletName + "] can not be masked by mask pattern [" + TransletScanner.this.transletNameMaskPattern + "]");
                }
            }
            if (TransletScanner.this.transletScanFilter != null && !(passing = TransletScanner.this.transletScanFilter.filter(transletName, scannedFile))) {
                return;
            }
            if (TransletScanner.this.excludePatterns != null) {
                for (WildcardPattern pattern : TransletScanner.this.excludePatterns) {
                    if (!pattern.matches(filePath)) continue;
                    return;
                }
            }
            this.saveHandler.save(transletName, scannedFile);
            if (log.isTraceEnabled()) {
                log.trace("Scanned file: " + filePath);
            }
        }
    }
}

