/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.DefaultActivity;
import com.aspectran.core.adapter.ApplicationAdapter;
import com.aspectran.core.component.AbstractComponent;
import com.aspectran.core.component.aspect.AspectRuleRegistry;
import com.aspectran.core.component.bean.BeanRegistry;
import com.aspectran.core.component.bean.ContextualBeanRegistry;
import com.aspectran.core.component.schedule.ScheduleRuleRegistry;
import com.aspectran.core.component.template.ContextualTemplateRenderer;
import com.aspectran.core.component.template.TemplateRenderer;
import com.aspectran.core.component.translet.TransletRuleRegistry;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.env.ContextEnvironment;
import com.aspectran.core.context.env.Environment;
import com.aspectran.core.service.CoreService;
import com.aspectran.core.support.i18n.message.DelegatingMessageSource;
import com.aspectran.core.support.i18n.message.MessageSource;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;

public class AspectranActivityContext
extends AbstractComponent
implements ActivityContext {
    private static final Log log = LogFactory.getLog(AspectranActivityContext.class);
    private final ThreadLocal<Activity> currentActivityHolder = new ThreadLocal();
    private final ApplicationAdapter applicationAdapter;
    private final ContextEnvironment contextEnvironment;
    private final Activity defaultActivity;
    private String description;
    private CoreService rootService;
    private AspectRuleRegistry aspectRuleRegistry;
    private ContextualBeanRegistry contextualBeanRegistry;
    private ContextualTemplateRenderer contextualTemplateRenderer;
    private ScheduleRuleRegistry scheduleRuleRegistry;
    private TransletRuleRegistry transletRuleRegistry;
    private MessageSource messageSource;

    public AspectranActivityContext(ApplicationAdapter applicationAdapter, ContextEnvironment contextEnvironment) {
        this.applicationAdapter = applicationAdapter;
        this.contextEnvironment = contextEnvironment;
        this.defaultActivity = new DefaultActivity(this);
    }

    @Override
    public ApplicationAdapter getApplicationAdapter() {
        return this.applicationAdapter;
    }

    @Override
    public Environment getEnvironment() {
        return this.contextEnvironment;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public CoreService getRootService() {
        return this.rootService;
    }

    @Override
    public void setRootService(CoreService rootService) {
        if (this.isInitialized()) {
            throw new IllegalStateException("ActivityContext is already specified");
        }
        this.rootService = rootService;
    }

    @Override
    public AspectRuleRegistry getAspectRuleRegistry() {
        return this.aspectRuleRegistry;
    }

    public void setAspectRuleRegistry(AspectRuleRegistry aspectRuleRegistry) {
        this.aspectRuleRegistry = aspectRuleRegistry;
    }

    @Override
    public BeanRegistry getBeanRegistry() {
        return this.contextualBeanRegistry;
    }

    public void setContextualBeanRegistry(ContextualBeanRegistry contextualBeanRegistry) {
        this.contextualBeanRegistry = contextualBeanRegistry;
    }

    @Override
    public TemplateRenderer getTemplateRenderer() {
        return this.contextualTemplateRenderer;
    }

    public void setContextualTemplateRenderer(ContextualTemplateRenderer contextualTemplateRenderer) {
        this.contextualTemplateRenderer = contextualTemplateRenderer;
    }

    @Override
    public ScheduleRuleRegistry getScheduleRuleRegistry() {
        return this.scheduleRuleRegistry;
    }

    public void setScheduleRuleRegistry(ScheduleRuleRegistry scheduleRuleRegistry) {
        this.scheduleRuleRegistry = scheduleRuleRegistry;
    }

    @Override
    public TransletRuleRegistry getTransletRuleRegistry() {
        return this.transletRuleRegistry;
    }

    public void setTransletRuleRegistry(TransletRuleRegistry transletRuleRegistry) {
        this.transletRuleRegistry = transletRuleRegistry;
    }

    @Override
    public MessageSource getMessageSource() {
        if (this.messageSource == null) {
            throw new IllegalStateException("No MessageSource configured");
        }
        return this.messageSource;
    }

    @Override
    public Activity getDefaultActivity() {
        return this.defaultActivity;
    }

    @Override
    public Activity getCurrentActivity() {
        Activity activity = this.currentActivityHolder.get();
        return activity != null ? activity : this.getDefaultActivity();
    }

    @Override
    public void setCurrentActivity(Activity activity) {
        this.currentActivityHolder.set(activity);
    }

    @Override
    public void removeCurrentActivity() {
        this.currentActivityHolder.remove();
    }

    private void initMessageSource() {
        if (this.contextualBeanRegistry.containsBean(MessageSource.class, "messageSource")) {
            this.messageSource = this.contextualBeanRegistry.getBean(MessageSource.class, "messageSource");
            if (log.isDebugEnabled()) {
                log.debug("Using MessageSource [" + this.messageSource + "]");
            }
        }
        if (this.messageSource == null) {
            this.messageSource = new DelegatingMessageSource();
            if (log.isDebugEnabled()) {
                log.debug("Unable to locate MessageSource with name 'messageSource': using default [" + this.messageSource + "]");
            }
        }
    }

    @Override
    protected void doInitialize() throws Exception {
        if (this.aspectRuleRegistry != null) {
            this.aspectRuleRegistry.initialize();
        }
        if (this.contextualBeanRegistry != null) {
            this.contextualBeanRegistry.initialize();
        }
        if (this.contextualTemplateRenderer != null) {
            this.contextualTemplateRenderer.initialize();
        }
        if (this.scheduleRuleRegistry != null) {
            this.scheduleRuleRegistry.initialize();
        }
        if (this.transletRuleRegistry != null) {
            this.transletRuleRegistry.initialize();
        }
        if (this.contextualBeanRegistry != null) {
            this.initMessageSource();
        }
    }

    @Override
    protected void doDestroy() {
        if (this.transletRuleRegistry != null) {
            this.transletRuleRegistry.destroy();
            this.transletRuleRegistry = null;
        }
        if (this.scheduleRuleRegistry != null) {
            this.scheduleRuleRegistry.destroy();
            this.scheduleRuleRegistry = null;
        }
        if (this.contextualTemplateRenderer != null) {
            this.contextualTemplateRenderer.destroy();
            this.contextualTemplateRenderer = null;
        }
        if (this.contextualBeanRegistry != null) {
            this.contextualBeanRegistry.destroy();
            this.contextualBeanRegistry = null;
        }
        if (this.aspectRuleRegistry != null) {
            this.aspectRuleRegistry.destroy();
            this.aspectRuleRegistry = null;
        }
    }
}

