/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.builder.reload;

import com.aspectran.core.context.builder.reload.ActivityContextReloadingTimerTask;
import com.aspectran.core.service.ServiceController;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import java.net.URL;
import java.util.Enumeration;
import java.util.Timer;
import java.util.TimerTask;

public class ActivityContextReloadingTimer {
    private static final Log log = LogFactory.getLog(ActivityContextReloadingTimer.class);
    private final ServiceController serviceController;
    private Enumeration<URL> resources;
    private volatile Timer timer;
    private ActivityContextReloadingTimerTask timerTask;

    public ActivityContextReloadingTimer(ServiceController serviceController) {
        this.serviceController = serviceController;
    }

    public void setResources(Enumeration<URL> resources) {
        this.resources = resources;
        if (log.isDebugEnabled()) {
            log.debug("ActivityContextReloadingTimer is initialized");
        }
    }

    public void start(int scanIntervalSeconds) {
        this.stop();
        if (log.isDebugEnabled()) {
            log.debug("Starting ActivityContextReloadingTimer...");
        }
        this.timerTask = new ActivityContextReloadingTimerTask(this.serviceController);
        this.timerTask.setResources(this.resources);
        this.timer = new Timer("reloading@" + this.timerTask.hashCode());
        this.timer.schedule((TimerTask)this.timerTask, 0L, (long)scanIntervalSeconds * 1000L);
    }

    public void cancel() {
        this.stop();
    }

    protected void stop() {
        if (this.timer != null) {
            if (log.isDebugEnabled()) {
                log.debug("Stopping ActivityContextReloadingTimer...");
            }
            this.timer.cancel();
            this.timer = null;
            this.timerTask.cancel();
            this.timerTask = null;
        }
    }
}

