/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.builder.reload;

import com.aspectran.core.service.ServiceController;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;

public class ActivityContextReloadingTimerTask
extends TimerTask {
    private static final Log log = LogFactory.getLog(ActivityContextReloadingTimerTask.class);
    private final boolean debugEnabled = log.isDebugEnabled();
    private final ServiceController serviceController;
    private final Map<String, Long> modifiedTimeMap = new HashMap<String, Long>();
    private volatile boolean modified = false;

    public ActivityContextReloadingTimerTask(ServiceController serviceController) {
        this.serviceController = serviceController;
    }

    public void setResources(Enumeration<URL> resources) {
        if (resources != null) {
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                try {
                    File file;
                    if ("jar".equals(url.getProtocol())) {
                        URL fileUrl = new URL(url.getFile());
                        String[] parts = StringUtils.split(fileUrl.getFile(), "!/");
                        file = new File(parts[0]);
                    } else {
                        file = new File(url.getFile());
                    }
                    String filePath = file.getAbsolutePath();
                    this.modifiedTimeMap.put(filePath, file.lastModified());
                }
                catch (IOException e) {
                    log.error(e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public void run() {
        if (this.modifiedTimeMap.isEmpty()) {
            return;
        }
        if (this.modified) {
            if (!this.serviceController.isBusy()) {
                this.restartService();
            } else {
                return;
            }
        }
        for (Map.Entry<String, Long> entry : this.modifiedTimeMap.entrySet()) {
            File file;
            long lastModifiedTime;
            String filePath = entry.getKey();
            long prevLastModifiedTime = entry.getValue();
            if (prevLastModifiedTime == (lastModifiedTime = (file = new File(filePath)).lastModified())) continue;
            this.modified = true;
            this.modifiedTimeMap.put(filePath, lastModifiedTime);
            if (!this.debugEnabled) continue;
            log.debug("Detected modified file: " + filePath);
        }
        if (this.modified && !this.serviceController.isBusy()) {
            this.restartService();
        }
    }

    private void restartService() {
        try {
            String message = "Some resource file changes have been detected.";
            this.serviceController.restart(message);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.modified = false;
        }
    }
}

