/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.config;

import com.aspectran.core.context.config.ContextAutoReloadConfig;
import com.aspectran.core.context.config.ContextProfilesConfig;
import com.aspectran.core.context.rule.params.AspectranParameters;
import com.aspectran.core.util.apon.AbstractParameters;
import com.aspectran.core.util.apon.ParameterKey;
import com.aspectran.core.util.apon.ValueType;

public class ContextConfig
extends AbstractParameters {
    private static final ParameterKey base = new ParameterKey("base", ValueType.STRING);
    private static final ParameterKey root = new ParameterKey("root", ValueType.STRING);
    private static final ParameterKey encoding = new ParameterKey("encoding", ValueType.STRING);
    private static final ParameterKey resources = new ParameterKey("resources", ValueType.STRING, true);
    private static final ParameterKey scan = new ParameterKey("scan", ValueType.STRING, true);
    private static final ParameterKey profiles = new ParameterKey("profiles", ContextProfilesConfig.class);
    private static final ParameterKey autoReload = new ParameterKey("autoReload", ContextAutoReloadConfig.class);
    private static final ParameterKey singleton = new ParameterKey("singleton", ValueType.BOOLEAN);
    private static final ParameterKey parameters = new ParameterKey("parameters", AspectranParameters.class);
    private static final ParameterKey[] parameterKeys = new ParameterKey[]{base, root, encoding, resources, scan, profiles, autoReload, singleton, parameters};

    public ContextConfig() {
        super(parameterKeys);
    }

    public String getBasePath() {
        return this.getString(base);
    }

    public ContextConfig setBasePath(String basePath) {
        this.putValue(base, (Object)basePath);
        return this;
    }

    public String getRootFile() {
        return this.getString(root);
    }

    public ContextConfig setRootFile(String rootFile) {
        this.putValue(root, (Object)rootFile);
        return this;
    }

    public String getEncoding() {
        return this.getString(encoding);
    }

    public ContextConfig setEncoding(String encoding) {
        this.putValue(ContextConfig.encoding, (Object)encoding);
        return this;
    }

    public String[] getResourceLocations() {
        return this.getStringArray(resources);
    }

    public ContextConfig addResourceLocation(String resourceLocation) {
        this.putValue(resources, (Object)resourceLocation);
        return this;
    }

    public String[] getBasePackages() {
        return this.getStringArray(scan);
    }

    public ContextConfig addBasePackage(String basePackage) {
        this.putValue(scan, (Object)basePackage);
        return this;
    }

    public ContextProfilesConfig getProfilesConfig() {
        return (ContextProfilesConfig)this.getParameters(profiles);
    }

    public ContextProfilesConfig newProfilesConfig() {
        return (ContextProfilesConfig)this.newParameters(profiles);
    }

    public ContextProfilesConfig touchProfilesConfig() {
        return (ContextProfilesConfig)this.touchParameters(profiles);
    }

    public boolean hasProfilesConfig() {
        return this.hasValue(profiles);
    }

    public ContextAutoReloadConfig getAutoReloadConfig() {
        return (ContextAutoReloadConfig)this.getParameters(autoReload);
    }

    public ContextAutoReloadConfig newAutoReloadConfig() {
        return (ContextAutoReloadConfig)this.newParameters(autoReload);
    }

    public ContextAutoReloadConfig touchAutoReloadConfig() {
        return (ContextAutoReloadConfig)this.touchParameters(autoReload);
    }

    public boolean isSingleton() {
        return this.getBoolean(singleton, false);
    }

    public ContextConfig setSingleton(boolean singleton) {
        this.putValue(ContextConfig.singleton, (Object)singleton);
        return this;
    }

    public AspectranParameters getAspectranParameters() {
        return (AspectranParameters)this.getParameters(parameters);
    }

    public AspectranParameters newAspectranParameters() {
        return (AspectranParameters)this.newParameters(parameters);
    }

    public AspectranParameters touchAspectranParameters() {
        return (AspectranParameters)this.touchParameters(parameters);
    }

    public boolean hasAspectranParameters() {
        return this.hasValue(parameters);
    }
}

