/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.config;

import com.aspectran.core.util.apon.AbstractParameters;
import com.aspectran.core.util.apon.ParameterKey;
import com.aspectran.core.util.apon.ValueType;

public class DaemonPollerConfig
extends AbstractParameters {
    private static final ParameterKey pollingInterval = new ParameterKey("pollingInterval", ValueType.LONG);
    private static final ParameterKey maxThreads = new ParameterKey("maxThreads", ValueType.INT);
    private static final ParameterKey inbound = new ParameterKey("inbound", ValueType.STRING);
    private static final ParameterKey requeue = new ParameterKey("requeue", ValueType.BOOLEAN);
    private static final ParameterKey[] parameterKeys = new ParameterKey[]{pollingInterval, maxThreads, inbound, requeue};

    public DaemonPollerConfig() {
        super(parameterKeys);
    }

    public long getPollingInterval(long defaultPollingInterval) {
        return this.getLong(pollingInterval, defaultPollingInterval);
    }

    public DaemonPollerConfig setPollingInterval(long pollingInterval) {
        this.putValue(DaemonPollerConfig.pollingInterval, (Object)pollingInterval);
        return this;
    }

    public int getMaxThreads(int defaultMaxThreads) {
        return this.getInt(maxThreads, defaultMaxThreads);
    }

    public DaemonPollerConfig setMaxThreads(int maxThreads) {
        this.putValue(DaemonPollerConfig.maxThreads, (Object)maxThreads);
        return this;
    }

    public String getInboundPath() {
        return this.getString(inbound);
    }

    public String getInboundPath(String defaultInboundPath) {
        return this.getString(inbound, defaultInboundPath);
    }

    public DaemonPollerConfig setInboundPath(String inboundPath) {
        this.putValue(inbound, (Object)inboundPath);
        return this;
    }

    public boolean isRequeue() {
        return this.getBoolean(requeue, false);
    }

    public DaemonPollerConfig setRequeue(boolean requeue) {
        this.putValue(DaemonPollerConfig.requeue, (Object)requeue);
        return this;
    }
}

