/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.config;

import com.aspectran.core.context.config.SessionFileStoreConfig;
import com.aspectran.core.context.rule.type.SessionStoreType;
import com.aspectran.core.util.BooleanUtils;
import com.aspectran.core.util.apon.AbstractParameters;
import com.aspectran.core.util.apon.ParameterKey;
import com.aspectran.core.util.apon.ValueType;
import com.aspectran.core.util.apon.VariableParameters;
import java.io.IOException;

public class SessionManagerConfig
extends AbstractParameters {
    private static final ParameterKey workerName = new ParameterKey("workerName", ValueType.STRING);
    private static final ParameterKey maxSessions = new ParameterKey("maxSessions", ValueType.INT);
    private static final ParameterKey maxIdleSeconds = new ParameterKey("maxIdleSeconds", ValueType.INT);
    private static final ParameterKey evictionIdleSeconds = new ParameterKey("evictionIdleSeconds", ValueType.INT);
    private static final ParameterKey scavengingIntervalSeconds = new ParameterKey("scavengingIntervalSeconds", ValueType.INT);
    private static final ParameterKey saveOnCreate = new ParameterKey("saveOnCreate", ValueType.BOOLEAN);
    private static final ParameterKey saveOnInactiveEviction = new ParameterKey("saveOnInactiveEviction", ValueType.BOOLEAN);
    private static final ParameterKey removeUnloadableSessions = new ParameterKey("removeUnloadableSessions", ValueType.BOOLEAN);
    private static final ParameterKey nonPersistentAttributes = new ParameterKey("nonPersistentAttributes", ValueType.STRING, true);
    private static final ParameterKey storeType = new ParameterKey("storeType", ValueType.STRING);
    private static final ParameterKey fileStore = new ParameterKey("fileStore", SessionFileStoreConfig.class);
    private static final ParameterKey startup = new ParameterKey("startup", ValueType.BOOLEAN);
    private static final ParameterKey[] parameterKeys = new ParameterKey[]{workerName, maxSessions, maxIdleSeconds, evictionIdleSeconds, scavengingIntervalSeconds, saveOnCreate, saveOnInactiveEviction, removeUnloadableSessions, nonPersistentAttributes, storeType, fileStore, startup};

    public SessionManagerConfig() {
        super(parameterKeys);
    }

    public SessionManagerConfig(String apon) throws IOException {
        super(parameterKeys);
        this.readFrom(apon);
    }

    public SessionManagerConfig(VariableParameters parameters) throws IOException {
        this(parameters.toString());
    }

    public boolean isStartup() {
        return BooleanUtils.toBoolean(this.getBoolean(startup));
    }

    public SessionManagerConfig setStartup(boolean startup) {
        this.putValue(SessionManagerConfig.startup, (Object)startup);
        return this;
    }

    public String getWorkerName() {
        return this.getString(workerName);
    }

    public SessionManagerConfig setWorkerName(String workerName) {
        this.putValue(SessionManagerConfig.workerName, (Object)workerName);
        return this;
    }

    public boolean hasWorkerName() {
        return this.hasValue(workerName);
    }

    public int getMaxSessions() {
        return this.getInt(maxSessions, 0);
    }

    public SessionManagerConfig setMaxSessions(int maxSessions) {
        this.putValue(SessionManagerConfig.maxSessions, (Object)maxSessions);
        return this;
    }

    public boolean hasMaxSessions() {
        return this.hasValue(maxSessions);
    }

    public int getMaxIdleSeconds() {
        return this.getInt(maxIdleSeconds, -1);
    }

    public SessionManagerConfig setMaxIdleSeconds(int maxIdleSeconds) {
        this.putValue(SessionManagerConfig.maxIdleSeconds, (Object)maxIdleSeconds);
        return this;
    }

    public boolean hasMaxIdleSeconds() {
        return this.hasValue(maxIdleSeconds);
    }

    public int getEvictionIdleSeconds() {
        return this.getInt(evictionIdleSeconds, -1);
    }

    public SessionManagerConfig setEvictionIdleSeconds(int evictionIdleSeconds) {
        this.putValue(SessionManagerConfig.evictionIdleSeconds, (Object)evictionIdleSeconds);
        return this;
    }

    public boolean hasEvictionIdleSeconds() {
        return this.hasValue(evictionIdleSeconds);
    }

    public int getScavengingIntervalSeconds() {
        return this.getInt(scavengingIntervalSeconds, 0);
    }

    public SessionManagerConfig setScavengingIntervalSeconds(int scavengingIntervalSeconds) {
        this.putValue(SessionManagerConfig.scavengingIntervalSeconds, (Object)scavengingIntervalSeconds);
        return this;
    }

    public boolean hasScavengingIntervalSeconds() {
        return this.hasValue(scavengingIntervalSeconds);
    }

    public boolean getSaveOnCreate() {
        return this.getBoolean(saveOnCreate, false);
    }

    public SessionManagerConfig setSaveOnCreate(boolean saveOnCreate) {
        this.putValue(SessionManagerConfig.saveOnCreate, (Object)saveOnCreate);
        return this;
    }

    public boolean hasSaveOnCreate() {
        return this.hasValue(saveOnCreate);
    }

    public boolean getSaveOnInactiveEviction() {
        return this.getBoolean(saveOnInactiveEviction, false);
    }

    public SessionManagerConfig setSaveOnInactiveEviction(boolean saveOnInactiveEviction) {
        this.putValue(SessionManagerConfig.saveOnInactiveEviction, (Object)saveOnInactiveEviction);
        return this;
    }

    public boolean hasSaveOnInactiveEviction() {
        return this.hasValue(saveOnInactiveEviction);
    }

    public boolean getRemoveUnloadableSessions() {
        return this.getBoolean(removeUnloadableSessions, false);
    }

    public SessionManagerConfig setRemoveUnloadableSessions(boolean removeUnloadableSessions) {
        this.putValue(SessionManagerConfig.removeUnloadableSessions, (Object)removeUnloadableSessions);
        return this;
    }

    public boolean hasRemoveUnloadableSessions() {
        return this.hasValue(removeUnloadableSessions);
    }

    public String[] getNonPersistentAttributes() {
        return this.getStringArray(nonPersistentAttributes);
    }

    public SessionManagerConfig setNonPersistentAttributes(String[] nonPersistentAttributes) {
        this.putValue(SessionManagerConfig.nonPersistentAttributes, (Object)nonPersistentAttributes);
        return this;
    }

    public SessionManagerConfig addNonPersistentAttributes(String nonPersistentAttribute) {
        this.putValue(nonPersistentAttributes, (Object)nonPersistentAttribute);
        return this;
    }

    public boolean hasNonPersistentAttributes() {
        return this.hasValue(nonPersistentAttributes);
    }

    public String getStoreType() {
        return this.getString(storeType);
    }

    public SessionManagerConfig setStoreType(SessionStoreType sessionStoreType) {
        this.putValue(storeType, (Object)sessionStoreType.toString());
        return this;
    }

    public SessionFileStoreConfig getFileStoreConfig() {
        return (SessionFileStoreConfig)this.getParameters(fileStore);
    }

    public SessionFileStoreConfig newFileStoreConfig() {
        return (SessionFileStoreConfig)this.newParameters(fileStore);
    }

    public SessionFileStoreConfig touchFileStoreConfig() {
        return (SessionFileStoreConfig)this.touchParameters(fileStore);
    }
}

