/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.expr;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.request.FileParameter;
import com.aspectran.core.component.bean.NoSuchBeanException;
import com.aspectran.core.component.bean.NoUniqueBeanException;
import com.aspectran.core.component.template.TemplateRenderer;
import com.aspectran.core.context.expr.TokenEvaluationException;
import com.aspectran.core.context.expr.TokenEvaluator;
import com.aspectran.core.context.expr.token.Token;
import com.aspectran.core.context.rule.type.TokenDirectiveType;
import com.aspectran.core.context.rule.type.TokenType;
import com.aspectran.core.util.BeanUtils;
import com.aspectran.core.util.PropertiesLoaderUtils;
import com.aspectran.core.util.ReflectionUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class TokenExpression
implements TokenEvaluator {
    protected final Activity activity;

    public TokenExpression(Activity activity) {
        if (activity == null) {
            throw new IllegalArgumentException("activity must not be null");
        }
        this.activity = activity;
    }

    @Override
    public Object evaluate(Token token) {
        try {
            TokenType tokenType = token.getType();
            Object value = null;
            if (tokenType == TokenType.TEXT) {
                value = token.getDefaultValue();
            } else if (tokenType == TokenType.BEAN) {
                value = this.getBean(token);
            } else if (tokenType == TokenType.TEMPLATE) {
                value = this.getTemplate(token);
            } else if (tokenType == TokenType.PARAMETER) {
                value = this.getParameter(token.getName(), token.getDefaultValue());
            } else if (tokenType == TokenType.ATTRIBUTE) {
                value = this.getAttribute(token);
            } else if (tokenType == TokenType.PROPERTY) {
                value = this.getProperty(token);
            }
            return value;
        }
        catch (Exception e) {
            throw new TokenEvaluationException(token, (Throwable)e);
        }
    }

    @Override
    public Object evaluate(Token[] tokens) {
        if (tokens == null || tokens.length == 0) {
            return null;
        }
        if (tokens.length > 1) {
            StringBuilder sb = new StringBuilder();
            for (Token t : tokens) {
                Object value = this.evaluate(t);
                if (value == null) continue;
                sb.append(value.toString());
            }
            return sb.toString();
        }
        return this.evaluate(tokens[0]);
    }

    @Override
    public void evaluate(Token[] tokens, Writer writer) throws IOException {
        if (tokens == null || tokens.length == 0) {
            return;
        }
        for (Token t : tokens) {
            Object value = this.evaluate(t);
            if (value == null) continue;
            writer.write(value.toString());
        }
        writer.flush();
    }

    @Override
    public String evaluateAsString(Token[] tokens) {
        Object value = this.evaluate(tokens);
        return value != null ? value.toString() : null;
    }

    @Override
    public List<Object> evaluateAsList(List<Token[]> tokensList) {
        if (tokensList == null || tokensList.isEmpty()) {
            return null;
        }
        ArrayList<Object> valueList = new ArrayList<Object>(tokensList.size());
        for (Token[] tokens : tokensList) {
            Object value = this.evaluate(tokens);
            valueList.add(value);
        }
        return valueList;
    }

    @Override
    public Set<Object> evaluateAsSet(Set<Token[]> tokensSet) {
        if (tokensSet == null || tokensSet.isEmpty()) {
            return null;
        }
        HashSet<Object> valueSet = new HashSet<Object>();
        for (Token[] tokens : tokensSet) {
            Object value = this.evaluate(tokens);
            valueSet.add(value);
        }
        return valueSet;
    }

    @Override
    public Map<String, Object> evaluateAsMap(Map<String, Token[]> tokensMap) {
        if (tokensMap == null || tokensMap.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, Object> valueMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Token[]> entry : tokensMap.entrySet()) {
            Object value = this.evaluate(entry.getValue());
            valueMap.put(entry.getKey(), value);
        }
        return valueMap;
    }

    @Override
    public Properties evaluateAsProperties(Properties tokensProp) {
        if (tokensProp == null || tokensProp.isEmpty()) {
            return null;
        }
        Properties prop = new Properties();
        for (Map.Entry<Object, Object> entry : tokensProp.entrySet()) {
            Object value = this.evaluate((Token[])entry.getValue());
            prop.put(entry.getKey(), value);
        }
        return prop;
    }

    private String getParameter(String name, String defaultValue) {
        String value = this.getParameter(name);
        return value != null ? value : defaultValue;
    }

    protected String getParameter(String name) {
        if (this.activity.getRequestAdapter() != null) {
            return this.activity.getRequestAdapter().getParameter(name);
        }
        return null;
    }

    protected String[] getParameterValues(String name) {
        if (this.activity.getRequestAdapter() != null) {
            return this.activity.getRequestAdapter().getParameterValues(name);
        }
        return null;
    }

    protected FileParameter getFileParameter(String name) {
        if (this.activity.getRequestAdapter() != null) {
            return this.activity.getRequestAdapter().getFileParameter(name);
        }
        return null;
    }

    protected FileParameter[] getFileParameterValues(String name) {
        if (this.activity.getRequestAdapter() != null) {
            return this.activity.getRequestAdapter().getFileParameterValues(name);
        }
        return null;
    }

    protected Object getAttribute(Token token) {
        Object object = null;
        if (this.activity.getProcessResult() != null) {
            object = this.activity.getProcessResult().getResultValue(token.getName());
        }
        if (object == null && this.activity.getRequestAdapter() != null) {
            object = this.activity.getRequestAdapter().getAttribute(token.getName());
        }
        if (object != null && token.getGetterName() != null) {
            object = this.getBeanProperty(object, token.getGetterName());
        }
        return object != null ? object : token.getDefaultValue();
    }

    protected Object getBean(Token token) {
        Object value;
        if (token.getAlternativeValue() != null) {
            if (token.getDirectiveType() == TokenDirectiveType.FIELD) {
                Field field = (Field)token.getAlternativeValue();
                if (Modifier.isStatic(field.getModifiers())) {
                    value = ReflectionUtils.getField(field, null);
                } else {
                    Class<?> cls = field.getDeclaringClass();
                    Object target = this.activity.getBean(cls);
                    value = ReflectionUtils.getField(field, target);
                }
            } else if (token.getDirectiveType() == TokenDirectiveType.METHOD) {
                Method method = (Method)token.getAlternativeValue();
                if (Modifier.isStatic(method.getModifiers())) {
                    value = ReflectionUtils.invokeMethod(method, null, new Object[0]);
                } else {
                    Class<?> cls = method.getDeclaringClass();
                    Object target = this.activity.getBean(cls);
                    value = ReflectionUtils.invokeMethod(method, target, new Object[0]);
                }
            } else {
                Class cls = (Class)token.getAlternativeValue();
                try {
                    value = this.activity.getBean(cls);
                }
                catch (NoSuchBeanException | NoUniqueBeanException e) {
                    if (token.getGetterName() != null) {
                        try {
                            Object value2 = BeanUtils.getProperty(cls, token.getGetterName());
                            if (value2 == null) {
                                value2 = token.getDefaultValue();
                            }
                            return value2;
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            // empty catch block
                        }
                    }
                    throw e;
                }
                if (value != null && token.getGetterName() != null) {
                    value = this.getBeanProperty(value, token.getGetterName());
                }
            }
        } else {
            value = this.activity.getBean(token.getName());
            if (value != null && token.getGetterName() != null) {
                value = this.getBeanProperty(value, token.getGetterName());
            }
        }
        if (value == null) {
            value = token.getDefaultValue();
        }
        return value;
    }

    protected Object getBeanProperty(Object bean, String propertyName) {
        Object value;
        try {
            value = BeanUtils.getProperty(bean, propertyName);
        }
        catch (InvocationTargetException e) {
            value = null;
        }
        return value;
    }

    protected Object getProperty(Token token) throws IOException {
        if (token.getDirectiveType() == TokenDirectiveType.CLASSPATH) {
            Properties props = PropertiesLoaderUtils.loadProperties(token.getValue(), this.activity.getActivityContext().getApplicationAdapter().getClassLoader());
            Properties value = token.getGetterName() != null ? props.get(token.getGetterName()) : props;
            return value != null ? value : token.getDefaultValue();
        }
        Object value = this.activity.getActivityContext().getEnvironment().getProperty(token.getName(), this.activity);
        if (value != null && token.getGetterName() != null) {
            value = this.getBeanProperty(value, token.getGetterName());
        }
        return value != null ? value : token.getDefaultValue();
    }

    protected String getTemplate(Token token) {
        TemplateRenderer templateRenderer = this.activity.getActivityContext().getTemplateRenderer();
        StringWriter writer = new StringWriter();
        templateRenderer.render(token.getName(), this.activity, writer);
        String result = writer.toString();
        return result != null ? result : token.getDefaultValue();
    }
}

