/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.activity.process.ActionList;
import com.aspectran.core.activity.process.ContentList;
import com.aspectran.core.activity.process.action.Executable;
import com.aspectran.core.activity.response.Response;
import com.aspectran.core.activity.response.dispatch.DispatchResponse;
import com.aspectran.core.component.aspect.AspectAdviceRuleRegistry;
import com.aspectran.core.context.expr.token.Token;
import com.aspectran.core.context.rule.AnnotatedActionRule;
import com.aspectran.core.context.rule.ChooseRule;
import com.aspectran.core.context.rule.DispatchRule;
import com.aspectran.core.context.rule.EchoActionRule;
import com.aspectran.core.context.rule.ExceptionRule;
import com.aspectran.core.context.rule.ForwardRule;
import com.aspectran.core.context.rule.HeaderActionRule;
import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.IncludeActionRule;
import com.aspectran.core.context.rule.InvokeActionRule;
import com.aspectran.core.context.rule.RedirectRule;
import com.aspectran.core.context.rule.RequestRule;
import com.aspectran.core.context.rule.ResponseRule;
import com.aspectran.core.context.rule.TransformRule;
import com.aspectran.core.context.rule.ability.ActionRuleApplicable;
import com.aspectran.core.context.rule.ability.Replicable;
import com.aspectran.core.context.rule.ability.ResponseRuleApplicable;
import com.aspectran.core.context.rule.params.FilterParameters;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.util.PrefixSuffixPattern;
import com.aspectran.core.util.ToStringBuilder;
import com.aspectran.core.util.wildcard.WildcardPattern;
import java.util.ArrayList;
import java.util.List;

public class TransletRule
implements ActionRuleApplicable,
ResponseRuleApplicable,
Replicable<TransletRule> {
    private String name;
    private MethodType[] allowedMethods;
    private WildcardPattern namePattern;
    private Token[] nameTokens;
    private String scanPath;
    private String maskPattern;
    private FilterParameters filterParameters;
    private RequestRule requestRule;
    private ContentList contentList;
    private ResponseRule responseRule;
    private List<ResponseRule> responseRuleList;
    private ExceptionRule exceptionRule;
    private AspectAdviceRuleRegistry aspectAdviceRuleRegistry;
    private String description;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MethodType[] getAllowedMethods() {
        return this.allowedMethods;
    }

    public void setAllowedMethods(MethodType[] allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    public WildcardPattern getNamePattern() {
        return this.namePattern;
    }

    public void setNamePattern(WildcardPattern namePattern) {
        this.namePattern = namePattern;
    }

    public Token[] getNameTokens() {
        return this.nameTokens;
    }

    public void setNameTokens(Token[] nameTokens) {
        this.nameTokens = nameTokens;
    }

    public String getScanPath() {
        return this.scanPath;
    }

    public void setScanPath(String scanPath) {
        this.scanPath = scanPath;
    }

    public String getMaskPattern() {
        return this.maskPattern;
    }

    public void setMaskPattern(String maskPattern) {
        this.maskPattern = maskPattern;
    }

    public FilterParameters getFilterParameters() {
        return this.filterParameters;
    }

    public void setFilterParameters(FilterParameters filterParameters) {
        this.filterParameters = filterParameters;
    }

    public RequestRule getRequestRule() {
        return this.requestRule;
    }

    public void setRequestRule(RequestRule requestRule) {
        this.requestRule = requestRule;
    }

    public RequestRule touchRequestRule(boolean explicit) {
        if (this.requestRule != null) {
            return this.requestRule;
        }
        this.requestRule = RequestRule.newInstance(explicit);
        return this.requestRule;
    }

    public ContentList getContentList() {
        return this.contentList;
    }

    public void setContentList(ContentList contentList) {
        this.contentList = contentList;
    }

    public boolean hasPathVariables() {
        return this.nameTokens != null;
    }

    @Override
    public Executable applyActionRule(HeaderActionRule headerActionRule) {
        return this.touchActionList().applyActionRule(headerActionRule);
    }

    @Override
    public Executable applyActionRule(EchoActionRule echoActionRule) {
        return this.touchActionList().applyActionRule(echoActionRule);
    }

    @Override
    public Executable applyActionRule(InvokeActionRule invokeActionRule) {
        return this.touchActionList().applyActionRule(invokeActionRule);
    }

    @Override
    public Executable applyActionRule(AnnotatedActionRule annotatedActionRule) {
        return this.touchActionList().applyActionRule(annotatedActionRule);
    }

    @Override
    public Executable applyActionRule(IncludeActionRule includeActionRule) {
        return this.touchActionList().applyActionRule(includeActionRule);
    }

    @Override
    public Executable applyActionRule(ChooseRule chooseRule) {
        return this.touchActionList().applyActionRule(chooseRule);
    }

    @Override
    public void applyActionRule(Executable action) {
        this.touchActionList().applyActionRule(action);
    }

    private ActionList touchActionList() {
        ActionList actionList;
        if (this.contentList != null) {
            if (this.contentList.isExplicit() || this.contentList.size() != 1) {
                this.contentList = null;
            } else {
                actionList = (ActionList)this.contentList.get(0);
                if (actionList.isExplicit()) {
                    this.contentList = null;
                }
            }
        }
        if (this.contentList == null) {
            this.contentList = new ContentList(false);
            actionList = new ActionList(false);
            this.contentList.add(actionList);
        } else {
            actionList = (ActionList)this.contentList.get(0);
        }
        return actionList;
    }

    public ResponseRule getResponseRule() {
        return this.responseRule;
    }

    public void setResponseRule(ResponseRule responseRule) {
        this.responseRule = responseRule;
    }

    public List<ResponseRule> getResponseRuleList() {
        return this.responseRuleList;
    }

    public void setResponseRuleList(List<ResponseRule> responseRuleList) {
        this.responseRuleList = responseRuleList;
    }

    public void addResponseRule(ResponseRule responseRule) {
        if (this.responseRuleList == null) {
            this.responseRuleList = new ArrayList<ResponseRule>();
        }
        this.responseRuleList.add(responseRule);
    }

    @Override
    public Response applyResponseRule(TransformRule transformRule) {
        if (this.responseRule == null) {
            this.responseRule = new ResponseRule(false);
        }
        return this.responseRule.applyResponseRule(transformRule);
    }

    @Override
    public Response applyResponseRule(DispatchRule dispatchRule) {
        if (this.responseRule == null) {
            this.responseRule = new ResponseRule(false);
        }
        return this.responseRule.applyResponseRule(dispatchRule);
    }

    @Override
    public Response applyResponseRule(ForwardRule forwardRule) {
        if (this.responseRule == null) {
            this.responseRule = new ResponseRule(false);
        }
        return this.responseRule.applyResponseRule(forwardRule);
    }

    @Override
    public Response applyResponseRule(RedirectRule redirectRule) {
        if (this.responseRule == null) {
            this.responseRule = new ResponseRule(false);
        }
        return this.responseRule.applyResponseRule(redirectRule);
    }

    public void determineResponseRule() {
        if (this.responseRule == null) {
            this.responseRule = new ResponseRule(false);
        } else {
            String responseName = this.responseRule.getName();
            if (responseName != null && !responseName.isEmpty()) {
                this.setName(this.name + responseName);
            }
        }
        this.setResponseRuleList(null);
    }

    public ExceptionRule getExceptionRule() {
        return this.exceptionRule;
    }

    public void setExceptionRule(ExceptionRule exceptionRule) {
        this.exceptionRule = exceptionRule;
    }

    public AspectAdviceRuleRegistry getAspectAdviceRuleRegistry() {
        return this.aspectAdviceRuleRegistry;
    }

    public void setAspectAdviceRuleRegistry(AspectAdviceRuleRegistry aspectAdviceRuleRegistry) {
        this.aspectAdviceRuleRegistry = aspectAdviceRuleRegistry;
    }

    public AspectAdviceRuleRegistry touchAspectAdviceRuleRegistry() {
        if (this.aspectAdviceRuleRegistry == null) {
            this.aspectAdviceRuleRegistry = new AspectAdviceRuleRegistry();
        }
        return this.aspectAdviceRuleRegistry;
    }

    public AspectAdviceRuleRegistry replicateAspectAdviceRuleRegistry() {
        return this.aspectAdviceRuleRegistry != null ? this.aspectAdviceRuleRegistry.replicate() : null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public TransletRule replicate() {
        return TransletRule.replicate(this);
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("name", this.name);
        tsb.append("method", this.allowedMethods);
        tsb.append("namePattern", this.namePattern);
        if (this.requestRule != null && (this.requestRule.getAllowedMethod() != null || this.requestRule.getEncoding() != null || this.requestRule.getParameterItemRuleMap() != null || this.requestRule.getAttributeItemRuleMap() != null)) {
            tsb.append("requestRule", this.requestRule);
        }
        if (this.responseRule != null && (this.responseRule.getEncoding() != null || this.responseRule.getResponse() != null)) {
            tsb.append("responseRule", this.responseRule);
        }
        tsb.append("exceptionRule", this.exceptionRule);
        return tsb.toString();
    }

    public static TransletRule newInstance(String name, String scanPath, String maskPattern, String method) throws IllegalRuleException {
        if (name == null && scanPath == null) {
            throw new IllegalRuleException("The 'translet' element requires a 'name' attribute");
        }
        MethodType[] allowedMethods = null;
        if (method != null && (allowedMethods = MethodType.parse(method)) == null) {
            throw new IllegalRuleException("No request method type for '" + method + "'");
        }
        return TransletRule.newInstance(name, scanPath, maskPattern, allowedMethods);
    }

    public static TransletRule newInstance(String name, String scanPath, String maskPattern, MethodType[] allowedMethods) {
        TransletRule transletRule = new TransletRule();
        transletRule.setName(name);
        if (allowedMethods != null && allowedMethods.length > 0) {
            transletRule.setAllowedMethods(allowedMethods);
        } else {
            transletRule.setScanPath(scanPath);
            transletRule.setMaskPattern(maskPattern);
        }
        return transletRule;
    }

    public static TransletRule newInstance(String name, String method) throws IllegalRuleException {
        return TransletRule.newInstance(name, null, null, method);
    }

    public static TransletRule newInstance(String name, MethodType[] allowedMethods) {
        return TransletRule.newInstance(name, null, null, allowedMethods);
    }

    public static TransletRule replicate(TransletRule transletRule) {
        TransletRule tr = new TransletRule();
        tr.setName(transletRule.getName());
        tr.setAllowedMethods(transletRule.getAllowedMethods());
        tr.setRequestRule(transletRule.getRequestRule());
        if (transletRule.getContentList() != null) {
            ContentList contentList = transletRule.getContentList().replicate();
            tr.setContentList(contentList);
        }
        tr.setResponseRule(transletRule.getResponseRule());
        tr.setExceptionRule(transletRule.getExceptionRule());
        tr.setDescription(transletRule.getDescription());
        return tr;
    }

    public static TransletRule replicate(TransletRule transletRule, String newDispatchName) {
        TransletRule tr = new TransletRule();
        tr.setName(transletRule.getName());
        tr.setAllowedMethods(transletRule.getAllowedMethods());
        tr.setRequestRule(transletRule.getRequestRule());
        tr.setExceptionRule(transletRule.getExceptionRule());
        tr.setDescription(transletRule.getDescription());
        if (transletRule.getResponseRule() != null) {
            ResponseRule responseRule = transletRule.getResponseRule();
            ResponseRule rr = TransletRule.replicate(responseRule, newDispatchName);
            tr.setResponseRule(rr);
        }
        if (transletRule.getResponseRuleList() != null) {
            List<ResponseRule> responseRuleList = transletRule.getResponseRuleList();
            ArrayList<ResponseRule> newResponseRuleList = new ArrayList<ResponseRule>(responseRuleList.size());
            for (ResponseRule responseRule : responseRuleList) {
                ResponseRule rr = TransletRule.replicate(responseRule, newDispatchName);
                newResponseRuleList.add(rr);
            }
            tr.setResponseRuleList(newResponseRuleList);
        }
        return tr;
    }

    private static ResponseRule replicate(ResponseRule responseRule, String newDispatchName) {
        ResponseRule rr = responseRule.replicate();
        if (rr.getResponse() != null && rr.getResponse() instanceof DispatchResponse) {
            DispatchResponse dispatchResponse = (DispatchResponse)rr.getResponse();
            DispatchRule dispatchRule = dispatchResponse.getDispatchRule();
            String dispatchName = dispatchRule.getName();
            PrefixSuffixPattern prefixSuffixPattern = new PrefixSuffixPattern(dispatchName);
            if (prefixSuffixPattern.isSplitted()) {
                dispatchRule.setName(prefixSuffixPattern.join(newDispatchName));
            } else if (dispatchName != null) {
                dispatchRule.setName(dispatchName + newDispatchName);
            } else {
                dispatchRule.setName(newDispatchName);
            }
        }
        return rr;
    }
}

