/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.assistant;

import com.aspectran.core.context.rule.ability.Replicable;
import com.aspectran.core.context.rule.assistant.ContextRuleAssistant;
import com.aspectran.core.context.rule.assistant.DefaultSettings;

public class AssistantLocal
implements Replicable<AssistantLocal> {
    private final ContextRuleAssistant assistant;
    private String description;
    private DefaultSettings defaultSettings;
    private final int replicatedCount;

    public AssistantLocal(ContextRuleAssistant assistant) {
        this(assistant, 0);
    }

    private AssistantLocal(ContextRuleAssistant assistant, int replicatedCount) {
        this.assistant = assistant;
        this.replicatedCount = replicatedCount;
    }

    public ContextRuleAssistant getAssistant() {
        return this.assistant;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public DefaultSettings getDefaultSettings() {
        return this.defaultSettings;
    }

    public DefaultSettings touchDefaultSettings() {
        if (this.defaultSettings == null) {
            this.defaultSettings = new DefaultSettings();
        }
        return this.defaultSettings;
    }

    public void setDefaultSettings(DefaultSettings defaultSettings) {
        this.defaultSettings = defaultSettings;
    }

    public int getReplicatedCount() {
        return this.replicatedCount;
    }

    @Override
    public AssistantLocal replicate() {
        AssistantLocal al = new AssistantLocal(this.assistant, this.replicatedCount + 1);
        al.setDescription(this.getDescription());
        DefaultSettings ds = this.getDefaultSettings();
        if (ds != null) {
            al.setDefaultSettings(new DefaultSettings(ds));
        }
        return al;
    }
}

