/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.converter;

import com.aspectran.core.activity.process.ActionList;
import com.aspectran.core.activity.process.ContentList;
import com.aspectran.core.context.rule.AppendRule;
import com.aspectran.core.context.rule.AspectAdviceRule;
import com.aspectran.core.context.rule.AspectRule;
import com.aspectran.core.context.rule.BeanRule;
import com.aspectran.core.context.rule.ChooseRule;
import com.aspectran.core.context.rule.ChooseWhenRule;
import com.aspectran.core.context.rule.DispatchRule;
import com.aspectran.core.context.rule.EchoActionRule;
import com.aspectran.core.context.rule.EnvironmentRule;
import com.aspectran.core.context.rule.ExceptionRule;
import com.aspectran.core.context.rule.ExceptionThrownRule;
import com.aspectran.core.context.rule.ForwardRule;
import com.aspectran.core.context.rule.HeaderActionRule;
import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.IncludeActionRule;
import com.aspectran.core.context.rule.InvokeActionRule;
import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.RedirectRule;
import com.aspectran.core.context.rule.RequestRule;
import com.aspectran.core.context.rule.ResponseRule;
import com.aspectran.core.context.rule.ScheduleRule;
import com.aspectran.core.context.rule.ScheduledJobRule;
import com.aspectran.core.context.rule.SettingsAdviceRule;
import com.aspectran.core.context.rule.TemplateRule;
import com.aspectran.core.context.rule.TransformRule;
import com.aspectran.core.context.rule.TransletRule;
import com.aspectran.core.context.rule.ability.ActionRuleApplicable;
import com.aspectran.core.context.rule.ability.ResponseRuleApplicable;
import com.aspectran.core.context.rule.appender.RuleAppendHandler;
import com.aspectran.core.context.rule.assistant.ContextRuleAssistant;
import com.aspectran.core.context.rule.params.ActionParameters;
import com.aspectran.core.context.rule.params.AdviceActionParameters;
import com.aspectran.core.context.rule.params.AdviceParameters;
import com.aspectran.core.context.rule.params.AppendParameters;
import com.aspectran.core.context.rule.params.AspectParameters;
import com.aspectran.core.context.rule.params.AspectranParameters;
import com.aspectran.core.context.rule.params.BeanParameters;
import com.aspectran.core.context.rule.params.ChooseWhenParameters;
import com.aspectran.core.context.rule.params.ContentParameters;
import com.aspectran.core.context.rule.params.ContentsParameters;
import com.aspectran.core.context.rule.params.DispatchParameters;
import com.aspectran.core.context.rule.params.EntryParameters;
import com.aspectran.core.context.rule.params.EnvironmentParameters;
import com.aspectran.core.context.rule.params.ExceptionParameters;
import com.aspectran.core.context.rule.params.ExceptionThrownParameters;
import com.aspectran.core.context.rule.params.FilterParameters;
import com.aspectran.core.context.rule.params.ForwardParameters;
import com.aspectran.core.context.rule.params.ItemHolderParameters;
import com.aspectran.core.context.rule.params.ItemParameters;
import com.aspectran.core.context.rule.params.JoinpointParameters;
import com.aspectran.core.context.rule.params.RedirectParameters;
import com.aspectran.core.context.rule.params.RequestParameters;
import com.aspectran.core.context.rule.params.ResponseParameters;
import com.aspectran.core.context.rule.params.RootParameters;
import com.aspectran.core.context.rule.params.ScheduleParameters;
import com.aspectran.core.context.rule.params.ScheduledJobParameters;
import com.aspectran.core.context.rule.params.SchedulerParameters;
import com.aspectran.core.context.rule.params.SettingParameters;
import com.aspectran.core.context.rule.params.SettingsParameters;
import com.aspectran.core.context.rule.params.TemplateParameters;
import com.aspectran.core.context.rule.params.TransformParameters;
import com.aspectran.core.context.rule.params.TransletParameters;
import com.aspectran.core.context.rule.params.TriggerParameters;
import com.aspectran.core.context.rule.params.TypeAliasParameters;
import com.aspectran.core.context.rule.params.TypeAliasesParameters;
import com.aspectran.core.context.rule.type.AspectAdviceType;
import com.aspectran.core.context.rule.type.ItemValueType;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.TextStyler;
import com.aspectran.core.util.apon.Parameter;
import com.aspectran.core.util.apon.Parameters;
import java.util.List;

public class ParametersToRules {
    private final ContextRuleAssistant assistant;

    public ParametersToRules(ContextRuleAssistant assistant) {
        this.assistant = assistant;
    }

    public void asRules(RootParameters rootParameters) throws IllegalRuleException {
        if (rootParameters == null) {
            throw new IllegalArgumentException("rootParameters must not be null");
        }
        AspectranParameters aspectranParameters = (AspectranParameters)rootParameters.getParameters(RootParameters.aspectran);
        this.asRules(aspectranParameters);
    }

    public void asRules(AspectranParameters aspectranParameters) throws IllegalRuleException {
        List appendParametersList;
        List templateParametersList;
        List transletParametersList;
        List scheduleParametersList;
        List beanParametersList;
        List aspectParametersList;
        List environmentParametersList;
        TypeAliasesParameters typeAliasesParameters;
        SettingsParameters settingsParameters;
        if (aspectranParameters == null) {
            throw new IllegalArgumentException("aspectranParameters must not be null");
        }
        String description = this.asDescription(aspectranParameters);
        if (description != null) {
            this.assistant.getAssistantLocal().setDescription(description);
        }
        if ((settingsParameters = (SettingsParameters)aspectranParameters.getParameters(AspectranParameters.settings)) != null) {
            this.asDefaultSettings(settingsParameters);
        }
        if ((typeAliasesParameters = (TypeAliasesParameters)aspectranParameters.getParameters(AspectranParameters.typeAliases)) != null) {
            this.asTypeAliasesRule(typeAliasesParameters);
        }
        if ((environmentParametersList = aspectranParameters.getParametersList(AspectranParameters.environment)) != null) {
            for (Object environmentParameters : environmentParametersList) {
                this.asEnvironmentRule((EnvironmentParameters)environmentParameters);
            }
        }
        if ((aspectParametersList = aspectranParameters.getParametersList(AspectranParameters.aspect)) != null) {
            for (Object aspectParameters : aspectParametersList) {
                this.asAspectRule((AspectParameters)aspectParameters);
            }
        }
        if ((beanParametersList = aspectranParameters.getParametersList(AspectranParameters.bean)) != null) {
            for (Object beanParameters : beanParametersList) {
                this.asBeanRule((BeanParameters)beanParameters);
            }
        }
        if ((scheduleParametersList = aspectranParameters.getParametersList(AspectranParameters.schedule)) != null) {
            for (Object scheduleParameters : scheduleParametersList) {
                this.asScheduleRule((ScheduleParameters)scheduleParameters);
            }
        }
        if ((transletParametersList = aspectranParameters.getParametersList(AspectranParameters.translet)) != null) {
            for (Object transletParameters : transletParametersList) {
                this.asTransletRule((TransletParameters)transletParameters);
            }
        }
        if ((templateParametersList = aspectranParameters.getParametersList(AspectranParameters.template)) != null) {
            for (TemplateParameters templateParameters : templateParametersList) {
                this.asTemplateRule(templateParameters);
            }
        }
        if ((appendParametersList = aspectranParameters.getParametersList(AspectranParameters.append)) != null) {
            for (AppendParameters appendParameters : appendParametersList) {
                this.asAppendRule(appendParameters);
            }
        }
    }

    private String asDescription(Parameters parameters) {
        Object value;
        Parameter parameter = parameters.getParameter("description");
        if (parameter != null && (value = parameter.getValue()) instanceof Parameters) {
            String text = ((Parameters)value).getString("description");
            String style = ((Parameters)value).getString("style");
            return TextStyler.styling(text, style);
        }
        return null;
    }

    private void asAppendRule(AppendParameters appendParameters) throws IllegalRuleException {
        RuleAppendHandler appendHandler = this.assistant.getRuleAppendHandler();
        if (appendHandler != null) {
            AspectranParameters aspectran = (AspectranParameters)appendParameters.getParameters(AppendParameters.aspectran);
            String profile = appendParameters.getString(AppendParameters.profile);
            if (aspectran != null) {
                AppendRule appendRule = AppendRule.newInstance(aspectran, profile);
                appendHandler.pending(appendRule);
            } else {
                String file = appendParameters.getString(AppendParameters.file);
                String resource = appendParameters.getString(AppendParameters.resource);
                String url = appendParameters.getString(AppendParameters.url);
                String format = appendParameters.getString(AppendParameters.format);
                AppendRule appendRule = AppendRule.newInstance(file, resource, url, format, profile);
                appendHandler.pending(appendRule);
            }
        }
    }

    private void asDefaultSettings(SettingsParameters settingsParameters) throws IllegalRuleException {
        List settingParametersList;
        if (settingsParameters != null && (settingParametersList = settingsParameters.getParametersList(SettingsParameters.setting)) != null) {
            for (SettingParameters settingParameters : settingParametersList) {
                this.assistant.putSetting(settingParameters.getName(), settingParameters.getValueAsString());
            }
            this.assistant.applySettings();
        }
    }

    private void asTypeAliasesRule(TypeAliasesParameters typeAliasesParameters) {
        List typeAliasParametersList;
        if (typeAliasesParameters != null && (typeAliasParametersList = typeAliasesParameters.getParametersList(TypeAliasesParameters.typeAlias)) != null) {
            for (TypeAliasParameters typeAliasParameters : typeAliasParametersList) {
                String alias = typeAliasParameters.getString(TypeAliasParameters.alias);
                String type = typeAliasParameters.getString(TypeAliasParameters.type);
                this.assistant.addTypeAlias(alias, type);
            }
        }
    }

    private void asEnvironmentRule(EnvironmentParameters environmentParameters) throws IllegalRuleException {
        if (environmentParameters != null) {
            List propertyItemHolderParametersList;
            String description = this.asDescription(environmentParameters);
            String profile = StringUtils.emptyToNull(environmentParameters.getString(EnvironmentParameters.profile));
            EnvironmentRule environmentRule = EnvironmentRule.newInstance(profile);
            if (description != null) {
                environmentRule.setDescription(description);
            }
            if ((propertyItemHolderParametersList = environmentParameters.getParametersList(EnvironmentParameters.properties)) != null) {
                for (ItemHolderParameters itemHolderParameters : propertyItemHolderParametersList) {
                    ItemRuleMap propertyItemRuleMap = this.asItemRuleMap(itemHolderParameters);
                    environmentRule.addPropertyItemRuleMap(propertyItemRuleMap);
                }
            }
            this.assistant.addEnvironmentRule(environmentRule);
        }
    }

    private void asAspectRule(AspectParameters aspectParameters) throws IllegalRuleException {
        ExceptionParameters exceptionParameters;
        AdviceParameters adviceParameters;
        SettingsParameters settingsParameters;
        JoinpointParameters joinpointParameters;
        String description = this.asDescription(aspectParameters);
        String id = StringUtils.emptyToNull(aspectParameters.getString(AspectParameters.id));
        String order = aspectParameters.getString(AspectParameters.order);
        Boolean isolated = aspectParameters.getBoolean(AspectParameters.isolated);
        Boolean disabled = aspectParameters.getBoolean(AspectParameters.disabled);
        AspectRule aspectRule = AspectRule.newInstance(id, order, isolated, disabled);
        if (description != null) {
            aspectRule.setDescription(description);
        }
        if ((joinpointParameters = (JoinpointParameters)aspectParameters.getParameters(AspectParameters.joinpoint)) != null) {
            AspectRule.updateJoinpoint(aspectRule, joinpointParameters);
        }
        if ((settingsParameters = (SettingsParameters)aspectParameters.getParameters(AspectParameters.settings)) != null) {
            SettingsAdviceRule settingsAdviceRule = SettingsAdviceRule.newInstance(aspectRule, settingsParameters);
            aspectRule.setSettingsAdviceRule(settingsAdviceRule);
        }
        if ((adviceParameters = (AdviceParameters)aspectParameters.getParameters(AspectParameters.advice)) != null) {
            AdviceActionParameters finallyAdviceParameters;
            AspectAdviceRule aspectAdviceRule;
            ActionParameters actionParameters;
            AdviceActionParameters aroundAdviceParameters;
            ActionParameters actionParameters2;
            AdviceActionParameters afterAdviceParameters;
            ActionParameters actionParameters3;
            AdviceActionParameters beforeAdviceParameters;
            String adviceBeanId = adviceParameters.getString(AdviceParameters.bean);
            if (!StringUtils.isEmpty(adviceBeanId)) {
                aspectRule.setAdviceBeanId(adviceBeanId);
            }
            if ((beforeAdviceParameters = (AdviceActionParameters)adviceParameters.getParameters(AdviceParameters.beforeAdvice)) != null && (actionParameters3 = (ActionParameters)beforeAdviceParameters.getParameters(AdviceActionParameters.action)) != null) {
                AspectAdviceRule aspectAdviceRule2 = aspectRule.newAspectAdviceRule(AspectAdviceType.BEFORE);
                this.asActionRule(actionParameters3, aspectAdviceRule2);
            }
            if ((afterAdviceParameters = (AdviceActionParameters)adviceParameters.getParameters(AdviceParameters.afterAdvice)) != null && (actionParameters2 = (ActionParameters)afterAdviceParameters.getParameters(AdviceActionParameters.action)) != null) {
                AspectAdviceRule aspectAdviceRule3 = aspectRule.newAspectAdviceRule(AspectAdviceType.AFTER);
                this.asActionRule(actionParameters2, aspectAdviceRule3);
            }
            if ((aroundAdviceParameters = (AdviceActionParameters)adviceParameters.getParameters(AdviceParameters.aroundAdvice)) != null && (actionParameters = (ActionParameters)aroundAdviceParameters.getParameters(AdviceActionParameters.action)) != null) {
                aspectAdviceRule = aspectRule.newAspectAdviceRule(AspectAdviceType.AROUND);
                this.asActionRule(actionParameters, aspectAdviceRule);
            }
            if ((finallyAdviceParameters = (AdviceActionParameters)adviceParameters.getParameters(AdviceParameters.finallyAdvice)) != null) {
                ExceptionThrownParameters etParameters;
                aspectAdviceRule = aspectRule.newAspectAdviceRule(AspectAdviceType.FINALLY);
                ActionParameters actionParameters4 = (ActionParameters)finallyAdviceParameters.getParameters(AdviceActionParameters.action);
                if (actionParameters4 != null) {
                    this.asActionRule(actionParameters4, aspectAdviceRule);
                }
                if ((etParameters = (ExceptionThrownParameters)finallyAdviceParameters.getParameters(AdviceActionParameters.thrown)) != null) {
                    ExceptionThrownRule etr = this.asExceptionThrownRule(etParameters, aspectAdviceRule);
                    aspectAdviceRule.setExceptionThrownRule(etr);
                }
            }
        }
        if ((exceptionParameters = (ExceptionParameters)aspectParameters.getParameters(AspectParameters.exception)) != null) {
            ExceptionRule exceptionRule = new ExceptionRule();
            exceptionRule.setDescription(this.asDescription(exceptionParameters));
            List etParametersList = exceptionParameters.getParametersList(ExceptionParameters.thrown);
            if (etParametersList != null) {
                for (ExceptionThrownParameters etParameters : etParametersList) {
                    ExceptionThrownRule etr = this.asExceptionThrownRule(etParameters, null);
                    exceptionRule.putExceptionThrownRule(etr);
                }
            }
            aspectRule.setExceptionRule(exceptionRule);
        }
        this.assistant.resolveAdviceBeanClass(aspectRule);
        this.assistant.addAspectRule(aspectRule);
    }

    private void asBeanRule(BeanParameters beanParameters) throws IllegalRuleException {
        List propertyItemHolderParametersList;
        List argumentItemHolderParametersList;
        FilterParameters filterParameters;
        String description = this.asDescription(beanParameters);
        String id = StringUtils.emptyToNull(beanParameters.getString(BeanParameters.id));
        String className = StringUtils.emptyToNull(this.assistant.resolveAliasType(beanParameters.getString(BeanParameters.className)));
        String scan = beanParameters.getString(BeanParameters.scan);
        String mask = beanParameters.getString(BeanParameters.mask);
        String scope = beanParameters.getString(BeanParameters.scope);
        Boolean singleton = beanParameters.getBoolean(BeanParameters.singleton);
        String factoryBean = StringUtils.emptyToNull(beanParameters.getString(BeanParameters.factoryBean));
        String factoryMethod = StringUtils.emptyToNull(beanParameters.getString(BeanParameters.factoryMethod));
        String initMethod = StringUtils.emptyToNull(beanParameters.getString(BeanParameters.initMethod));
        String destroyMethod = StringUtils.emptyToNull(beanParameters.getString(BeanParameters.destroyMethod));
        Boolean lazyInit = beanParameters.getBoolean(BeanParameters.lazyInit);
        Boolean important = beanParameters.getBoolean(BeanParameters.important);
        BeanRule beanRule = className == null && scan == null && factoryBean != null ? BeanRule.newOfferedFactoryBeanInstance(id, factoryBean, factoryMethod, initMethod, destroyMethod, scope, singleton, lazyInit, important) : BeanRule.newInstance(id, className, scan, mask, initMethod, destroyMethod, factoryMethod, scope, singleton, lazyInit, important);
        if (description != null) {
            beanRule.setDescription(description);
        }
        if ((filterParameters = (FilterParameters)beanParameters.getParameters(BeanParameters.filter)) != null && (filterParameters.hasValue(FilterParameters.filterClass) || filterParameters.hasValue(FilterParameters.exclude))) {
            beanRule.setFilterParameters(filterParameters);
        }
        if ((argumentItemHolderParametersList = beanParameters.getParametersList(BeanParameters.arguments)) != null) {
            for (ItemHolderParameters itemHolderParameters : argumentItemHolderParametersList) {
                ItemRuleMap irm = this.asItemRuleMap(itemHolderParameters);
                irm = this.assistant.profiling(irm, beanRule.getConstructorArgumentItemRuleMap());
                beanRule.setConstructorArgumentItemRuleMap(irm);
            }
        }
        if ((propertyItemHolderParametersList = beanParameters.getParametersList(BeanParameters.properties)) != null) {
            for (ItemHolderParameters itemHolderParameters : propertyItemHolderParametersList) {
                ItemRuleMap irm = this.asItemRuleMap(itemHolderParameters);
                irm = this.assistant.profiling(irm, beanRule.getPropertyItemRuleMap());
                beanRule.setPropertyItemRuleMap(irm);
            }
        }
        this.assistant.resolveBeanClass(beanRule);
        this.assistant.resolveFactoryBeanClass(beanRule);
        this.assistant.addBeanRule(beanRule);
    }

    private BeanRule toInnerBeanRule(BeanParameters beanParameters) throws IllegalRuleException {
        List propertyItemHolderParametersList;
        List argumentItemHolderParametersList;
        String description = this.asDescription(beanParameters);
        String className = StringUtils.emptyToNull(this.assistant.resolveAliasType(beanParameters.getString(BeanParameters.className)));
        String factoryBean = StringUtils.emptyToNull(beanParameters.getString(BeanParameters.factoryBean));
        String factoryMethod = StringUtils.emptyToNull(beanParameters.getString(BeanParameters.factoryMethod));
        String initMethod = StringUtils.emptyToNull(beanParameters.getString(BeanParameters.initMethod));
        String destroyMethod = StringUtils.emptyToNull(beanParameters.getString(BeanParameters.destroyMethod));
        BeanRule beanRule = className == null && factoryBean != null ? BeanRule.newInnerOfferedFactoryBeanRule(factoryBean, factoryMethod, initMethod, destroyMethod) : BeanRule.newInnerBeanRule(className, initMethod, destroyMethod, factoryMethod);
        if (description != null) {
            beanRule.setDescription(description);
        }
        if ((argumentItemHolderParametersList = beanParameters.getParametersList(BeanParameters.arguments)) != null) {
            for (ItemHolderParameters itemHolderParameters : argumentItemHolderParametersList) {
                ItemRuleMap irm = this.asItemRuleMap(itemHolderParameters);
                irm = this.assistant.profiling(irm, beanRule.getConstructorArgumentItemRuleMap());
                beanRule.setConstructorArgumentItemRuleMap(irm);
            }
        }
        if ((propertyItemHolderParametersList = beanParameters.getParametersList(BeanParameters.properties)) != null) {
            for (ItemHolderParameters itemHolderParameters : propertyItemHolderParametersList) {
                ItemRuleMap irm = this.asItemRuleMap(itemHolderParameters);
                irm = this.assistant.profiling(irm, beanRule.getPropertyItemRuleMap());
                beanRule.setPropertyItemRuleMap(irm);
            }
        }
        this.assistant.resolveBeanClass(beanRule);
        this.assistant.resolveFactoryBeanClass(beanRule);
        this.assistant.addInnerBeanRule(beanRule);
        return beanRule;
    }

    private void asScheduleRule(ScheduleParameters scheduleParameters) throws IllegalRuleException {
        SchedulerParameters schedulerParameters;
        String description = this.asDescription(scheduleParameters);
        String id = StringUtils.emptyToNull(scheduleParameters.getString(AspectParameters.id));
        ScheduleRule scheduleRule = ScheduleRule.newInstance(id);
        if (description != null) {
            scheduleRule.setDescription(description);
        }
        if ((schedulerParameters = (SchedulerParameters)scheduleParameters.getParameters(ScheduleParameters.scheduler)) != null) {
            List jobParametersList;
            TriggerParameters triggerParameters;
            String schedulerBeanId = schedulerParameters.getString(SchedulerParameters.bean);
            if (!StringUtils.isEmpty(schedulerBeanId)) {
                scheduleRule.setSchedulerBeanId(schedulerBeanId);
            }
            if ((triggerParameters = (TriggerParameters)schedulerParameters.getParameters(SchedulerParameters.trigger)) != null) {
                ScheduleRule.updateTrigger(scheduleRule, triggerParameters);
            }
            if ((jobParametersList = scheduleParameters.getParametersList(ScheduleParameters.job)) != null) {
                for (ScheduledJobParameters jobParameters : jobParametersList) {
                    String translet = StringUtils.emptyToNull(jobParameters.getString(ScheduledJobParameters.translet));
                    Boolean disabled = jobParameters.getBoolean(ScheduledJobParameters.disabled);
                    ScheduledJobRule scheduledJobRule = ScheduledJobRule.newInstance(scheduleRule, translet, disabled);
                    scheduleRule.addScheduledJobRule(scheduledJobRule);
                }
            }
        }
        this.assistant.addScheduleRule(scheduleRule);
    }

    private void asTransletRule(TransletParameters transletParameters) throws IllegalRuleException {
        ExceptionParameters exceptionParameters;
        List responseParametersList;
        List contentParametersList;
        ContentsParameters contentsParameters;
        RedirectParameters redirectParameters;
        ForwardParameters forwardParameters;
        DispatchParameters dispatchParameters;
        TransformParameters transformParameters;
        List actionParametersList;
        List attributeItemHolderParametersList;
        List parameterItemHolderParametersList;
        RequestParameters requestParameters;
        String description = this.asDescription(transletParameters);
        String name = StringUtils.emptyToNull(transletParameters.getString(TransletParameters.name));
        String scan = transletParameters.getString(TransletParameters.scan);
        String mask = transletParameters.getString(TransletParameters.mask);
        String method = transletParameters.getString(TransletParameters.method);
        TransletRule transletRule = TransletRule.newInstance(name, mask, scan, method);
        if (description != null) {
            transletRule.setDescription(description);
        }
        if ((requestParameters = (RequestParameters)transletParameters.getParameters(TransletParameters.request)) != null) {
            this.asRequestRule(requestParameters, transletRule);
        }
        if ((parameterItemHolderParametersList = transletParameters.getParametersList(TransletParameters.parameters)) != null) {
            for (Object itemHolderParameters : parameterItemHolderParametersList) {
                ItemRuleMap irm = this.asItemRuleMap((ItemHolderParameters)itemHolderParameters);
                RequestRule requestRule = transletRule.touchRequestRule(false);
                irm = this.assistant.profiling(irm, requestRule.getParameterItemRuleMap());
                requestRule.setParameterItemRuleMap(irm);
            }
        }
        if ((attributeItemHolderParametersList = transletParameters.getParametersList(TransletParameters.attributes)) != null) {
            for (ItemHolderParameters itemHolderParameters : attributeItemHolderParametersList) {
                ItemRuleMap irm = this.asItemRuleMap(itemHolderParameters);
                RequestRule requestRule = transletRule.touchRequestRule(false);
                irm = this.assistant.profiling(irm, requestRule.getAttributeItemRuleMap());
                requestRule.setAttributeItemRuleMap(irm);
            }
        }
        if ((actionParametersList = transletParameters.getParametersList(TransletParameters.action)) != null && !actionParametersList.isEmpty()) {
            ContentList contentList = new ContentList(false);
            ActionList actionList = new ActionList(false);
            contentList.addActionList(actionList);
            for (ActionParameters actionParameters : actionParametersList) {
                this.asActionRule(actionParameters, actionList);
            }
            transletRule.setContentList(contentList);
        }
        if ((transformParameters = (TransformParameters)transletParameters.getParameters(TransletParameters.transform)) != null) {
            this.asTransformRule(transformParameters, (ResponseRuleApplicable)transletRule);
        }
        if ((dispatchParameters = (DispatchParameters)transletParameters.getParameters(TransletParameters.dispatch)) != null) {
            this.asDispatchRule(dispatchParameters, (ResponseRuleApplicable)transletRule);
        }
        if ((forwardParameters = (ForwardParameters)transletParameters.getParameters(TransletParameters.forward)) != null) {
            this.asForwardRule(forwardParameters, transletRule);
        }
        if ((redirectParameters = (RedirectParameters)transletParameters.getParameters(TransletParameters.redirect)) != null) {
            this.asRedirectRule(redirectParameters, (ResponseRuleApplicable)transletRule);
        }
        if ((contentsParameters = (ContentsParameters)transletParameters.getParameters(TransletParameters.contents)) != null) {
            ContentList contentList = this.asContentList(contentsParameters);
            transletRule.setContentList(contentList);
        }
        if ((contentParametersList = transletParameters.getParametersList(TransletParameters.content)) != null) {
            ContentList contentList = new ContentList(false);
            for (ContentParameters contentParameters : contentParametersList) {
                ActionList actionList = this.asActionList(contentParameters);
                contentList.addActionList(actionList);
            }
            transletRule.setContentList(contentList);
        }
        if ((responseParametersList = transletParameters.getParametersList(TransletParameters.response)) != null) {
            for (ResponseParameters responseParameters : responseParametersList) {
                this.asResponseRule(responseParameters, transletRule);
            }
        }
        if ((exceptionParameters = (ExceptionParameters)transletParameters.getParameters(TransletParameters.exception)) != null) {
            ExceptionRule exceptionRule = new ExceptionRule();
            exceptionRule.setDescription(this.asDescription(exceptionParameters));
            List etParametersList = exceptionParameters.getParametersList(ExceptionParameters.thrown);
            if (etParametersList != null) {
                for (ExceptionThrownParameters etParameters : etParametersList) {
                    ExceptionThrownRule etr = this.asExceptionThrownRule(etParameters, null);
                    exceptionRule.putExceptionThrownRule(etr);
                }
            }
            transletRule.setExceptionRule(exceptionRule);
        }
        this.assistant.addTransletRule(transletRule);
    }

    private void asRequestRule(RequestParameters requestParameters, TransletRule transletRule) throws IllegalRuleException {
        List attributeItemHolderParametersList;
        String method = requestParameters.getString(RequestParameters.method);
        String encoding = requestParameters.getString(RequestParameters.encoding);
        RequestRule requestRule = RequestRule.newInstance(method, encoding);
        List parameterItemHolderParametersList = requestParameters.getParametersList(RequestParameters.parameters);
        if (parameterItemHolderParametersList != null) {
            for (ItemHolderParameters itemHolderParameters : parameterItemHolderParametersList) {
                ItemRuleMap irm = this.asItemRuleMap(itemHolderParameters);
                irm = this.assistant.profiling(irm, requestRule.getParameterItemRuleMap());
                requestRule.setParameterItemRuleMap(irm);
            }
        }
        if ((attributeItemHolderParametersList = requestParameters.getParametersList(RequestParameters.attributes)) != null) {
            for (ItemHolderParameters itemHolderParameters : attributeItemHolderParametersList) {
                ItemRuleMap irm = this.asItemRuleMap(itemHolderParameters);
                irm = this.assistant.profiling(irm, requestRule.getAttributeItemRuleMap());
                requestRule.setAttributeItemRuleMap(irm);
            }
        }
        transletRule.setRequestRule(requestRule);
    }

    private void asResponseRule(ResponseParameters responseParameters, TransletRule transletRule) throws IllegalRuleException {
        RedirectParameters redirectParameters;
        ForwardParameters forwardParameters;
        DispatchParameters dispatchParameters;
        TransformParameters transformParameters;
        String name = responseParameters.getString(ResponseParameters.name);
        String encoding = responseParameters.getString(ResponseParameters.encoding);
        ResponseRule responseRule = ResponseRule.newInstance(name, encoding);
        List actionParametersList = responseParameters.getParametersList(ResponseParameters.action);
        if (actionParametersList != null && !actionParametersList.isEmpty()) {
            ActionList actionList = new ActionList(false);
            for (ActionParameters actionParameters : actionParametersList) {
                this.asActionRule(actionParameters, actionList);
            }
            responseRule.setActionList(actionList);
        }
        if ((transformParameters = (TransformParameters)responseParameters.getParameters(ResponseParameters.transform)) != null) {
            this.asTransformRule(transformParameters, (ResponseRuleApplicable)responseRule);
        }
        if ((dispatchParameters = (DispatchParameters)responseParameters.getParameters(ResponseParameters.dispatch)) != null) {
            this.asDispatchRule(dispatchParameters, (ResponseRuleApplicable)responseRule);
        }
        if ((forwardParameters = (ForwardParameters)responseParameters.getParameters(ResponseParameters.forward)) != null) {
            this.asForwardRule(forwardParameters, responseRule);
        }
        if ((redirectParameters = (RedirectParameters)responseParameters.getParameters(ResponseParameters.redirect)) != null) {
            this.asRedirectRule(redirectParameters, (ResponseRuleApplicable)responseRule);
        }
        transletRule.addResponseRule(responseRule);
    }

    private ContentList asContentList(ContentsParameters contentsParameters) throws IllegalRuleException {
        String name = contentsParameters.getString(ContentsParameters.name);
        ContentList contentList = ContentList.newInstance(name);
        List contentParametersList = contentsParameters.getParametersList(ContentsParameters.content);
        if (contentParametersList != null) {
            for (ContentParameters contentParameters : contentParametersList) {
                ActionList actionList = this.asActionList(contentParameters);
                contentList.addActionList(actionList);
            }
        }
        return contentList;
    }

    private ActionList asActionList(ContentParameters contentParameters) throws IllegalRuleException {
        String name = contentParameters.getString(ContentParameters.name);
        ActionList actionList = ActionList.newInstance(name);
        List actionParametersList = contentParameters.getParametersList(ContentParameters.action);
        if (actionParametersList != null) {
            for (ActionParameters actionParameters : actionParametersList) {
                this.asActionRule(actionParameters, actionList);
            }
        }
        return actionList;
    }

    private void asActionRule(ActionParameters actionParameters, ActionRuleApplicable actionRuleApplicable) throws IllegalRuleException {
        String actualName = actionParameters.getActualName();
        if (actualName == null) {
            throw new IllegalRuleException("No actual name");
        }
        switch (actualName) {
            case "action": {
                List propertyItemHolderParametersList;
                String id = StringUtils.emptyToNull(actionParameters.getString(ActionParameters.id));
                String beanIdOrClass = StringUtils.emptyToNull(actionParameters.getString(ActionParameters.bean));
                String method = StringUtils.emptyToNull(actionParameters.getString(ActionParameters.method));
                Boolean hidden = actionParameters.getBoolean(ActionParameters.hidden);
                InvokeActionRule invokeActionRule = InvokeActionRule.newInstance(id, beanIdOrClass, method, hidden);
                List argumentItemHolderParametersList = actionParameters.getParametersList(ActionParameters.arguments);
                if (argumentItemHolderParametersList != null) {
                    for (Object itemHolderParameters : argumentItemHolderParametersList) {
                        ItemRuleMap irm = this.asItemRuleMap((ItemHolderParameters)itemHolderParameters);
                        irm = this.assistant.profiling(irm, invokeActionRule.getArgumentItemRuleMap());
                        invokeActionRule.setArgumentItemRuleMap(irm);
                    }
                }
                if ((propertyItemHolderParametersList = actionParameters.getParametersList(ActionParameters.properties)) != null) {
                    for (ItemHolderParameters itemHolderParameters : propertyItemHolderParametersList) {
                        ItemRuleMap irm = this.asItemRuleMap(itemHolderParameters);
                        irm = this.assistant.profiling(irm, invokeActionRule.getPropertyItemRuleMap());
                        invokeActionRule.setPropertyItemRuleMap(irm);
                    }
                }
                this.assistant.resolveActionBeanClass(invokeActionRule);
                actionRuleApplicable.applyActionRule(invokeActionRule);
                break;
            }
            case "invoke": {
                List propertyItemHolderParametersList;
                String method = StringUtils.emptyToNull(actionParameters.getString(ActionParameters.method));
                Boolean hidden = actionParameters.getBoolean(ActionParameters.hidden);
                InvokeActionRule invokeActionRule = InvokeActionRule.newInstance(method, hidden);
                List argumentItemHolderParametersList = actionParameters.getParametersList(ActionParameters.arguments);
                if (argumentItemHolderParametersList != null) {
                    for (Object itemHolderParameters : argumentItemHolderParametersList) {
                        ItemRuleMap irm = this.asItemRuleMap((ItemHolderParameters)itemHolderParameters);
                        irm = this.assistant.profiling(irm, invokeActionRule.getArgumentItemRuleMap());
                        invokeActionRule.setArgumentItemRuleMap(irm);
                    }
                }
                if ((propertyItemHolderParametersList = actionParameters.getParametersList(ActionParameters.properties)) != null) {
                    for (ItemHolderParameters itemHolderParameters : propertyItemHolderParametersList) {
                        ItemRuleMap irm = this.asItemRuleMap(itemHolderParameters);
                        irm = this.assistant.profiling(irm, invokeActionRule.getPropertyItemRuleMap());
                        invokeActionRule.setPropertyItemRuleMap(irm);
                    }
                }
                this.assistant.resolveActionBeanClass(invokeActionRule);
                actionRuleApplicable.applyActionRule(invokeActionRule);
                break;
            }
            case "echo": {
                String id = StringUtils.emptyToNull(actionParameters.getString(ActionParameters.id));
                Boolean hidden = actionParameters.getBoolean(ActionParameters.hidden);
                List<ItemParameters> itemParametersList = actionParameters.getParametersList(ActionParameters.item);
                EchoActionRule echoActionRule = EchoActionRule.newInstance(id, hidden);
                ItemRuleMap attributeItemRuleMap = this.asItemRuleMap(null, itemParametersList);
                echoActionRule.setEchoItemRuleMap(attributeItemRuleMap);
                actionRuleApplicable.applyActionRule(echoActionRule);
                break;
            }
            case "headers": {
                String id = StringUtils.emptyToNull(actionParameters.getString(ActionParameters.id));
                Boolean hidden = actionParameters.getBoolean(ActionParameters.hidden);
                List<ItemParameters> itemParametersList = actionParameters.getParametersList(ActionParameters.item);
                HeaderActionRule headerActionRule = HeaderActionRule.newInstance(id, hidden);
                ItemRuleMap headerItemRuleMap = this.asItemRuleMap(null, itemParametersList);
                headerActionRule.setHeaderItemRuleMap(headerItemRuleMap);
                actionRuleApplicable.applyActionRule(headerActionRule);
                break;
            }
            case "include": {
                List attributeItemHolderParametersList;
                String id = StringUtils.emptyToNull(actionParameters.getString(ActionParameters.id));
                String translet = actionParameters.getString(ActionParameters.translet);
                translet = this.assistant.applyTransletNamePattern(translet);
                String method = StringUtils.emptyToNull(actionParameters.getString(ActionParameters.method));
                Boolean hidden = actionParameters.getBoolean(ActionParameters.hidden);
                IncludeActionRule includeActionRule = IncludeActionRule.newInstance(id, translet, method, hidden);
                List parameterItemHolderParametersList = actionParameters.getParametersList(ActionParameters.parameters);
                if (parameterItemHolderParametersList != null) {
                    for (ItemHolderParameters itemHolderParameters : parameterItemHolderParametersList) {
                        ItemRuleMap irm = this.asItemRuleMap(itemHolderParameters);
                        irm = this.assistant.profiling(irm, includeActionRule.getParameterItemRuleMap());
                        includeActionRule.setParameterItemRuleMap(irm);
                    }
                }
                if ((attributeItemHolderParametersList = actionParameters.getParametersList(ActionParameters.attributes)) != null) {
                    for (ItemHolderParameters itemHolderParameters : attributeItemHolderParametersList) {
                        ItemRuleMap irm = this.asItemRuleMap(itemHolderParameters);
                        irm = this.assistant.profiling(irm, includeActionRule.getAttributeItemRuleMap());
                        includeActionRule.setAttributeItemRuleMap(irm);
                    }
                }
                actionRuleApplicable.applyActionRule(includeActionRule);
                break;
            }
            case "choose": {
                this.asChooseRule(actionParameters, actionRuleApplicable);
                break;
            }
            default: {
                throw new IllegalRuleException("Illegal actual name: " + actualName);
            }
        }
    }

    private void asChooseRule(ActionParameters actionParameters, ActionRuleApplicable actionRuleApplicable) throws IllegalRuleException {
        List chooseWhenParametersList = actionParameters.getParametersList(ActionParameters.when);
        ChooseWhenParameters chooseOtherwiseParameters = (ChooseWhenParameters)actionParameters.getParameters(ActionParameters.otherwise);
        if (chooseWhenParametersList != null && !chooseWhenParametersList.isEmpty() || chooseOtherwiseParameters != null) {
            ChooseRule chooseRule = ChooseRule.newInstance();
            if (chooseWhenParametersList != null) {
                for (ChooseWhenParameters chooseWhenParameters : chooseWhenParametersList) {
                    ChooseWhenRule chooseWhenRule = chooseRule.newChooseWhenRule();
                    this.asChooseWhenRule(chooseWhenParameters, chooseWhenRule);
                }
            }
            if (chooseOtherwiseParameters != null) {
                ChooseWhenRule chooseWhenRule = chooseRule.newChooseWhenRule();
                this.asChooseWhenRule(chooseOtherwiseParameters, chooseWhenRule);
            }
            actionRuleApplicable.applyActionRule(chooseRule);
        }
    }

    private void asChooseWhenRule(ChooseWhenParameters chooseWhenParameters, ChooseWhenRule chooseWhenRule) throws IllegalRuleException {
        RedirectParameters redirectParameters;
        ForwardParameters forwardParameters;
        DispatchParameters dispatchParameters;
        TransformParameters transformParameters;
        String expression = StringUtils.emptyToNull(chooseWhenParameters.getString(ChooseWhenParameters.test));
        chooseWhenRule.setExpression(expression);
        List whenActionParametersList = chooseWhenParameters.getParametersList(ChooseWhenParameters.action);
        if (whenActionParametersList != null && !whenActionParametersList.isEmpty()) {
            for (ActionParameters actionParameters : whenActionParametersList) {
                this.asActionRule(actionParameters, chooseWhenRule);
            }
        }
        if ((transformParameters = (TransformParameters)chooseWhenParameters.getParameters(ChooseWhenParameters.transform)) != null) {
            this.asTransformRule(transformParameters, (ResponseRuleApplicable)chooseWhenRule);
        }
        if ((dispatchParameters = (DispatchParameters)chooseWhenParameters.getParameters(ChooseWhenParameters.dispatch)) != null) {
            this.asDispatchRule(dispatchParameters, (ResponseRuleApplicable)chooseWhenRule);
        }
        if ((forwardParameters = (ForwardParameters)chooseWhenParameters.getParameters(ChooseWhenParameters.forward)) != null) {
            this.asForwardRule(forwardParameters, chooseWhenRule);
        }
        if ((redirectParameters = (RedirectParameters)chooseWhenParameters.getParameters(ChooseWhenParameters.redirect)) != null) {
            this.asRedirectRule(redirectParameters, (ResponseRuleApplicable)chooseWhenRule);
        }
    }

    private ExceptionThrownRule asExceptionThrownRule(ExceptionThrownParameters exceptionThrownParameters, AspectAdviceRule aspectAdviceRule) throws IllegalRuleException {
        List<RedirectParameters> redirectParametersList;
        List<DispatchParameters> dispatchParametersList;
        List<TransformParameters> transformParametersList;
        ExceptionThrownRule exceptionThrownRule = new ExceptionThrownRule(aspectAdviceRule);
        String[] exceptionTypes = exceptionThrownParameters.getStringArray(ExceptionThrownParameters.type);
        exceptionThrownRule.setExceptionTypes(exceptionTypes);
        ActionParameters actionParameters = (ActionParameters)exceptionThrownParameters.getParameters(ExceptionThrownParameters.action);
        if (actionParameters != null) {
            this.asActionRule(actionParameters, exceptionThrownRule);
        }
        if ((transformParametersList = exceptionThrownParameters.getParametersList(ExceptionThrownParameters.transform)) != null && !transformParametersList.isEmpty()) {
            this.asTransformRule(transformParametersList, (ResponseRuleApplicable)exceptionThrownRule);
        }
        if ((dispatchParametersList = exceptionThrownParameters.getParametersList(ExceptionThrownParameters.dispatch)) != null && !dispatchParametersList.isEmpty()) {
            this.asDispatchRule(dispatchParametersList, (ResponseRuleApplicable)exceptionThrownRule);
        }
        if ((redirectParametersList = exceptionThrownParameters.getParametersList(ExceptionThrownParameters.redirect)) != null && !redirectParametersList.isEmpty()) {
            this.asRedirectRule(redirectParametersList, (ResponseRuleApplicable)exceptionThrownRule);
        }
        return exceptionThrownRule;
    }

    private void asTransformRule(List<TransformParameters> transformParametersList, ResponseRuleApplicable responseRuleApplicable) throws IllegalRuleException {
        for (TransformParameters transformParameters : transformParametersList) {
            this.asTransformRule(transformParameters, responseRuleApplicable);
        }
    }

    private void asTransformRule(TransformParameters transformParameters, ResponseRuleApplicable responseRuleApplicable) throws IllegalRuleException {
        String transformType = transformParameters.getString(TransformParameters.type);
        String contentType = transformParameters.getString(TransformParameters.contentType);
        String encoding = transformParameters.getString(TransformParameters.encoding);
        Boolean defaultResponse = transformParameters.getBoolean(TransformParameters.defaultResponse);
        Boolean pretty = transformParameters.getBoolean(TransformParameters.pretty);
        TransformRule transformRule = TransformRule.newInstance(transformType, contentType, encoding, defaultResponse, pretty);
        TemplateParameters templateParameters = (TemplateParameters)transformParameters.getParameters(TransformParameters.template);
        if (templateParameters != null) {
            String engine = templateParameters.getString(TemplateParameters.engine);
            String name = templateParameters.getString(TemplateParameters.name);
            String file = templateParameters.getString(TemplateParameters.file);
            String resource = templateParameters.getString(TemplateParameters.resource);
            String url = templateParameters.getString(TemplateParameters.url);
            String style = templateParameters.getString(TemplateParameters.style);
            String content = templateParameters.getString(TemplateParameters.content);
            String encoding2 = templateParameters.getString(TemplateParameters.encoding);
            Boolean noCache = templateParameters.getBoolean(TemplateParameters.noCache);
            TemplateRule templateRule = TemplateRule.newInstanceForBuiltin(engine, name, file, resource, url, style, content, encoding2, noCache);
            transformRule.setTemplateRule(templateRule);
            this.assistant.resolveBeanClass(templateRule.getTemplateTokens());
        }
        responseRuleApplicable.applyResponseRule(transformRule);
    }

    private void asDispatchRule(List<DispatchParameters> dispatchParametersList, ResponseRuleApplicable responseRuleApplicable) throws IllegalRuleException {
        for (DispatchParameters dispatchParameters : dispatchParametersList) {
            this.asDispatchRule(dispatchParameters, responseRuleApplicable);
        }
    }

    private void asDispatchRule(DispatchParameters dispatchParameters, ResponseRuleApplicable responseRuleApplicable) throws IllegalRuleException {
        String name = dispatchParameters.getString(DispatchParameters.name);
        String dispatcher = dispatchParameters.getString(DispatchParameters.dispatcher);
        String contentType = dispatchParameters.getString(DispatchParameters.contentType);
        String encoding = dispatchParameters.getString(DispatchParameters.encoding);
        Boolean defaultResponse = dispatchParameters.getBoolean(DispatchParameters.defaultResponse);
        DispatchRule dispatchRule = DispatchRule.newInstance(name, dispatcher, contentType, encoding, defaultResponse);
        responseRuleApplicable.applyResponseRule(dispatchRule);
    }

    private void asForwardRule(ForwardParameters forwardParameters, ResponseRuleApplicable responseRuleApplicable) throws IllegalRuleException {
        String contentType = forwardParameters.getString(ForwardParameters.contentType);
        String translet = StringUtils.emptyToNull(forwardParameters.getString(ForwardParameters.translet));
        String method = StringUtils.emptyToNull(forwardParameters.getString(ForwardParameters.method));
        Boolean defaultResponse = forwardParameters.getBoolean(ForwardParameters.defaultResponse);
        translet = this.assistant.applyTransletNamePattern(translet);
        ForwardRule forwardRule = ForwardRule.newInstance(contentType, translet, method, defaultResponse);
        List attributeItemHolderParametersList = (List)forwardParameters.getParameters(ForwardParameters.attributes);
        if (attributeItemHolderParametersList != null) {
            for (ItemHolderParameters itemHolderParameters : attributeItemHolderParametersList) {
                ItemRuleMap irm = this.asItemRuleMap(itemHolderParameters);
                irm = this.assistant.profiling(irm, forwardRule.getAttributeItemRuleMap());
                forwardRule.setAttributeItemRuleMap(irm);
            }
        }
        responseRuleApplicable.applyResponseRule(forwardRule);
    }

    private void asRedirectRule(List<RedirectParameters> redirectParametersList, ResponseRuleApplicable responseRuleApplicable) throws IllegalRuleException {
        for (RedirectParameters redirectParameters : redirectParametersList) {
            this.asRedirectRule(redirectParameters, responseRuleApplicable);
        }
    }

    private void asRedirectRule(RedirectParameters redirectParameters, ResponseRuleApplicable responseRuleApplicable) throws IllegalRuleException {
        String contentType = redirectParameters.getString(RedirectParameters.contentType);
        String path = redirectParameters.getString(RedirectParameters.path);
        String encoding = redirectParameters.getString(RedirectParameters.encoding);
        Boolean excludeNullParameters = redirectParameters.getBoolean(RedirectParameters.excludeNullParameters);
        Boolean excludeEmptyParameters = redirectParameters.getBoolean(RedirectParameters.excludeEmptyParameters);
        Boolean defaultResponse = redirectParameters.getBoolean(RedirectParameters.defaultResponse);
        RedirectRule redirectRule = RedirectRule.newInstance(contentType, path, encoding, excludeNullParameters, excludeEmptyParameters, defaultResponse);
        List parameterItemHolderParametersList = redirectParameters.getParametersList(RedirectParameters.parameters);
        if (parameterItemHolderParametersList != null) {
            for (ItemHolderParameters itemHolderParameters : parameterItemHolderParametersList) {
                ItemRuleMap irm = this.asItemRuleMap(itemHolderParameters);
                irm = this.assistant.profiling(irm, redirectRule.getParameterItemRuleMap());
                redirectRule.setParameterItemRuleMap(irm);
            }
        }
        responseRuleApplicable.applyResponseRule(redirectRule);
    }

    private void asTemplateRule(TemplateParameters templateParameters) throws IllegalRuleException {
        String id = StringUtils.emptyToNull(templateParameters.getString(TemplateParameters.id));
        String engine = StringUtils.emptyToNull(templateParameters.getString(TemplateParameters.engine));
        String name = StringUtils.emptyToNull(templateParameters.getString(TemplateParameters.name));
        String file = StringUtils.emptyToNull(templateParameters.getString(TemplateParameters.file));
        String resource = StringUtils.emptyToNull(templateParameters.getString(TemplateParameters.resource));
        String url = StringUtils.emptyToNull(templateParameters.getString(TemplateParameters.url));
        String content = StringUtils.emptyToNull(templateParameters.getString(TemplateParameters.content));
        String style = StringUtils.emptyToNull(templateParameters.getString(TemplateParameters.style));
        String encoding = templateParameters.getString(TemplateParameters.encoding);
        Boolean noCache = templateParameters.getBoolean(TemplateParameters.noCache);
        TemplateRule templateRule = TemplateRule.newInstance(id, engine, name, file, resource, url, content, style, encoding, noCache);
        this.assistant.addTemplateRule(templateRule);
    }

    private ItemRuleMap asItemRuleMap(ItemHolderParameters itemHolderParameters) throws IllegalRuleException {
        String profile = itemHolderParameters.getProfile();
        List<ItemParameters> itemParametersList = itemHolderParameters.getItemParametersList();
        return this.asItemRuleMap(profile, itemParametersList);
    }

    private ItemRuleMap asItemRuleMap(String profile, List<ItemParameters> itemParametersList) throws IllegalRuleException {
        ItemRuleMap itemRuleMap = this.toItemRuleMap(itemParametersList);
        if (itemRuleMap != null) {
            itemRuleMap.setProfile(profile);
            for (ItemRule itemRule : itemRuleMap.values()) {
                this.assistant.resolveBeanClass(itemRule);
            }
        }
        return itemRuleMap;
    }

    private ItemRuleMap toItemRuleMap(List<ItemParameters> itemParametersList) throws IllegalRuleException {
        if (itemParametersList == null || itemParametersList.isEmpty()) {
            return null;
        }
        ItemRuleMap itemRuleMap = new ItemRuleMap();
        for (ItemParameters parameters : itemParametersList) {
            itemRuleMap.putItemRule(this.toItemRule(parameters));
        }
        return itemRuleMap;
    }

    private ItemRule toItemRule(ItemParameters itemParameters) throws IllegalRuleException {
        Boolean secret;
        Boolean mandatory;
        Boolean tokenize;
        String valueType;
        String name;
        String type = itemParameters.getString(ItemParameters.type);
        ItemRule itemRule = ItemRule.newInstance(type, name = itemParameters.getString(ItemParameters.name), valueType = itemParameters.getString(ItemParameters.valueType), tokenize = itemParameters.getBoolean(ItemParameters.tokenize), mandatory = itemParameters.getBoolean(ItemParameters.mandatory), secret = itemParameters.getBoolean(ItemParameters.secret));
        if (itemRule.isListableType()) {
            if (itemRule.getValueType() == ItemValueType.BEAN) {
                List beanParametersList = itemParameters.getParametersList(ItemParameters.bean);
                if (beanParametersList != null) {
                    for (BeanParameters beanParameters : beanParametersList) {
                        BeanRule beanRule = this.toInnerBeanRule(beanParameters);
                        itemRule.addBeanRule(beanRule);
                    }
                }
            } else {
                List<String> stringList = itemParameters.getStringList(ItemParameters.value);
                if (stringList != null) {
                    for (String value : stringList) {
                        itemRule.addValue(value);
                    }
                }
            }
        } else if (itemRule.isMappableType()) {
            List entryParametersList = itemParameters.getParametersList(ItemParameters.entry);
            if (entryParametersList != null) {
                if (itemRule.getValueType() == ItemValueType.BEAN) {
                    for (EntryParameters parameters : entryParametersList) {
                        if (parameters == null) continue;
                        String entryName = parameters.getString(EntryParameters.name);
                        BeanParameters beanParameters = (BeanParameters)parameters.getParameters(EntryParameters.bean);
                        if (beanParameters != null) {
                            BeanRule beanRule = this.toInnerBeanRule(beanParameters);
                            itemRule.putBeanRule(entryName, beanRule);
                            continue;
                        }
                        itemRule.putBeanRule(entryName, null);
                    }
                } else {
                    for (EntryParameters parameters : entryParametersList) {
                        if (parameters == null) continue;
                        String entryName = parameters.getString(EntryParameters.name);
                        String entryValue = parameters.getString(EntryParameters.value);
                        itemRule.putValue(entryName, entryValue);
                    }
                }
            }
        } else if (itemRule.getValueType() == ItemValueType.BEAN) {
            BeanParameters beanParameters = (BeanParameters)itemParameters.getParameters(ItemParameters.bean);
            if (beanParameters != null) {
                BeanRule beanRule = this.toInnerBeanRule(beanParameters);
                itemRule.setBeanRule(beanRule);
            }
        } else {
            List<String> stringList = itemParameters.getStringList(ItemParameters.value);
            if (stringList != null && !stringList.isEmpty()) {
                itemRule.setValue(stringList.get(0));
            }
        }
        return itemRule;
    }
}

